set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7717600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2433243',
      2,
      0,
      0,
      1,
      '0011',
      1.088980,
      1,
      NULL,
      NULL,
      ' 8-28-1983',
      19,
      NULL,
      2,
      0,
      0.987153,
      ' 0- 4-1989',
      5.204305,
      2.965728,
      321,
      NULL,
      0,
      ' 9-24-1986',
      '10-12-1976',
      ' 9-28-1995',
      NULL,
      NULL,
      3.792844,
      1.224894,
      NULL,
      0,
      NULL,
      1.671865,
      NULL,
      115,
      3,
      17,
      NULL,
      NULL,
      5.569704,
      0,
      18.563007,
      4,
      1,
      3.462975,
      3.389866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      1,
      0,
      1,
      1,
      0,
      3,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.314202,
      NULL,
      NULL,
      3,
      1,
      1.697807,
      2.036070,
      1,
      NULL,
      0.451421,
      1.810299,
      0,
      1.092701,
      1,
      1,
      0.226172,
      1,
      1.003276,
      1.717327,
      0.050648,
      2,
      3.008975,
      NULL,
      NULL,
      0,
      5.008859,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0.779044,
      0,
      1,
      1,
      NULL,
      1.707628,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      3,
      5,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      2,
      ' 0-17-1989',
      508,
      ' 6-21-1997',
      1.163724,
      2,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      4,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1503,
      NULL,
      0.937129,
      5,
      1.057081,
      2.017732,
      1,
      NULL,
      2.249405,
      3,
      1,
      3.228284,
      0,
      2,
      2,
      2,
      NULL,
      7.908304,
      NULL,
      1.570748,
      3,
      1.682134,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.489710,
      0.274421,
      1,
      0,
      0.527625,
      0,
      1.919648,
      20,
      0.360662,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835053,
      2,
      2,
      0,
      3,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2.259426,
      NULL,
      0,
      0,
      1,
      2,
      0,
      1,
      0,
      NULL,
      1.757602,
      1,
      1.672719,
      0.296869,
      1,
      3,
      3,
      0.289241,
      3.398062,
      8.522714,
      1,
      3,
      4,
      5,
      1,
      0,
      5.792910,
      NULL,
      3.585274,
      3,
      11,
      3,
      3.993553,
      NULL,
      48,
      23,
      17,
      0,
      NULL,
      2.211384,
      NULL,
      '',
      NULL,
      2.489211,
      '23400',
      NULL,
      '',
      4,
      '3134',
      '00230',
      '',
      2.111001,
      47,
      109.475175,
      16,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287348,
      NULL,
      1.579185,
      NULL,
      0.367664,
      1.943600,
      NULL,
      1,
      1.391259,
      1.067423,
      1,
      1.200690,
      1,
      NULL,
      NULL,
      1.882786,
      1.337639,
      1,
      NULL,
      1.994504,
      2.436388,
      2,
      1.386790,
      0,
      3,
      0.635414,
      1.676001,
      0,
      NULL,
      NULL,
      3.633210,
      0,
      1,
      NULL,
      0.077253,
      0,
      2,
      4,
      4,
      0,
      1.116580,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.755885,
      1.364441,
      0.481132,
      3.688870,
      1,
      3.281404,
      NULL,
      NULL,
      1.661543,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.536716,
      1.988749,
      0.827929,
      1.401460,
      1,
      0.004259,
      NULL,
      NULL,
      NULL,
      0,
      1.143335,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.502019,
      NULL,
      NULL,
      NULL,
      1.873788,
      NULL,
      NULL,
      1,
      NULL,
      1.993730,
      1.331551,
      1.882823,
      0,
      1,
      NULL,
      NULL,
      0.283143,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.080995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423243,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.315284,
      0.113973,
      2,
      3.142099,
      3.593387,
      0.624126,
      0,
      NULL,
      6.483977,
      5.391831,
      8,
      3,
      0,
      2,
      1,
      NULL,
      1.809732,
      0.753555,
      0.676200,
      2.105881,
      NULL,
      NULL,
      1.476138,
      3.952428,
      4.695430,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183681,
      1,
      NULL,
      1.795706,
      1.937682,
      1.256909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.116626,
      1,
      1.191219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589479,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446678,
      1.103944,
      1,
      NULL,
      1.480777,
      1,
      NULL,
      NULL,
      3,
      1,
      0.515242,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      48,
      26.591544,
      NULL,
      0,
      1.905633,
      0,
      0,
      1.221774,
      0.996639,
      0.342780,
      1,
      NULL,
      0,
      1.047981,
      1.350508,
      1.039057,
      0,
      1.635273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.392825,
      NULL,
      1,
      NULL,
      0.888252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.620785,
      NULL,
      0,
      NULL,
      1,
      1.751069,
      0.079644,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951723,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.581871,
      1,
      2.520342,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.740384,
      0.775017,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.462632,
      NULL,
      1.304308,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.439794,
      NULL,
      1.179115,
      NULL,
      0.203848,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.133214,
      NULL,
      0.494561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0.334257,
      NULL,
      NULL,
      60.281647,
      0.376080,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      3.747465,
      0,
      2,
      3,
      0.637944,
      NULL,
      0.487985,
      2,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      1.344014,
      NULL,
      0.180857,
      0,
      NULL,
      1.991451,
      0,
      NULL,
      1.619741,
      0,
      NULL,
      3.491702,
      1.983652,
      NULL,
      2.828463,
      2.187400,
      NULL,
      0.830613,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.923611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.870535,
      NULL,
      1.643656,
      NULL,
      0,
      2,
      4,
      0,
      2,
      NULL,
      55.929513,
      2,
      NULL,
      0.354895,
      1,
      '14023',
      '20104',
      '',
      3.490321,
      NULL,
      '',
      '',
      0,
      '2230',
      '02440',
      '');
commit;
end;
/


