set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6508568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '24',
      9,
      30.002304,
      '2222400',
      3.683628,
      NULL,
      1,
      0,
      '1030',
      0.173051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.223332,
      ' 2-10-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 4-25-1977',
      ' 7-22-1996',
      '11-18-1984',
      NULL,
      2,
      NULL,
      0.459100,
      1,
      3,
      3,
      1.058792,
      NULL,
      6,
      2,
      18,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.117089,
      1.248970,
      0.515054,
      0.831843,
      1.280647,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      5,
      1,
      0,
      4,
      2,
      1,
      2,
      1,
      2,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1.093680,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.044882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      4,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      ' 3-25-2002',
      NULL,
      ' 9-11-1980',
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.793341,
      1,
      NULL,
      0.653697,
      NULL,
      0.097089,
      NULL,
      2.960378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115185,
      NULL,
      3.525740,
      5.244963,
      1.848704,
      2.667981,
      1.786501,
      NULL,
      NULL,
      NULL,
      0,
      5.774061,
      1.482881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.659357,
      1,
      1,
      NULL,
      3,
      129.355726,
      0.923527,
      0.981559,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.602465,
      1,
      2,
      3,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      3,
      1,
      5,
      2.370334,
      4,
      NULL,
      0,
      4.505053,
      1.014993,
      NULL,
      NULL,
      0.727411,
      0.200538,
      0,
      1.592685,
      1,
      0,
      3.604344,
      1.487188,
      NULL,
      NULL,
      NULL,
      3.300298,
      9.896890,
      6,
      2,
      4,
      NULL,
      NULL,
      1,
      2,
      1,
      3.072381,
      NULL,
      3.180289,
      61,
      NULL,
      NULL,
      1.298756,
      0,
      2,
      1,
      '',
      '',
      '',
      0,
      '23034',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.224206,
      29,
      14.377780,
      NULL,
      3,
      41.747869,
      NULL,
      4,
      NULL,
      0.577962,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.199347,
      0,
      0.331700,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.063822,
      2,
      0,
      1.707050,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.981259,
      NULL,
      NULL,
      1.853002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.431482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.518454,
      NULL,
      NULL,
      0.700000,
      NULL,
      NULL,
      0.195051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0.032167,
      NULL,
      0,
      3,
      2.898801,
      0.336352,
      1,
      3.081878,
      NULL,
      7.102357,
      3,
      NULL,
      0,
      2.163188,
      NULL,
      0.779667,
      NULL,
      NULL,
      5.930478,
      2.637233,
      2.667955,
      1.321342,
      NULL,
      NULL,
      0.356941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769983,
      NULL,
      NULL,
      1.296158,
      NULL,
      NULL,
      2.963931,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.331442,
      NULL,
      NULL,
      0,
      6,
      4,
      1,
      NULL,
      NULL,
      0.592136,
      1,
      NULL,
      0.481343,
      2,
      2.688508,
      0.843466,
      2,
      2.014439,
      2.829249,
      2,
      6.995284,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      1.893577,
      0.400202,
      1.337085,
      NULL,
      1.085850,
      NULL,
      5.797471,
      1.954980,
      1,
      3,
      4,
      NULL,
      3,
      2,
      3,
      1.541717,
      0,
      1.008467,
      1,
      1.855839,
      0.687325,
      NULL,
      NULL,
      0.916329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.852940,
      NULL,
      NULL,
      3.161929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0.203228,
      1,
      2.474499,
      0,
      1,
      2.681182,
      3.132438,
      NULL,
      NULL,
      NULL,
      5.824088,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.237688,
      NULL,
      NULL,
      NULL,
      1.125988,
      0.298494,
      NULL,
      NULL,
      0.287273,
      1.773002,
      NULL,
      NULL,
      0.744412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.837810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235005,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1.520233,
      NULL,
      NULL,
      1.015361,
      2.084383,
      NULL,
      NULL,
      2.613785,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.301767,
      NULL,
      NULL,
      3.743811,
      1.178508,
      NULL,
      NULL,
      14,
      5.288618,
      NULL,
      NULL,
      1.845942,
      NULL,
      NULL,
      NULL,
      0.707372,
      7,
      NULL,
      3,
      36.096498,
      4,
      0.129271,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1.480723,
      NULL,
      NULL,
      1.888613,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037134,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0.763571,
      NULL,
      0,
      NULL,
      1.002113,
      NULL,
      0.692704,
      1,
      1,
      1.086766,
      1.500875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      NULL,
      3,
      5.094071,
      NULL,
      0,
      2,
      1.414652,
      1,
      3,
      NULL,
      1,
      2.011665,
      2,
      1,
      1,
      NULL,
      NULL,
      2.815912,
      3,
      1,
      0,
      0.547266,
      0.993556,
      1.229387,
      2,
      2.011549,
      3.720755,
      1,
      1.079105,
      3.443484,
      NULL,
      3.681556,
      0.845007,
      1,
      NULL,
      NULL,
      2,
      2.117830,
      0.654334,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877876,
      0,
      1,
      0,
      0.129878,
      0.892134,
      NULL,
      0,
      6,
      1,
      0.058391,
      3.564738,
      28.857883,
      23,
      3,
      3.375790,
      3.433813,
      '21440',
      '',
      '',
      3,
      '32340',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


