set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8535651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '23',
      11.178516,
      28,
      '0143204',
      1,
      1,
      NULL,
      NULL,
      '4123',
      1.227529,
      1.763354,
      NULL,
      NULL,
      ' 0-19-1991',
      55.458920,
      NULL,
      NULL,
      1,
      0.331125,
      ' 9-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7- 4-1974',
      ' 6-16-1995',
      ' 9- 1-1982',
      1,
      1,
      3,
      NULL,
      NULL,
      1.243759,
      0,
      0.970757,
      NULL,
      NULL,
      NULL,
      2.837160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.450987,
      1,
      1,
      0.668804,
      3,
      0,
      0,
      NULL,
      0.333225,
      0,
      1.227647,
      1,
      3,
      1,
      2,
      5,
      3,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0.272050,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      0.045595,
      0,
      1,
      1.516535,
      NULL,
      2.619744,
      1.280081,
      0.164481,
      0,
      1.551549,
      1.970330,
      3,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      7.378589,
      0,
      1,
      1.818240,
      0.948847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      5.098353,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0.834270,
      1,
      4,
      3,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      2,
      0,
      0,
      NULL,
      1,
      1,
      1.818142,
      NULL,
      ' 4-26-1976',
      13.647522,
      ' 8-25-1998',
      15,
      1.569624,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.209892,
      1,
      3,
      1.066684,
      NULL,
      NULL,
      NULL,
      1.004886,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.666124,
      1.609746,
      0.939457,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.024587,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.157519,
      2,
      3,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      2,
      1,
      1,
      2,
      1.834849,
      1,
      1,
      NULL,
      0.626746,
      0,
      2.446527,
      1.321459,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.439056,
      9,
      3,
      NULL,
      NULL,
      2,
      5,
      NULL,
      3,
      1.028548,
      15.106755,
      2,
      2,
      43,
      NULL,
      42,
      NULL,
      1,
      1.179479,
      1,
      '20422',
      '42322',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      16,
      22.852006,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.682028,
      1.277711,
      NULL,
      NULL,
      1.925688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.058625,
      NULL,
      NULL,
      NULL,
      3.230420,
      2.842084,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.244222,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.594262,
      0.114081,
      1.536958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736766,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.198698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.057397,
      0.777536,
      1,
      0,
      0.602375,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.039589,
      1,
      NULL,
      NULL,
      1.412345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.388762,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.650704,
      1.380732,
      4.392494,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.544638,
      0,
      NULL,
      NULL,
      3,
      3.899194,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4.751230,
      8.685772,
      NULL,
      2,
      NULL,
      0.507233,
      NULL,
      NULL,
      3,
      NULL,
      0.286086,
      NULL,
      1.362590,
      2.314526,
      2.459254,
      3.351251,
      3.190115,
      3.147921,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      1,
      0.880649,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386679,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.355505,
      NULL,
      NULL,
      1,
      1.171874,
      NULL,
      0.081958,
      NULL,
      2.106457,
      NULL,
      NULL,
      NULL,
      1,
      3.720267,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.137272,
      NULL,
      NULL,
      NULL,
      2.932729,
      NULL,
      NULL,
      1.853310,
      0.291333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.699617,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.163632,
      2.195341,
      NULL,
      NULL,
      1.794991,
      1.522825,
      NULL,
      NULL,
      NULL,
      0.699815,
      NULL,
      NULL,
      0,
      1.218581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.209938,
      NULL,
      NULL,
      NULL,
      2.231485,
      12.217078,
      1.483308,
      NULL,
      NULL,
      NULL,
      0.447764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936231,
      NULL,
      0,
      NULL,
      1.904528,
      1.189204,
      1.485289,
      NULL,
      1.551295,
      1,
      0.170388,
      1,
      1.685977,
      1.520899,
      NULL,
      0.642892,
      0.304128,
      NULL,
      0,
      1,
      1,
      0.038462,
      1.720645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151135,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.307275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.858353,
      NULL,
      3.584384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612729,
      1.042070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987904,
      1,
      NULL,
      0,
      NULL,
      0.339785,
      NULL,
      NULL,
      NULL,
      0.411298,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.171176,
      33.812170,
      NULL,
      2.938721,
      2.303413,
      0.285873,
      2.717008,
      2,
      1,
      0,
      3.726316,
      1.700363,
      3.216091,
      2,
      0,
      11,
      0.047705,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.149401,
      0,
      NULL,
      1,
      3.834750,
      0,
      1.961814,
      0.441654,
      1,
      NULL,
      0,
      1.617477,
      0,
      NULL,
      1.652573,
      1,
      NULL,
      0,
      1.566087,
      1.013423,
      NULL,
      0.034601,
      0.359783,
      2,
      0,
      0,
      0,
      1,
      0,
      1,
      3,
      1.718395,
      0.693309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.495507,
      1,
      1,
      1,
      3,
      4,
      NULL,
      0,
      NULL,
      NULL,
      31,
      55,
      2,
      NULL,
      2,
      '43012',
      '41221',
      '',
      1.704028,
      '',
      '',
      NULL,
      1.009166,
      '',
      '',
      '');
commit;
end;
/


