set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936802';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2104404',
      1,
      1,
      2,
      NULL,
      '2441',
      1,
      0,
      NULL,
      NULL,
      ' 0- 1-1990',
      13,
      NULL,
      5,
      NULL,
      NULL,
      ' 6-20-1988',
      95,
      0.919735,
      46.373026,
      80.582858,
      0,
      '11-18-1992',
      ' 2-14-1997',
      ' 9-27-1993',
      NULL,
      0,
      3.822936,
      NULL,
      1,
      1,
      0,
      1.172299,
      1.499127,
      569,
      0,
      3,
      6,
      NULL,
      23.870428,
      3,
      15.748009,
      NULL,
      0,
      6,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0.929919,
      0.235407,
      NULL,
      4,
      0,
      3,
      0.867153,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.933239,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      0,
      1,
      2.473375,
      1,
      2.411878,
      1,
      0.603954,
      1.308380,
      3.583098,
      0,
      1,
      0.841911,
      1,
      NULL,
      1.427423,
      0,
      1,
      2,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136299,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      7.205847,
      1,
      0,
      0,
      1,
      1.976662,
      NULL,
      0,
      5,
      0,
      0,
      3,
      NULL,
      5,
      5,
      3,
      1,
      5,
      1,
      1,
      3,
      3,
      5,
      2,
      1,
      NULL,
      3,
      3,
      5,
      1,
      0,
      3,
      NULL,
      4,
      1,
      ' 5- 1-1996',
      51.401031,
      ' 8- 1-1974',
      1066.464611,
      3,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0.923272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.823787,
      0.906874,
      1.471676,
      0.255905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.678571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.352426,
      0,
      NULL,
      1946.127712,
      1.488126,
      0.555637,
      187.578678,
      106.158871,
      NULL,
      NULL,
      0.090767,
      1,
      1,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      4.378963,
      0,
      2,
      NULL,
      0.134764,
      1.029936,
      NULL,
      0.091959,
      NULL,
      0,
      0.699107,
      0.815047,
      NULL,
      1,
      1,
      NULL,
      2,
      3,
      0.134191,
      1.145106,
      0,
      1.960972,
      2,
      8.933046,
      4.139962,
      NULL,
      NULL,
      0.820010,
      1.767510,
      1,
      NULL,
      23,
      0,
      0.113411,
      NULL,
      19,
      10,
      NULL,
      1,
      1,
      2,
      '40041',
      '41243',
      NULL,
      0.550597,
      '',
      '',
      '',
      NULL,
      '30203',
      '',
      '',
      3,
      22.357177,
      786.394852,
      49.092591,
      3,
      36,
      4.753893,
      54.036060,
      5,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.805141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.708675,
      NULL,
      NULL,
      2.497179,
      0,
      3.594081,
      1,
      NULL,
      NULL,
      0.551832,
      NULL,
      NULL,
      0.544041,
      NULL,
      NULL,
      1,
      0.121888,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.805053,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.376503,
      1.342043,
      NULL,
      NULL,
      1.972172,
      NULL,
      NULL,
      NULL,
      0,
      1.032889,
      0.264854,
      3,
      2.124472,
      NULL,
      NULL,
      0,
      3,
      0.165793,
      0.832916,
      0.492493,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.212864,
      0.782355,
      NULL,
      8,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.228307,
      NULL,
      NULL,
      NULL,
      0.911868,
      NULL,
      NULL,
      2.916209,
      1,
      NULL,
      NULL,
      3,
      0.131427,
      NULL,
      NULL,
      NULL,
      7.425598,
      3,
      1.383209,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037756,
      NULL,
      NULL,
      2.561235,
      0,
      NULL,
      2,
      0.516121,
      3,
      2,
      0.799404,
      2,
      2.665094,
      NULL,
      7,
      4,
      NULL,
      NULL,
      2,
      1,
      2.861401,
      0.204074,
      1,
      1,
      1.992141,
      1.254480,
      0.348090,
      1,
      3.828548,
      0.441053,
      1.086454,
      1,
      1,
      0,
      1.806068,
      1,
      NULL,
      0,
      NULL,
      0.777250,
      NULL,
      1.897123,
      3,
      NULL,
      7,
      6.594646,
      1.245237,
      NULL,
      3.650994,
      1,
      NULL,
      0.212360,
      0,
      1,
      1.387285,
      1,
      3.563937,
      NULL,
      NULL,
      1.107329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356693,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.249452,
      NULL,
      NULL,
      1.878244,
      NULL,
      NULL,
      1.098124,
      1,
      1,
      1,
      1,
      1.561376,
      NULL,
      NULL,
      NULL,
      0.535712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.637961,
      NULL,
      NULL,
      NULL,
      2.501888,
      NULL,
      NULL,
      NULL,
      0.181837,
      NULL,
      NULL,
      NULL,
      0.825529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.617337,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      338.601784,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.915260,
      176.117051,
      13.879179,
      0,
      NULL,
      11.117711,
      2.918363,
      2.430662,
      28.697629,
      3.586431,
      106,
      NULL,
      339.844203,
      16.945410,
      1,
      1.121294,
      1,
      1,
      0,
      1.623809,
      0.476257,
      1.910475,
      1.629972,
      1,
      1,
      0,
      1.618170,
      1,
      0,
      0.861127,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      1.585305,
      NULL,
      4,
      NULL,
      11.525620,
      3,
      2.964154,
      0.333190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.730773,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.802777,
      NULL,
      0.164031,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041047,
      NULL,
      NULL,
      NULL,
      3,
      6,
      6,
      2.059036,
      NULL,
      1.401266,
      6,
      NULL,
      2,
      1.617106,
      3.895535,
      '23101',
      '22142',
      '',
      1.316033,
      '',
      '',
      NULL,
      0,
      '10321',
      '',
      '');
commit;
end;
/


