set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      '10',
      6,
      36,
      '0211001',
      2,
      1.075508,
      0,
      2,
      '3230',
      4.302605,
      0,
      NULL,
      NULL,
      ' 4- 3-1996',
      35.768707,
      25,
      NULL,
      0,
      3.231583,
      ' 2- 0-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '10-26-2002',
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      11.466455,
      3.574811,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      1,
      1,
      0,
      0,
      NULL,
      9.589098,
      NULL,
      1,
      0,
      3,
      1,
      0,
      3,
      3,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.376990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      5,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1.418691,
      0,
      0,
      NULL,
      1,
      2.637834,
      NULL,
      1.746885,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      0,
      1,
      4,
      4,
      4,
      1,
      5,
      NULL,
      5,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      5,
      NULL,
      NULL,
      8.932124,
      0,
      ' 4-27-1993',
      75,
      ' 6-23-1987',
      450.163016,
      0.884904,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.769943,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891354,
      0.068576,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595867,
      1.776557,
      1,
      1,
      0,
      0,
      0.929635,
      NULL,
      0.158099,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.336738,
      0,
      0,
      1,
      2,
      3,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      3,
      1.803686,
      3.856911,
      NULL,
      0,
      9.183864,
      0.800950,
      0.061369,
      NULL,
      NULL,
      0.835022,
      NULL,
      0.688949,
      NULL,
      1,
      1.458927,
      1.162581,
      0.861302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.334504,
      '02401',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.122537,
      NULL,
      NULL,
      NULL,
      1,
      2,
      11,
      6.686070,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.955724,
      1.383129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.346823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.566607,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.474719,
      5.340490,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.124779,
      NULL,
      NULL,
      NULL,
      NULL,
      2.516217,
      0,
      0.989673,
      NULL,
      NULL,
      1.508189,
      NULL,
      NULL,
      1.164048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.557113,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.279386,
      4,
      0.662439,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.805300,
      1,
      3.418324,
      2,
      3,
      1.017260,
      1.841216,
      3,
      4,
      6.197119,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534275,
      NULL,
      NULL,
      0.362550,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.321847,
      NULL,
      NULL,
      3.465355,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      4.001757,
      NULL,
      1.023055,
      NULL,
      NULL,
      7.628989,
      4,
      3.729132,
      NULL,
      3,
      0.588893,
      0,
      2,
      3,
      0.098340,
      2,
      8,
      3.167155,
      0.667054,
      1.799593,
      0.873571,
      NULL,
      0.311232,
      NULL,
      0.229355,
      NULL,
      3.592187,
      0.004743,
      NULL,
      0.362904,
      2.446119,
      6.744382,
      10,
      4,
      2.600403,
      0.218174,
      6.781736,
      NULL,
      2,
      3,
      0,
      1.640461,
      0.481815,
      1,
      0,
      1,
      NULL,
      NULL,
      1.886365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.335741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.929238,
      NULL,
      NULL,
      0.223525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.174110,
      NULL,
      NULL,
      NULL,
      0.160082,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.259194,
      NULL,
      NULL,
      NULL,
      1.117010,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.591540,
      45.178331,
      1514,
      3,
      7.263856,
      NULL,
      1,
      NULL,
      NULL,
      1,
      8.605729,
      917,
      NULL,
      NULL,
      53.007459,
      NULL,
      2.739933,
      70.150582,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.791293,
      1.761551,
      1.976905,
      1,
      NULL,
      0,
      0,
      1.283206,
      0,
      NULL,
      1.371980,
      1,
      1,
      0.482659,
      0.532512,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      2.570880,
      1.198598,
      0,
      13,
      3.967984,
      2,
      NULL,
      1,
      1,
      NULL,
      0.671533,
      2.592248,
      NULL,
      0,
      0,
      NULL,
      0,
      2.158281,
      NULL,
      2,
      0.866739,
      NULL,
      0,
      2.334245,
      NULL,
      3.503891,
      1.299420,
      NULL,
      0,
      1.289107,
      NULL,
      1.230959,
      3,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.905181,
      0.313487,
      0.612157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.948817,
      NULL,
      1,
      NULL,
      3,
      4,
      2,
      0,
      1.074669,
      NULL,
      30,
      26.757817,
      3,
      3.649820,
      0,
      '21130',
      NULL,
      '',
      1.737967,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


