set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6458511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1223341',
      NULL,
      0.734663,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      36.753007,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      163,
      2,
      NULL,
      ' 0-23-1974',
      ' 7-24-1977',
      NULL,
      3.284212,
      NULL,
      0,
      1.475577,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      10,
      7,
      15.446988,
      NULL,
      0,
      NULL,
      1,
      2,
      5.061955,
      1,
      2,
      0,
      1,
      0,
      NULL,
      0,
      0.284813,
      1,
      0.010403,
      1,
      2,
      0,
      7,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      1,
      4,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.763726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      1,
      0,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.780482,
      1,
      '11-18-1975',
      476,
      ' 9-21-1974',
      881.583406,
      3.156820,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.151698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      377.655970,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649176,
      0,
      0,
      0.874766,
      1.672833,
      0.512276,
      0,
      NULL,
      NULL,
      NULL,
      0.460506,
      3,
      1.618563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.590236,
      0,
      NULL,
      0,
      1,
      3.746331,
      0,
      NULL,
      NULL,
      0.167980,
      NULL,
      NULL,
      NULL,
      1,
      0.246716,
      2.573280,
      1,
      1,
      2,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.791429,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      0.183675,
      1,
      1.470827,
      1,
      NULL,
      NULL,
      1,
      1.790082,
      1,
      1,
      1,
      0.213100,
      NULL,
      3,
      5.457793,
      3.983168,
      3,
      3.856174,
      3,
      NULL,
      1.725997,
      59.824121,
      2,
      3.844473,
      NULL,
      NULL,
      4,
      57.479570,
      NULL,
      NULL,
      0.640247,
      '03230',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      5,
      147.529348,
      58.074041,
      2,
      54.718984,
      2.694215,
      1,
      1,
      1.248532,
      1,
      2.485097,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549718,
      NULL,
      NULL,
      3,
      2,
      2.817197,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      1,
      1,
      0.699909,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.303116,
      0.262111,
      NULL,
      1.751655,
      NULL,
      NULL,
      0.383746,
      NULL,
      NULL,
      NULL,
      1,
      1.648454,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0.510273,
      0.410329,
      NULL,
      NULL,
      NULL,
      0,
      1.918125,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.188329,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.740635,
      NULL,
      NULL,
      NULL,
      1.942523,
      NULL,
      NULL,
      1.543914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389398,
      1.198135,
      0.957607,
      0.119968,
      NULL,
      NULL,
      2.535955,
      1,
      1.157450,
      1.540195,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.728633,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.244719,
      NULL,
      NULL,
      4.528599,
      NULL,
      3.236649,
      1.778767,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.479544,
      1.584941,
      0,
      2.014667,
      3.239528,
      0.158405,
      1,
      0.304305,
      3.502500,
      1.118600,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      1.615541,
      1.561089,
      1.828173,
      NULL,
      5.878868,
      6,
      3,
      1.194321,
      0,
      2,
      NULL,
      NULL,
      1.916730,
      0,
      1.780016,
      0,
      0.792801,
      3.122175,
      NULL,
      NULL,
      1.399883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.220999,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.814583,
      1.364204,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.856764,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.328394,
      NULL,
      NULL,
      NULL,
      1.030761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486567,
      38.916499,
      3,
      0,
      188.616925,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      78.766385,
      2.076975,
      0,
      94,
      15.398016,
      0.907524,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      13,
      43,
      0,
      1.585780,
      0.693450,
      NULL,
      0,
      1.784279,
      1.706555,
      0.431906,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1.485379,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      13,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.675124,
      3,
      1,
      0,
      1.530449,
      NULL,
      0.317558,
      0,
      NULL,
      0.948696,
      1,
      NULL,
      0.008910,
      1.748799,
      NULL,
      3.444298,
      3,
      NULL,
      1.934252,
      3.065245,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.941845,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.614720,
      NULL,
      0.778695,
      0.774786,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.114886,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.491545,
      0,
      20,
      56,
      0,
      0,
      NULL,
      '32023',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


