set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      2.710988,
      0,
      NULL,
      5.076216,
      2.454269,
      2,
      NULL,
      NULL,
      NULL,
      36,
      29,
      '0202102',
      2.206935,
      NULL,
      4,
      2,
      NULL,
      NULL,
      1.455763,
      NULL,
      NULL,
      ' 6-29-1998',
      48,
      NULL,
      NULL,
      1,
      1.076584,
      ' 8- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3- 0-1992',
      NULL,
      ' 7- 2-1982',
      1,
      0.671174,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.754977,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.036096,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1.332047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961116,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      3,
      NULL,
      7.875219,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3,
      1,
      2,
      3,
      0,
      NULL,
      5,
      3,
      0,
      0,
      1,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      NULL,
      3,
      ' 3-14-1979',
      NULL,
      ' 3- 7-1986',
      136,
      1.404967,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.684652,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745131,
      3.484478,
      6,
      0,
      1.269956,
      1,
      0.536921,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664107,
      1,
      0.221446,
      NULL,
      NULL,
      1.747954,
      NULL,
      1,
      0,
      NULL,
      0.898387,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.650532,
      2,
      0,
      3,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2,
      1,
      5,
      3,
      1,
      1,
      0.949846,
      NULL,
      1,
      NULL,
      NULL,
      0.888921,
      1,
      NULL,
      0,
      NULL,
      0.740152,
      1,
      1,
      0,
      NULL,
      5,
      6,
      NULL,
      0,
      10,
      0.518684,
      5,
      2,
      3.043094,
      3.865095,
      NULL,
      NULL,
      39.087107,
      2,
      0.271214,
      9,
      NULL,
      51,
      27.594645,
      0,
      3.867493,
      3,
      '03002',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3.791630,
      '42413',
      '',
      '',
      0,
      19.408744,
      NULL,
      28.388814,
      1.648609,
      NULL,
      NULL,
      NULL,
      NULL,
      3.437635,
      0,
      1.173217,
      1,
      NULL,
      NULL,
      0.695277,
      NULL,
      NULL,
      2.372110,
      0,
      3.171790,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.449086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.329614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.686243,
      1,
      5.436340,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.251051,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.268554,
      NULL,
      3.630793,
      2.701084,
      2.954778,
      3.745579,
      3,
      1,
      3,
      7,
      0.741915,
      1,
      1.209026,
      NULL,
      NULL,
      NULL,
      0.561310,
      NULL,
      NULL,
      NULL,
      2.468533,
      NULL,
      3.286007,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      6.517861,
      6.835337,
      1.746162,
      3,
      3.600770,
      0,
      NULL,
      NULL,
      4,
      1.206100,
      1.060327,
      NULL,
      NULL,
      NULL,
      1.574335,
      NULL,
      NULL,
      0.632789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.438524,
      3,
      3,
      0.924069,
      NULL,
      3.218783,
      NULL,
      5,
      4.845727,
      NULL,
      0,
      0.910816,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071407,
      2.549351,
      2.370003,
      0.548059,
      5,
      NULL,
      3.285828,
      0.734293,
      0.098021,
      1.000347,
      0,
      2.762693,
      NULL,
      0,
      0,
      0.578845,
      0,
      3.699412,
      0,
      1,
      8.636083,
      NULL,
      4,
      0.314786,
      1.088129,
      0.543786,
      2,
      2,
      0,
      0,
      0.911114,
      0,
      0.178587,
      3.325667,
      NULL,
      NULL,
      1.262594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.475467,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.265672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.398675,
      0.730577,
      1.709681,
      2,
      1,
      NULL,
      NULL,
      1.815491,
      NULL,
      NULL,
      NULL,
      141,
      NULL,
      NULL,
      NULL,
      1.418413,
      NULL,
      NULL,
      NULL,
      1.027743,
      NULL,
      NULL,
      NULL,
      1.413431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.164680,
      NULL,
      NULL,
      NULL,
      2.497896,
      NULL,
      NULL,
      NULL,
      3.930567,
      NULL,
      NULL,
      NULL,
      0.770703,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.477806,
      NULL,
      NULL,
      1.407113,
      NULL,
      NULL,
      0.415075,
      NULL,
      NULL,
      0.111786,
      NULL,
      1.860141,
      91.268168,
      1,
      0.158165,
      3.591509,
      1,
      0,
      NULL,
      1,
      NULL,
      1.902910,
      1.974883,
      1.400773,
      0,
      1.269705,
      0.926598,
      1.559938,
      0.262359,
      0.102594,
      1.462580,
      3.465933,
      NULL,
      NULL,
      NULL,
      0.132403,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.827618,
      NULL,
      1,
      22.534888,
      14,
      0.012539,
      NULL,
      NULL,
      NULL,
      0.381653,
      NULL,
      NULL,
      NULL,
      1.540646,
      NULL,
      1,
      NULL,
      0.155399,
      NULL,
      0.203211,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.972351,
      NULL,
      1.571013,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      3.061799,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570105,
      3.413648,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.959096,
      NULL,
      0.718189,
      NULL,
      NULL,
      NULL,
      1.699215,
      NULL,
      1.238704,
      0.755224,
      1.732741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740934,
      1.783855,
      NULL,
      1.421543,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.627244,
      1,
      NULL,
      0.977551,
      NULL,
      NULL,
      NULL,
      0.723791,
      NULL,
      1,
      0.426877,
      1,
      NULL,
      1.956965,
      NULL,
      NULL,
      NULL,
      0.181364,
      NULL,
      NULL,
      0.185650,
      3.288851,
      NULL,
      1,
      NULL,
      3.169145,
      NULL,
      1.083418,
      NULL,
      0,
      NULL,
      1.779355,
      NULL,
      0.177118,
      1.704686,
      2,
      31.022873,
      41.287931,
      NULL,
      0.740959,
      1.570332,
      NULL,
      0,
      NULL,
      NULL,
      2.343900,
      0,
      1.095512,
      NULL,
      0,
      1,
      3,
      NULL,
      1.139854,
      NULL,
      NULL,
      NULL,
      1,
      0.999203,
      NULL,
      1.414284,
      0.098068,
      NULL,
      NULL,
      0.667170,
      NULL,
      1,
      1.005877,
      NULL,
      0,
      0.052766,
      NULL,
      1.920959,
      1,
      NULL,
      0.080778,
      2.657128,
      NULL,
      NULL,
      0.079505,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      1,
      0.089887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099647,
      NULL,
      0.222442,
      NULL,
      1.402924,
      NULL,
      4,
      3,
      1,
      0.174694,
      NULL,
      NULL,
      40.223120,
      NULL,
      4,
      1,
      0.134218,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '23303',
      '',
      '');
commit;
end;
/


