set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6905583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4343031',
      0,
      1.277033,
      2,
      0,
      '1011',
      2,
      0,
      NULL,
      NULL,
      '11-28-1977',
      52,
      NULL,
      0,
      1.397629,
      2,
      ' 8-12-2002',
      35,
      NULL,
      312.913709,
      97.091138,
      1,
      '10- 3-1994',
      '10-24-1990',
      ' 6-15-1998',
      1.840894,
      0,
      NULL,
      3,
      0.568418,
      1.141127,
      7,
      1,
      NULL,
      NULL,
      NULL,
      4.057370,
      0.238692,
      13,
      1,
      1,
      NULL,
      0,
      1,
      5.683345,
      NULL,
      NULL,
      0,
      0.830658,
      0,
      NULL,
      1.314760,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      0,
      2.754586,
      5,
      0,
      1,
      5,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      2,
      3,
      5.402669,
      3,
      0,
      2,
      0,
      0.764343,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0.970027,
      0.275723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.587332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      3,
      4,
      1,
      0,
      2,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0,
      5,
      3,
      2,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      50,
      ' 9-20-1983',
      5.502200,
      1,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      0,
      NULL,
      5,
      0.866319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.829354,
      0.736697,
      5,
      NULL,
      1,
      NULL,
      1,
      11.751019,
      0,
      1.940209,
      2,
      NULL,
      0.907004,
      NULL,
      3.008623,
      3,
      4.097907,
      NULL,
      3,
      4.210475,
      4.586191,
      0,
      NULL,
      NULL,
      3.398266,
      14,
      3.497465,
      NULL,
      2,
      1,
      0,
      ' 3-25-1975',
      97.869399,
      ' 4- 6-1981',
      4.098690,
      0.262723,
      0,
      0.852132,
      2,
      1.824488,
      NULL,
      0.244589,
      0.073868,
      NULL,
      0.444178,
      0.127330,
      21,
      0.802989,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      2,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      3.924866,
      0.467443,
      NULL,
      76.277474,
      148.113875,
      138,
      99.984505,
      27.647838,
      158,
      0,
      0,
      1,
      0,
      1.618362,
      0,
      2,
      4.053604,
      3.463154,
      0.649820,
      3,
      NULL,
      2.724686,
      3,
      NULL,
      NULL,
      3.403274,
      2.195978,
      6.549428,
      NULL,
      1,
      NULL,
      35,
      2,
      0,
      NULL,
      41,
      34,
      40.336578,
      4,
      0,
      3,
      '24222',
      '33030',
      '',
      1,
      NULL,
      '',
      '',
      1.831006,
      '',
      '',
      '',
      2.535731,
      6,
      63.984012,
      16.283453,
      NULL,
      16,
      3.757616,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.748037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.923678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093464,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.811207,
      NULL,
      NULL,
      0.264612,
      NULL,
      NULL,
      1.277472,
      NULL,
      NULL,
      0.530238,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.832443,
      3.358504,
      3,
      0,
      NULL,
      NULL,
      3,
      4.075874,
      5,
      1,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.450994,
      3,
      NULL,
      1.131826,
      3,
      1,
      5,
      4,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.505434,
      1.958016,
      NULL,
      NULL,
      2,
      2.924062,
      NULL,
      4,
      3,
      0.917151,
      1.596884,
      NULL,
      NULL,
      1.265337,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.885927,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.468308,
      2.249960,
      1,
      4,
      NULL,
      2.937344,
      0.549695,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.592186,
      NULL,
      NULL,
      1.466937,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      126,
      2,
      1,
      1.841420,
      NULL,
      0.063876,
      0,
      0,
      NULL,
      1,
      0.434243,
      0,
      1.926300,
      2.950051,
      NULL,
      1.604519,
      1.615712,
      NULL,
      2.566338,
      0.387815,
      1,
      0,
      NULL,
      1.639497,
      0.869550,
      NULL,
      1.816250,
      0.080568,
      1.739248,
      NULL,
      0.800180,
      0.902132,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.807077,
      0.402736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.584332,
      NULL,
      1.680830,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.552942,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442089,
      0.067055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677036,
      3.025199,
      NULL,
      1,
      NULL,
      1.434217,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911349,
      2.741633,
      0.390867,
      0,
      1.170286,
      1,
      NULL,
      397.243039,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.406637,
      NULL,
      3,
      9,
      6.495564,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.167456,
      2,
      1,
      NULL,
      NULL,
      8,
      2.950260,
      3.180620,
      2.841085,
      0,
      1,
      NULL,
      1.017260,
      NULL,
      1,
      0,
      1.061005,
      1,
      NULL,
      1.466193,
      1,
      1,
      0.252898,
      0,
      0,
      0,
      1,
      NULL,
      1.884218,
      1,
      1.381560,
      2,
      1,
      0,
      1.284311,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      3.134479,
      0.711702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.963655,
      0,
      1,
      0,
      1.143703,
      NULL,
      NULL,
      89,
      112,
      4,
      1.612721,
      3.226180,
      '21112',
      '44234',
      '',
      0.023989,
      '',
      '',
      NULL,
      0.724145,
      '',
      '',
      '');
commit;
end;
/


