set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8314540';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3.180413,
      NULL,
      2.884743,
      NULL,
      2.811846,
      2,
      NULL,
      '414',
      NULL,
      NULL,
      47,
      '3441334',
      3,
      NULL,
      NULL,
      3,
      '2000',
      3.000456,
      NULL,
      NULL,
      NULL,
      ' 6-27-1990',
      130.830361,
      245.895424,
      NULL,
      NULL,
      3.336012,
      ' 9-18-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6-16-1974',
      ' 9-25-1989',
      ' 6-12-1978',
      NULL,
      0.724686,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.394300,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.907379,
      NULL,
      1,
      1.792044,
      0.830006,
      1,
      1.346357,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      4,
      1,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0,
      0,
      0,
      2.196580,
      1.167167,
      1.929140,
      2,
      0.586586,
      1.605461,
      1.307125,
      1,
      2.773317,
      NULL,
      0,
      0,
      5.371430,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      3,
      2,
      1,
      NULL,
      4,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.241328,
      3,
      0,
      4,
      0,
      1,
      3,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      5,
      3,
      3,
      0,
      2,
      NULL,
      4,
      3,
      3,
      5,
      4,
      NULL,
      NULL,
      NULL,
      ' 8- 8-2002',
      232,
      ' 0-24-1989',
      24,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.560941,
      1,
      1,
      1.183438,
      3.804429,
      3,
      0,
      8.063681,
      0.787919,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.071849,
      NULL,
      0.262283,
      2.621086,
      NULL,
      NULL,
      0.572988,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693437,
      3.501511,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      3.853010,
      1,
      NULL,
      0,
      2.926137,
      NULL,
      1,
      1.931920,
      NULL,
      NULL,
      1,
      0.884684,
      0,
      NULL,
      1.422958,
      1,
      0,
      10,
      11,
      3,
      0.650024,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      3.974092,
      0,
      51.647064,
      2,
      2.997152,
      15,
      NULL,
      55,
      8.385266,
      0,
      2,
      2.522726,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      '1312',
      '',
      NULL,
      NULL,
      4.524459,
      NULL,
      19.725677,
      1.479782,
      3.553157,
      NULL,
      0,
      5,
      0.445242,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.990384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.792381,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.245745,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      2.787542,
      0.056352,
      1.689351,
      NULL,
      NULL,
      NULL,
      0.318508,
      NULL,
      0.171138,
      2,
      1.936885,
      1.900927,
      2.392628,
      0,
      NULL,
      1,
      2.248490,
      1.066480,
      0.818358,
      1,
      1.500100,
      1.056609,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.346243,
      7.353575,
      NULL,
      NULL,
      0.994276,
      NULL,
      NULL,
      NULL,
      0,
      1.148788,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273824,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.273103,
      NULL,
      NULL,
      7,
      0,
      0,
      0.456035,
      NULL,
      NULL,
      1.611352,
      NULL,
      NULL,
      1.625078,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.545686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207278,
      1.582210,
      NULL,
      5.547587,
      NULL,
      1,
      NULL,
      5.051767,
      0.304555,
      3,
      3.128651,
      1.167459,
      1.925968,
      NULL,
      0,
      0,
      3.363464,
      2.466028,
      1.264258,
      NULL,
      NULL,
      8,
      1,
      8.792175,
      0,
      1.688842,
      2.926853,
      3,
      1.647986,
      2.945935,
      3.369166,
      NULL,
      2.972394,
      2.965085,
      NULL,
      1,
      7,
      2.653128,
      NULL,
      0.377863,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.736632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.581978,
      NULL,
      2.454063,
      0.627079,
      0.894118,
      3,
      1.404502,
      NULL,
      NULL,
      5,
      1.549870,
      NULL,
      0.417040,
      1,
      NULL,
      NULL,
      NULL,
      0.725189,
      NULL,
      NULL,
      3.551210,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.992100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.867075,
      0,
      1.202875,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.190533,
      NULL,
      NULL,
      3.595288,
      1.414083,
      NULL,
      NULL,
      1.193746,
      1.043888,
      NULL,
      NULL,
      1.241379,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.235732,
      NULL,
      0,
      2.939986,
      0,
      NULL,
      1.152299,
      1.063695,
      1,
      NULL,
      0.182854,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.898617,
      NULL,
      2,
      1.757776,
      0.839872,
      NULL,
      8.004815,
      7,
      2.251618,
      NULL,
      3,
      2,
      3.392154,
      6,
      1,
      0.515245,
      9.637284,
      0.065525,
      0.464965,
      2.283832,
      4.071256,
      0.208181,
      NULL,
      NULL,
      0.883702,
      NULL,
      0.366317,
      1.973608,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.054644,
      NULL,
      0.939997,
      NULL,
      0.234541,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.424629,
      1,
      1.550946,
      NULL,
      0,
      1.974769,
      1,
      1.791814,
      NULL,
      1,
      0.471954,
      1.880703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.584957,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277570,
      1.851767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.932904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361794,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541015,
      0.550187,
      0.249748,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.184506,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      4,
      3.999256,
      5.149203,
      3,
      18,
      0,
      2,
      1.828409,
      1.164827,
      2,
      1.775380,
      1,
      1.261670,
      3,
      0.427743,
      0.543719,
      NULL,
      NULL,
      0.600554,
      0.419688,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      3.326710,
      NULL,
      1.129378,
      1,
      0,
      0.763360,
      3,
      2,
      0.267389,
      NULL,
      0,
      0,
      NULL,
      1.823656,
      1.620264,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460614,
      0.572383,
      0.496223,
      NULL,
      1.750665,
      1,
      0,
      0,
      0,
      0,
      3,
      29.928468,
      NULL,
      NULL,
      4,
      1,
      '11340',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.477164,
      '0010',
      '',
      '');
commit;
end;
/


