set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7730763';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '3333124',
      3,
      0.609750,
      1,
      NULL,
      '4403',
      1.297459,
      0,
      NULL,
      NULL,
      '11-14-1979',
      80,
      NULL,
      4,
      2,
      0,
      NULL,
      125.603424,
      NULL,
      26.693496,
      63,
      5,
      NULL,
      NULL,
      ' 9- 8-2002',
      2.665605,
      NULL,
      1.022686,
      1.341926,
      0,
      NULL,
      1,
      0,
      1,
      1379,
      8,
      12,
      16,
      80,
      191,
      5,
      NULL,
      0,
      0,
      9,
      0,
      0,
      0,
      1.182143,
      NULL,
      NULL,
      0.978831,
      1,
      1,
      1.482110,
      36.887759,
      8,
      6,
      4,
      3.631386,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      3,
      1,
      0,
      2,
      1,
      0.473288,
      NULL,
      NULL,
      0.576809,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1.617514,
      0,
      1.957330,
      1.792131,
      0.522235,
      1,
      1.253264,
      NULL,
      0.609696,
      1.947144,
      0.714849,
      0.218848,
      1,
      1.850230,
      1,
      5,
      0,
      1,
      3,
      1,
      1,
      0.660499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      3,
      0,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0.577194,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4,
      5,
      1,
      0,
      2,
      NULL,
      5,
      1,
      1,
      1,
      4,
      0,
      NULL,
      5,
      1,
      5,
      NULL,
      2,
      3,
      NULL,
      3.634272,
      1,
      NULL,
      473,
      '10-15-1983',
      1102,
      1.074743,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      2.760846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      1.543714,
      3.147909,
      3,
      NULL,
      3,
      1,
      0.675193,
      NULL,
      1,
      0.273685,
      NULL,
      2,
      4,
      2.777953,
      3.345397,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1.000258,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      '10- 2-1997',
      5.223523,
      ' 8- 5-1991',
      2,
      0.049141,
      1,
      0.176964,
      0,
      0,
      1,
      NULL,
      0,
      1.517071,
      NULL,
      1,
      1852.634529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.134425,
      NULL,
      3,
      NULL,
      2,
      3,
      0,
      1,
      2,
      1,
      3,
      1.649254,
      10.420444,
      17,
      12,
      55.302650,
      126.801874,
      42,
      166,
      69.368866,
      NULL,
      NULL,
      1,
      1,
      0.637719,
      0.155084,
      1,
      6.779268,
      1,
      1,
      1.558993,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      1.533933,
      1,
      0,
      26.267426,
      0,
      0.821636,
      NULL,
      31,
      NULL,
      16.044006,
      4,
      1.255691,
      0.512895,
      '01322',
      NULL,
      '',
      0.380873,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      18,
      NULL,
      0.251987,
      NULL,
      NULL,
      6.664633,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      12.023817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      16.358039,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11.948551,
      NULL,
      NULL,
      2.816191,
      NULL,
      NULL,
      3.985434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.520093,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1.913109,
      NULL,
      NULL,
      0.717469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.140285,
      NULL,
      NULL,
      19.878799,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.395194,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.482512,
      NULL,
      NULL,
      3,
      3,
      3.435070,
      1.371628,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      3,
      NULL,
      6,
      7.719467,
      3,
      0.076423,
      NULL,
      NULL,
      0.147392,
      2,
      1,
      NULL,
      0.111259,
      1.064346,
      NULL,
      0,
      9.234505,
      1,
      0.340255,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      0.045765,
      NULL,
      2,
      7,
      NULL,
      4,
      9,
      1,
      5.389208,
      0,
      0,
      4,
      1,
      NULL,
      0.330044,
      0.811773,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.450935,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      7.386831,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.139201,
      NULL,
      NULL,
      2.784906,
      1,
      2.789804,
      1.340324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.583885,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.820231,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.000729,
      NULL,
      2,
      NULL,
      2.881712,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.491425,
      NULL,
      0.277077,
      NULL,
      NULL,
      NULL,
      0.202504,
      NULL,
      1.855549,
      NULL,
      1,
      NULL,
      1.905457,
      NULL,
      8,
      NULL,
      2,
      NULL,
      16.508217,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      825,
      18.047780,
      2.102557,
      NULL,
      1196.142942,
      0.551875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115741,
      3.859604,
      2,
      NULL,
      NULL,
      1.432944,
      1.810026,
      1,
      0.717395,
      1,
      1,
      1.953263,
      1,
      1,
      1,
      1.630291,
      NULL,
      0.519745,
      0.692586,
      0.117806,
      NULL,
      0,
      1.363830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.711650,
      NULL,
      4.885981,
      0,
      8.789253,
      3,
      0.427367,
      NULL,
      2.836164,
      19.164521,
      NULL,
      16.391184,
      3.962767,
      NULL,
      19.745493,
      10.798952,
      NULL,
      7,
      NULL,
      NULL,
      3.598020,
      2,
      NULL,
      13.410428,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      3.947692,
      0.574754,
      NULL,
      8,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.226419,
      0,
      NULL,
      2.978974,
      NULL,
      1.777701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346265,
      3,
      NULL,
      2.905400,
      NULL,
      3.856554,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.749060,
      NULL,
      0,
      NULL,
      2.670260,
      NULL,
      NULL,
      NULL,
      3.654307,
      NULL,
      17.724579,
      NULL,
      9.951935,
      NULL,
      8.716958,
      NULL,
      18,
      1.023861,
      NULL,
      1,
      NULL,
      1.601113,
      NULL,
      0.656245,
      NULL,
      2,
      0,
      4,
      0,
      0.856118,
      2.884580,
      46,
      58.293786,
      NULL,
      NULL,
      2.233796,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


