set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      0.969817,
      1.439987,
      1,
      3,
      '1442',
      NULL,
      0.254435,
      NULL,
      NULL,
      ' 3- 5-1982',
      28.386612,
      NULL,
      5,
      0,
      NULL,
      NULL,
      58.039347,
      1.829747,
      101.812711,
      2,
      NULL,
      NULL,
      NULL,
      ' 8-13-2001',
      0,
      1,
      0.583951,
      NULL,
      0,
      NULL,
      6,
      0,
      1.119778,
      88,
      NULL,
      17.350276,
      NULL,
      25.850033,
      3.143322,
      4,
      1.925786,
      NULL,
      2,
      10.042755,
      NULL,
      2,
      NULL,
      1.364838,
      0,
      1.345856,
      0.469001,
      NULL,
      0,
      0.556777,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      2,
      1,
      NULL,
      1,
      1,
      1,
      5,
      0,
      0,
      1,
      0,
      1.492361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.529926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      4,
      NULL,
      5,
      0,
      NULL,
      NULL,
      4,
      0,
      0,
      4,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.033842,
      0,
      3,
      0,
      0,
      4,
      3,
      5,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      4,
      2,
      2,
      5,
      4,
      3,
      0,
      1,
      0.924729,
      0.875151,
      '10- 0-1986',
      361,
      '10-14-2001',
      651,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.334919,
      1,
      5.052543,
      1.196232,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.234014,
      1.634954,
      0,
      0.242393,
      0.446925,
      NULL,
      NULL,
      1.151196,
      0.158368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.524514,
      '34242',
      '02423',
      '22224',
      0.417164,
      '',
      '',
      '',
      0.188466,
      '',
      '',
      NULL,
      3.297180,
      11,
      217.045820,
      12.524412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8,
      0.295708,
      0.155825,
      NULL,
      NULL,
      1.766226,
      NULL,
      NULL,
      2,
      11,
      1.815803,
      0,
      NULL,
      NULL,
      0.082042,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.722431,
      NULL,
      NULL,
      3.868406,
      1.515709,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.422414,
      2,
      1,
      NULL,
      NULL,
      1.362850,
      NULL,
      NULL,
      0.926167,
      3.027118,
      5.140731,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.330170,
      NULL,
      NULL,
      2,
      10,
      2,
      0.462091,
      NULL,
      NULL,
      1.601407,
      NULL,
      NULL,
      1,
      0.967568,
      5,
      NULL,
      NULL,
      3,
      2.910083,
      2.638648,
      3.834718,
      1.166653,
      3.526493,
      1.306218,
      1,
      NULL,
      NULL,
      0.078655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987437,
      NULL,
      NULL,
      0.848346,
      NULL,
      NULL,
      1.369147,
      NULL,
      NULL,
      3,
      11.007553,
      NULL,
      1,
      3.855891,
      0.373392,
      NULL,
      1,
      2,
      0.011829,
      NULL,
      NULL,
      NULL,
      5,
      2,
      2,
      NULL,
      2,
      0,
      2.394446,
      1,
      1.741363,
      1.775171,
      8.827112,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      8,
      2,
      3.410107,
      5.203077,
      1.381744,
      6,
      NULL,
      0.296665,
      1.105490,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      0.007281,
      1,
      0,
      1.855697,
      0.443175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810655,
      NULL,
      NULL,
      0.618223,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700155,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.297536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709221,
      NULL,
      NULL,
      NULL,
      1.058926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.336867,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.854541,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.999479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.760299,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589386,
      10741,
      NULL,
      0,
      3,
      1,
      3,
      0.483059,
      0,
      1,
      0.375229,
      1.631007,
      0.281167,
      0,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.476417,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50.427149,
      NULL,
      2,
      9,
      25,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.203656,
      NULL,
      2.568673,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.543514,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034578,
      1,
      1.773104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.885721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917663,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.970263,
      NULL,
      NULL,
      NULL,
      1.330990,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5.384143,
      2.930200,
      NULL,
      2.009668,
      2,
      6.901296,
      2.173661,
      0,
      NULL,
      0,
      11,
      NULL,
      NULL,
      14.052453,
      NULL,
      0.857594,
      4,
      NULL,
      0,
      10.380859,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.659301,
      NULL,
      0.454753,
      NULL,
      NULL,
      2.144314,
      17,
      NULL,
      0,
      1,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.547169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080929,
      NULL,
      1.572879,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      1.688319,
      NULL,
      NULL,
      49,
      11,
      0,
      0,
      4,
      NULL,
      NULL,
      '30124',
      0.341008,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


