set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4012440',
      NULL,
      0,
      0,
      1,
      '0302',
      1,
      1.705657,
      NULL,
      NULL,
      NULL,
      45.337455,
      NULL,
      2,
      NULL,
      3.905708,
      ' 4-21-1977',
      7,
      3,
      61.218184,
      24.621904,
      4,
      NULL,
      NULL,
      ' 1-23-1990',
      1.218961,
      1.127635,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.992960,
      125.110913,
      8,
      16,
      9,
      22.170301,
      26.869787,
      5,
      25,
      NULL,
      2,
      5.906702,
      NULL,
      3,
      NULL,
      0.323195,
      1.900070,
      1,
      1.537650,
      1.463273,
      NULL,
      0.099997,
      0,
      0,
      4,
      3,
      2.186348,
      1,
      1,
      0,
      3,
      1,
      1,
      3,
      1,
      0,
      1,
      0,
      0,
      2.415481,
      0,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.597104,
      0.320597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2,
      0,
      0,
      1,
      1.432004,
      NULL,
      NULL,
      0.088179,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1.141250,
      0,
      5,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      5,
      1,
      4,
      0,
      4,
      NULL,
      5,
      NULL,
      1,
      2,
      NULL,
      0,
      1.918972,
      NULL,
      299,
      ' 4- 4-1978',
      1018.558954,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      3,
      1,
      0.592344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.687475,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.526300,
      1,
      2,
      3.030846,
      0.672506,
      NULL,
      NULL,
      NULL,
      7,
      1.038352,
      0.709437,
      4,
      0.915120,
      0.213296,
      1.410700,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.123902,
      1.411790,
      NULL,
      0.298144,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      0,
      3,
      1,
      1.645000,
      NULL,
      2,
      NULL,
      0.111404,
      1,
      1,
      NULL,
      0,
      0.929214,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      '43311',
      '12121',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.518916,
      3.522992,
      15.802007,
      55.408508,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.090852,
      NULL,
      NULL,
      NULL,
      NULL,
      3.355417,
      NULL,
      NULL,
      NULL,
      0.934260,
      NULL,
      NULL,
      2,
      1.919403,
      3.499952,
      1,
      NULL,
      NULL,
      0.481017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      1.744360,
      1,
      0.881845,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      16.588225,
      0.990275,
      NULL,
      NULL,
      NULL,
      0.379573,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.284466,
      1.139553,
      1.405244,
      3,
      0.567609,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      3.776663,
      0,
      0.139564,
      1.552797,
      15,
      0,
      1.988581,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.256527,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.198380,
      1.657499,
      4,
      NULL,
      1.523639,
      NULL,
      1.457929,
      NULL,
      NULL,
      2.100514,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.884022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.884801,
      NULL,
      2,
      7.410642,
      NULL,
      NULL,
      NULL,
      0.231427,
      0.109382,
      1,
      NULL,
      NULL,
      1,
      1.807693,
      1,
      0,
      1,
      NULL,
      0.413246,
      1.001648,
      2.260204,
      11,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.586751,
      7.070965,
      2.848509,
      3.868511,
      1.497870,
      3.501741,
      2.009403,
      0.806422,
      2.199209,
      5,
      0,
      3.087610,
      NULL,
      0.908185,
      1,
      3,
      NULL,
      2,
      0.349882,
      NULL,
      NULL,
      0.462654,
      NULL,
      3.114208,
      NULL,
      NULL,
      0.192158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984983,
      NULL,
      NULL,
      0.920795,
      0,
      0.638872,
      NULL,
      1.871126,
      2,
      1,
      NULL,
      NULL,
      1.378896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.701047,
      NULL,
      NULL,
      NULL,
      1.884856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.476125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.126200,
      NULL,
      NULL,
      NULL,
      3.910848,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.008205,
      NULL,
      NULL,
      1.500156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.352002,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411540,
      15699,
      1392,
      1.338252,
      3,
      1,
      NULL,
      0,
      NULL,
      1.787512,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.223149,
      3.746895,
      NULL,
      1.260905,
      0.838167,
      0.899793,
      NULL,
      0.172608,
      NULL,
      3.819995,
      NULL,
      0,
      NULL,
      0.274165,
      NULL,
      1.358647,
      NULL,
      156,
      NULL,
      3.496795,
      14,
      35.964330,
      1,
      0,
      NULL,
      NULL,
      1.451169,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.257703,
      NULL,
      0,
      NULL,
      0.536335,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224222,
      NULL,
      0,
      1.133223,
      0.403068,
      1.432688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.129973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285014,
      0.437924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.490896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0.919095,
      3.619267,
      2,
      3,
      3.811422,
      0.075340,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3.967782,
      NULL,
      0,
      0,
      NULL,
      1,
      0.855058,
      NULL,
      0.264048,
      NULL,
      NULL,
      1.275659,
      0.281436,
      NULL,
      1.000474,
      0.748682,
      NULL,
      1.718205,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.092722,
      NULL,
      2.367404,
      0,
      2.578431,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.144882,
      NULL,
      1.930361,
      NULL,
      0,
      NULL,
      0.383715,
      NULL,
      0,
      NULL,
      1.044489,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1793.406553,
      0.162500,
      0,
      NULL,
      NULL,
      NULL,
      2.521060,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.094756,
      NULL,
      NULL,
      NULL,
      0.763407,
      NULL,
      0.722809,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.519131,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1061.348332,
      0.290231,
      NULL,
      0,
      NULL,
      0.371391,
      NULL,
      NULL,
      3,
      2,
      3.854790,
      0,
      3.434236,
      65,
      7,
      NULL,
      NULL,
      5.285883,
      '03042',
      '41134',
      NULL,
      1,
      '',
      '',
      NULL,
      0.665869,
      '',
      '',
      '');
commit;
end;
/


