set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      3,
      '0044',
      3.770388,
      0.138915,
      NULL,
      NULL,
      ' 0-15-1978',
      46.219325,
      NULL,
      2,
      1.019602,
      0.297091,
      ' 9- 4-2000',
      NULL,
      NULL,
      251,
      70,
      4,
      NULL,
      NULL,
      ' 1- 7-1983',
      NULL,
      0,
      1.814301,
      3.422779,
      NULL,
      0,
      3,
      1,
      0.965869,
      12.187821,
      6,
      NULL,
      8.868475,
      NULL,
      16,
      1,
      NULL,
      5,
      1,
      6.925691,
      0,
      2,
      0,
      0,
      1,
      0.595328,
      1.314496,
      0,
      1.005368,
      1,
      0.769150,
      NULL,
      0,
      5,
      1,
      1,
      1,
      0,
      5,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.178328,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.923933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      1,
      1,
      1.502746,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0.825319,
      NULL,
      1.940397,
      1,
      5,
      0,
      1,
      0,
      1,
      4,
      1,
      NULL,
      4,
      NULL,
      0,
      2,
      3,
      5,
      4,
      0,
      0,
      1,
      1,
      4,
      1,
      0,
      3,
      0,
      NULL,
      3,
      ' 9- 4-1996',
      386.441239,
      ' 2-25-1995',
      615.559306,
      0.770745,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      1,
      NULL,
      3,
      2.573005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.845583,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.977876,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057804,
      NULL,
      1,
      NULL,
      4,
      0.298784,
      1,
      NULL,
      NULL,
      NULL,
      0.098344,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273508,
      0,
      0.786159,
      1.627376,
      1,
      0.272986,
      NULL,
      1,
      NULL,
      0,
      0.551961,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      1,
      0,
      2,
      2,
      1,
      3,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1.603045,
      1,
      3.120728,
      NULL,
      0,
      0,
      NULL,
      0,
      1.630689,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.226346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281431,
      34,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      '20011',
      '42201',
      '21244',
      0,
      '',
      '',
      NULL,
      0.582191,
      NULL,
      '',
      '',
      0,
      16,
      161.654311,
      51,
      1.981849,
      NULL,
      NULL,
      NULL,
      NULL,
      2.937411,
      1,
      0,
      1,
      NULL,
      NULL,
      0.539451,
      NULL,
      NULL,
      2.670318,
      1.712583,
      3.002239,
      0.013363,
      NULL,
      NULL,
      1.951582,
      NULL,
      NULL,
      NULL,
      1.558349,
      1,
      1.960112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.838106,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      0.947744,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.668827,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.604211,
      1,
      1,
      NULL,
      0.552428,
      1,
      0,
      1.769366,
      0,
      2.833223,
      0.486507,
      0,
      0.464118,
      4,
      1.791272,
      0.899947,
      NULL,
      NULL,
      5.268313,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.451502,
      1,
      1.051347,
      7.751891,
      3.822739,
      0.655682,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.581651,
      1.830567,
      5.678127,
      2.752349,
      0.358542,
      2,
      1.421877,
      15.807749,
      14.165213,
      9.409753,
      2,
      0.298238,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225574,
      NULL,
      NULL,
      1.609088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609658,
      NULL,
      NULL,
      0,
      2,
      2.093099,
      0,
      1.814159,
      4.102579,
      NULL,
      0,
      5.404514,
      NULL,
      NULL,
      1.077995,
      2.963514,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.759055,
      NULL,
      3,
      NULL,
      5.848366,
      2,
      1.237600,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      1.839390,
      1,
      NULL,
      2,
      1.872439,
      0,
      4,
      0,
      NULL,
      3.839529,
      1.671453,
      5,
      1.963281,
      0,
      2,
      1.514449,
      NULL,
      0.137054,
      0,
      1,
      2.969292,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178015,
      NULL,
      NULL,
      0.589337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.331139,
      NULL,
      NULL,
      3.068967,
      NULL,
      NULL,
      1.802025,
      0,
      0.788534,
      1.393818,
      1.936139,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.261851,
      NULL,
      NULL,
      NULL,
      1.313125,
      NULL,
      NULL,
      NULL,
      0.115681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.598828,
      NULL,
      NULL,
      NULL,
      1.293795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.435376,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.256868,
      NULL,
      0.997782,
      39,
      1508,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0.585905,
      3.121465,
      1.763837,
      3,
      1.197540,
      0,
      NULL,
      NULL,
      0.200155,
      1.534423,
      0,
      2,
      NULL,
      1.442885,
      NULL,
      NULL,
      NULL,
      0.763406,
      NULL,
      3,
      NULL,
      3,
      NULL,
      146.301193,
      NULL,
      3,
      23,
      11.264795,
      NULL,
      0.578939,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.261257,
      NULL,
      0.679123,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.665910,
      NULL,
      NULL,
      NULL,
      1.167056,
      0.616828,
      0,
      1.860893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.167051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150240,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.332013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      0,
      2.496934,
      3,
      3.899978,
      2,
      0,
      0.466312,
      1,
      NULL,
      NULL,
      1.922582,
      0,
      NULL,
      0.840889,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.545633,
      NULL,
      1,
      1.652479,
      NULL,
      1.954028,
      1.613030,
      NULL,
      1.540963,
      1.672723,
      NULL,
      1.702660,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292496,
      0,
      NULL,
      0.600056,
      NULL,
      NULL,
      NULL,
      0.164922,
      NULL,
      1.979915,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.637545,
      NULL,
      1.194850,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      133,
      1.524023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.047070,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.255536,
      NULL,
      1,
      NULL,
      0.768231,
      NULL,
      2.515614,
      NULL,
      1.718664,
      NULL,
      0,
      NULL,
      134.179587,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887948,
      NULL,
      1,
      NULL,
      3,
      0,
      7,
      2.676609,
      0.599795,
      NULL,
      28.431443,
      42,
      3,
      1.157412,
      7.912601,
      '41002',
      NULL,
      '20210',
      1.388006,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


