set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678994';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.756631,
      2,
      2.662129,
      4,
      NULL,
      3,
      NULL,
      0.770984,
      '233',
      '13312324',
      54.113447,
      26.960182,
      '3304324',
      2.313110,
      NULL,
      1,
      3,
      NULL,
      0.475544,
      0,
      NULL,
      NULL,
      NULL,
      55.563077,
      19,
      NULL,
      1.743986,
      0.663084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 4-14-1998',
      ' 0-21-1995',
      ' 6-17-1975',
      NULL,
      0.650237,
      3.826168,
      2.947997,
      0,
      2,
      NULL,
      0.602656,
      1.556723,
      14,
      5,
      4,
      0.295403,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.557972,
      1,
      1,
      0.694786,
      3,
      2,
      2,
      1.132132,
      3,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      6.204233,
      1,
      0.660759,
      1,
      0,
      0,
      0,
      0.495622,
      1.216806,
      NULL,
      3.904197,
      3.175037,
      NULL,
      0.515705,
      1.353217,
      1.242042,
      NULL,
      NULL,
      0,
      NULL,
      10.890518,
      0,
      2,
      4,
      0.071372,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      5,
      1,
      0,
      0,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      5,
      5,
      1,
      4,
      4,
      NULL,
      2,
      0,
      1,
      3,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      1.705782,
      ' 4-21-2003',
      6,
      NULL,
      11,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.667776,
      6,
      NULL,
      NULL,
      2.859038,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.329028,
      1.787153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162763,
      NULL,
      0,
      1.283724,
      NULL,
      0.300848,
      18.789463,
      3,
      0.398109,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.907049,
      3,
      3,
      2,
      2,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      5.022574,
      NULL,
      0.722137,
      1,
      0.923886,
      1,
      1.671939,
      NULL,
      0.547523,
      1,
      1,
      NULL,
      1,
      1.356880,
      1,
      2.722046,
      2,
      0.423701,
      0.700301,
      11.982265,
      2,
      6,
      NULL,
      1.779757,
      4.747291,
      2,
      NULL,
      2,
      1.602249,
      1.768385,
      49,
      1,
      0.467463,
      63,
      NULL,
      25,
      6,
      NULL,
      NULL,
      3.774350,
      '31323',
      '',
      '',
      0.399334,
      '',
      '',
      NULL,
      NULL,
      '1403',
      '',
      '',
      1,
      32.310850,
      85.530260,
      NULL,
      0,
      8.208768,
      16,
      NULL,
      0,
      0,
      0.048931,
      1,
      0.559105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619222,
      NULL,
      NULL,
      2.394327,
      1,
      1.115628,
      0.282469,
      1,
      1.513988,
      0.901235,
      NULL,
      NULL,
      1.315783,
      NULL,
      NULL,
      1.596051,
      NULL,
      NULL,
      1.423473,
      NULL,
      NULL,
      1.288118,
      NULL,
      NULL,
      2.785626,
      1.655545,
      0.854067,
      1,
      0.943886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.488800,
      1.002183,
      0,
      0,
      NULL,
      1.041413,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1.957504,
      1,
      0.890748,
      NULL,
      1,
      0,
      1.627709,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.889152,
      1.103324,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.516543,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.153181,
      1.657592,
      1,
      NULL,
      0,
      1.335390,
      0,
      NULL,
      NULL,
      2.109151,
      6.624401,
      1,
      0.568806,
      1.499023,
      1.489114,
      NULL,
      2.287940,
      3.241155,
      2.117983,
      NULL,
      3.249761,
      0.322065,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.067530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.314541,
      2.253433,
      1,
      NULL,
      NULL,
      6.620360,
      0,
      5,
      0,
      2.937732,
      0.789349,
      5,
      0,
      0.592503,
      0,
      2.808590,
      3.537906,
      0,
      3,
      NULL,
      1,
      1,
      2,
      1.038840,
      0,
      5,
      0.217400,
      3.060486,
      0.941614,
      0,
      1.294546,
      2.727529,
      2.364661,
      NULL,
      1.833753,
      3.661363,
      0.985204,
      3,
      7,
      NULL,
      5,
      NULL,
      4,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      0.054932,
      10,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.421187,
      NULL,
      NULL,
      1.406058,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859378,
      2.704875,
      NULL,
      NULL,
      2.689640,
      NULL,
      1.513686,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.440981,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.752493,
      3,
      NULL,
      3.129121,
      7.579791,
      NULL,
      1.842879,
      NULL,
      0.185624,
      2.326641,
      0.479025,
      2.079832,
      NULL,
      NULL,
      NULL,
      0,
      0.790812,
      7,
      NULL,
      NULL,
      9.834478,
      1,
      NULL,
      NULL,
      2.342154,
      1.447857,
      NULL,
      NULL,
      0.205482,
      0.149494,
      NULL,
      1.698172,
      3.780663,
      NULL,
      NULL,
      NULL,
      1,
      2.683233,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.563991,
      NULL,
      NULL,
      NULL,
      1.645993,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.007438,
      NULL,
      NULL,
      1.174110,
      NULL,
      NULL,
      3.649118,
      0.770062,
      2.308279,
      NULL,
      0.504954,
      NULL,
      2.117707,
      NULL,
      0,
      0.892009,
      NULL,
      NULL,
      1.352464,
      NULL,
      0.783931,
      NULL,
      0,
      2,
      3.009768,
      NULL,
      1,
      NULL,
      2.999783,
      NULL,
      0,
      0.799512,
      12.536438,
      NULL,
      0.759736,
      16.268705,
      3.440808,
      NULL,
      1.357509,
      2.810481,
      4,
      5,
      1.190527,
      NULL,
      9,
      0.851167,
      0.774241,
      1,
      0,
      NULL,
      NULL,
      1.596299,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.412869,
      NULL,
      NULL,
      0,
      NULL,
      1,
      933.665574,
      6.616800,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729392,
      NULL,
      1.354156,
      1,
      0,
      0.164194,
      NULL,
      NULL,
      1,
      1.105800,
      1.407021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.653618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630418,
      2,
      NULL,
      0,
      NULL,
      0.765907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.408943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.440782,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549180,
      NULL,
      NULL,
      NULL,
      1.180028,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.209993,
      3.659753,
      NULL,
      3,
      9.160433,
      3.418793,
      0,
      0.923080,
      NULL,
      NULL,
      1.816046,
      1.074657,
      1,
      1,
      0,
      1.367036,
      NULL,
      1,
      1.241801,
      1.434705,
      0.753454,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      3.115055,
      1,
      1,
      3.186173,
      1.041911,
      1.281908,
      3.070440,
      0.865158,
      1.683679,
      NULL,
      0.756816,
      1,
      NULL,
      2.202796,
      3,
      1.540495,
      NULL,
      2.624298,
      2.551948,
      0.216378,
      0.265683,
      3.130547,
      1.107651,
      3,
      0,
      0.765535,
      1,
      0,
      0.478559,
      1,
      NULL,
      3,
      0.507017,
      0,
      NULL,
      2.511887,
      3.945479,
      NULL,
      NULL,
      NULL,
      1.679319,
      0,
      4.190592,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399524,
      3,
      0,
      0,
      0,
      1.403454,
      NULL,
      NULL,
      2,
      0.582370,
      0.352532,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '1033',
      '',
      '');
commit;
end;
/


