set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204518';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2331231',
      0,
      0,
      0,
      0,
      '1003',
      1.776922,
      0,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      0,
      1,
      0.637486,
      ' 4- 8-1989',
      57.640033,
      0,
      302.593305,
      96,
      NULL,
      ' 6- 3-1981',
      ' 9-11-2003',
      '10- 5-1982',
      1,
      3.084990,
      1,
      0,
      0,
      NULL,
      NULL,
      0.611203,
      0,
      117,
      5,
      NULL,
      NULL,
      4,
      24,
      NULL,
      9.821644,
      5,
      0,
      7,
      0.087424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      2.211902,
      4,
      1,
      NULL,
      4,
      2,
      0,
      4,
      3,
      0,
      1,
      0,
      2,
      7,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3.964756,
      3,
      1,
      NULL,
      2,
      2,
      0.972861,
      2,
      0.372107,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      2.069251,
      1.719838,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1,
      3,
      3,
      3,
      5,
      3,
      4,
      NULL,
      5,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      1.230630,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      5,
      5,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      5,
      5,
      3,
      1,
      4,
      2,
      5,
      3,
      0,
      0,
      2,
      4,
      NULL,
      NULL,
      ' 9- 9-1996',
      647.555520,
      ' 5-15-1983',
      551,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      3,
      3,
      0.316114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.953729,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      5.445323,
      2.585306,
      NULL,
      0,
      0.329374,
      0,
      NULL,
      1,
      1.196713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.406151,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.764294,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.575071,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      1,
      1.977065,
      3.979767,
      NULL,
      NULL,
      3.659322,
      0,
      0,
      0,
      0.402075,
      0,
      0.328039,
      0,
      0.045553,
      NULL,
      1.877845,
      0,
      1.224836,
      NULL,
      1.672850,
      1.208050,
      4.408579,
      3.945392,
      0,
      NULL,
      2,
      1.783034,
      1.769168,
      0.101953,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      24,
      NULL,
      1,
      NULL,
      3,
      '32204',
      '',
      '',
      1.123463,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.202391,
      27.222142,
      248.741806,
      41,
      0,
      18,
      7,
      69,
      3,
      NULL,
      NULL,
      0,
      1.498877,
      NULL,
      NULL,
      0.490956,
      NULL,
      0.060524,
      3,
      1.129378,
      1,
      0.125414,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.535001,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.416886,
      NULL,
      NULL,
      7.918653,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.627894,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.069672,
      0,
      0,
      NULL,
      NULL,
      3.983709,
      NULL,
      2.012006,
      0.824786,
      3.564727,
      NULL,
      NULL,
      NULL,
      3,
      1.265209,
      1.433575,
      1,
      1.286739,
      3,
      0,
      NULL,
      NULL,
      0.093431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.841746,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.951093,
      1,
      1.426599,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.307190,
      2.023911,
      1,
      2,
      3.696672,
      NULL,
      2,
      5,
      8,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.926493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.921093,
      1,
      9,
      7,
      3,
      5,
      1.883866,
      1,
      0.903137,
      0,
      1,
      3,
      2,
      3,
      3,
      NULL,
      1,
      2,
      1,
      0.232503,
      4,
      4.643583,
      0,
      1,
      3,
      2,
      NULL,
      2,
      0.526628,
      2.112094,
      NULL,
      2.213119,
      1.490882,
      NULL,
      3,
      5.647651,
      0,
      6.743693,
      0.951319,
      NULL,
      1,
      2,
      2,
      3,
      0.797755,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      5.766800,
      NULL,
      NULL,
      5.400580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.592340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.017088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.225916,
      0,
      0.568771,
      1,
      NULL,
      1.083633,
      8.345828,
      2,
      9,
      4,
      NULL,
      1,
      NULL,
      4.177424,
      2,
      0.766019,
      1,
      0.185632,
      0,
      0.124858,
      0,
      1.370575,
      1.125309,
      0.991919,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.975500,
      2,
      1,
      3.101572,
      2.629264,
      1,
      2.198844,
      NULL,
      2,
      NULL,
      3.262103,
      2.902542,
      NULL,
      2.380130,
      0.148235,
      0.706448,
      0,
      NULL,
      0,
      1.652676,
      0,
      1,
      0.002503,
      3.332338,
      2,
      0.074394,
      NULL,
      0,
      3,
      1,
      2,
      0.452471,
      1.824687,
      2,
      0.569776,
      2.024292,
      1.024172,
      3.658426,
      1,
      2.447253,
      0.379267,
      3.121068,
      0.528824,
      0,
      NULL,
      2,
      NULL,
      5.482122,
      5.273870,
      4.490672,
      0.995978,
      NULL,
      NULL,
      3.111592,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      66.293130,
      4,
      1.275508,
      NULL,
      NULL,
      0.330349,
      NULL,
      NULL,
      1.771961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.458958,
      22,
      1.491282,
      377.705644,
      NULL,
      1.774679,
      NULL,
      1.191927,
      1.983578,
      0,
      1,
      1.676996,
      NULL,
      0,
      1,
      0.551208,
      0.734173,
      0.386906,
      1,
      NULL,
      0.975087,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.041217,
      0.956468,
      1.408204,
      0,
      3,
      NULL,
      0.920561,
      NULL,
      NULL,
      0.677356,
      NULL,
      1,
      0.706007,
      1.017469,
      3.895112,
      NULL,
      3,
      1,
      1.746343,
      NULL,
      1.268241,
      1,
      1,
      0,
      0.955732,
      1,
      NULL,
      NULL,
      2.091306,
      3,
      NULL,
      0.266164,
      NULL,
      1,
      0.719977,
      1.821069,
      NULL,
      NULL,
      2.528716,
      0,
      1.773536,
      0,
      3,
      2.737912,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.197977,
      0,
      0,
      0,
      2.874102,
      1.068356,
      2.138336,
      2.636646,
      3.453989,
      3,
      2.964949,
      0,
      0.337081,
      0.600089,
      3.103173,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.465878,
      NULL,
      8.343461,
      1.087942,
      NULL,
      0.795205,
      0.425495,
      1,
      1.670259,
      0,
      1,
      3,
      3,
      7,
      1.539806,
      0,
      0,
      36.385633,
      33,
      2,
      0,
      2,
      '03024',
      '',
      '',
      1.323331,
      '',
      '',
      '',
      1.172357,
      '',
      '',
      '');
commit;
end;
/


