set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4333020',
      3.006785,
      0.414278,
      3,
      2,
      '0112',
      3.148136,
      1,
      NULL,
      NULL,
      ' 0- 8-1986',
      63,
      NULL,
      5,
      NULL,
      0.168890,
      NULL,
      NULL,
      2.342072,
      126,
      7.174553,
      0,
      ' 1-15-1978',
      ' 8- 8-1997',
      '11-17-1991',
      2,
      NULL,
      0,
      0.829791,
      1,
      1.950145,
      2,
      0.189051,
      NULL,
      NULL,
      6,
      19,
      2,
      1.409417,
      12,
      1,
      8.176052,
      0,
      NULL,
      2,
      3.856891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      5,
      1,
      0,
      0,
      0,
      1,
      7,
      0,
      1,
      0,
      0,
      0.113833,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.036651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.526088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1,
      NULL,
      4,
      3,
      NULL,
      0,
      1,
      3,
      2,
      1,
      0,
      1,
      0,
      4,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      3.571169,
      2.332492,
      ' 3- 1-2002',
      683,
      NULL,
      690.391621,
      2,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.763954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.016547,
      NULL,
      NULL,
      1.720476,
      1,
      3,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      1.908714,
      NULL,
      NULL,
      NULL,
      1.516030,
      5.200340,
      NULL,
      NULL,
      1.373323,
      2,
      1.098591,
      1,
      NULL,
      NULL,
      0,
      6,
      1.253437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.573921,
      1.572842,
      0,
      NULL,
      0,
      1.794476,
      59.796206,
      0.747186,
      0.635251,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480443,
      NULL,
      3,
      1,
      0,
      2,
      3,
      0,
      3,
      NULL,
      3,
      0,
      2,
      3,
      6,
      0,
      1,
      0.086811,
      3.094918,
      0,
      1.516137,
      NULL,
      0,
      1.442733,
      0.008491,
      0,
      0,
      0,
      NULL,
      5,
      0,
      10.403403,
      NULL,
      2,
      3.902141,
      NULL,
      5,
      2,
      NULL,
      2,
      3.301226,
      0,
      3.583553,
      43.708357,
      3,
      1.416552,
      NULL,
      56,
      24,
      NULL,
      2,
      NULL,
      4,
      '20020',
      '04322',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      27.228458,
      325.175548,
      25,
      0,
      0,
      11.975650,
      14,
      NULL,
      0,
      2.070407,
      2,
      3,
      0,
      0.550339,
      1.286535,
      0,
      NULL,
      2.531610,
      0,
      1,
      0.776136,
      2.049825,
      1,
      1,
      0.949418,
      NULL,
      2,
      3.478373,
      2,
      0.286328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2.477611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.850800,
      3.087041,
      1,
      0.771119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.141335,
      1.188382,
      NULL,
      NULL,
      0.957825,
      NULL,
      NULL,
      3.812130,
      NULL,
      1.091503,
      3,
      0.401808,
      1.586668,
      2,
      0.315916,
      NULL,
      3.516698,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      3.548397,
      0,
      NULL,
      1.072253,
      0,
      4.047602,
      1.516833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776972,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.274473,
      NULL,
      NULL,
      2.536989,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      4.905350,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.263861,
      NULL,
      NULL,
      0.834360,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.926142,
      NULL,
      0,
      7.198289,
      2.829962,
      6,
      NULL,
      0.665842,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      1,
      1.720462,
      NULL,
      4,
      4,
      3,
      2,
      1.097981,
      1,
      4.031058,
      1.175867,
      1,
      NULL,
      NULL,
      2.579856,
      0.773570,
      3.158269,
      5.014588,
      6,
      4.912315,
      2,
      1,
      0,
      1,
      2,
      2,
      0.232198,
      NULL,
      0,
      0.757390,
      NULL,
      2.178741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.692887,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.168395,
      NULL,
      NULL,
      0.352965,
      0,
      3,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672454,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.160139,
      NULL,
      NULL,
      NULL,
      0.201794,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868456,
      NULL,
      NULL,
      NULL,
      2.185694,
      NULL,
      NULL,
      NULL,
      0.000351,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.777348,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.072675,
      NULL,
      NULL,
      NULL,
      1.800246,
      4,
      NULL,
      3,
      0,
      115,
      175.606756,
      1,
      57,
      7,
      1,
      NULL,
      NULL,
      3,
      10.808364,
      NULL,
      1,
      NULL,
      NULL,
      0.162758,
      NULL,
      NULL,
      NULL,
      11,
      0.948924,
      1026,
      32,
      0.563079,
      1,
      0,
      0.960205,
      0,
      1.189878,
      1,
      1,
      NULL,
      0.822122,
      1.337833,
      NULL,
      0,
      NULL,
      0,
      1,
      0.748465,
      0.300331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559215,
      1.090281,
      NULL,
      1.990568,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.819898,
      1,
      1.473520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263653,
      NULL,
      0.909652,
      NULL,
      0.922965,
      NULL,
      NULL,
      NULL,
      1.617500,
      0.210118,
      0.748004,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446913,
      NULL,
      3.289249,
      0.203759,
      NULL,
      28,
      8.007976,
      1.936290,
      NULL,
      0.768824,
      NULL,
      1,
      4,
      NULL,
      8,
      1,
      0,
      1,
      3,
      5,
      1.966802,
      NULL,
      0,
      1.613523,
      0,
      NULL,
      1.437028,
      3.329735,
      NULL,
      NULL,
      0.038168,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275926,
      NULL,
      NULL,
      1,
      0.416455,
      NULL,
      1.698331,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.174591,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.112539,
      0.592144,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.701413,
      NULL,
      1.442218,
      NULL,
      1.613354,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.637525,
      NULL,
      NULL,
      NULL,
      1.330346,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      9,
      0,
      11.350863,
      0.389165,
      NULL,
      0,
      NULL,
      0.689286,
      NULL,
      3,
      NULL,
      3,
      0.907639,
      NULL,
      2,
      9,
      NULL,
      1,
      NULL,
      5,
      '12132',
      '41402',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


