set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9741228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1,
      1.450626,
      3,
      0.327713,
      0.485588,
      1.562434,
      2,
      '01',
      '00',
      48,
      16,
      '3434102',
      3.188203,
      1,
      2,
      1,
      '1134',
      4.274360,
      0,
      NULL,
      NULL,
      ' 7- 2-1991',
      129.616194,
      87.668763,
      NULL,
      0,
      NULL,
      ' 9-28-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-2003',
      '10-29-1993',
      ' 1-21-1992',
      1,
      3,
      1.156398,
      1,
      0,
      0,
      NULL,
      1,
      1.524755,
      40,
      3,
      11,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2.112953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.629268,
      1,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      1,
      0,
      1,
      0,
      1.245259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      5,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      1.082737,
      1,
      1,
      0,
      0,
      0.126437,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      3,
      1,
      0,
      4,
      4,
      0,
      2,
      4,
      2,
      NULL,
      1,
      4,
      2,
      NULL,
      5,
      2,
      NULL,
      1,
      2,
      '11-19-1987',
      349,
      NULL,
      24.926860,
      1.804172,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.265284,
      NULL,
      NULL,
      0.486333,
      1,
      NULL,
      NULL,
      NULL,
      1.244292,
      0.817496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      61,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.909218,
      0.352624,
      1,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.501410,
      0,
      1,
      1.206379,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.697653,
      8,
      NULL,
      0.516736,
      5.074724,
      5.220440,
      NULL,
      2,
      NULL,
      3,
      1.180298,
      2,
      45,
      NULL,
      0,
      NULL,
      NULL,
      20,
      66,
      1,
      1.326460,
      1.562924,
      '34310',
      '',
      '',
      1.188464,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.178358,
      24.047266,
      71,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.698516,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.787774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.111629,
      1.940424,
      1,
      1.195114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.669101,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117556,
      NULL,
      NULL,
      0.104970,
      NULL,
      NULL,
      0.319192,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.218525,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.566988,
      0,
      2.633904,
      NULL,
      3,
      0,
      2,
      2.444053,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716511,
      NULL,
      NULL,
      0.594878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570806,
      NULL,
      NULL,
      3,
      0.586915,
      NULL,
      NULL,
      3,
      NULL,
      1.187783,
      2,
      1.821586,
      NULL,
      0.668296,
      1,
      NULL,
      7,
      0.952784,
      0.431050,
      2,
      0,
      1,
      1.185282,
      1,
      0,
      NULL,
      1,
      1.020282,
      NULL,
      1,
      NULL,
      3,
      1.319810,
      NULL,
      1,
      NULL,
      1,
      1.206419,
      1,
      4,
      NULL,
      1.417260,
      1.356674,
      1.285676,
      1.491358,
      0.604110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434423,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.837305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266576,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.297082,
      1,
      0,
      1.437608,
      1,
      0,
      0.398950,
      NULL,
      NULL,
      0.707579,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.102258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743499,
      1.218214,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.057271,
      1,
      NULL,
      NULL,
      1.269200,
      1.701023,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.144760,
      NULL,
      NULL,
      0.818802,
      0.603550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680735,
      49.074217,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      17,
      7.443257,
      1,
      0.484322,
      1,
      1.176433,
      0.971576,
      1,
      0.262861,
      1.645664,
      1.744289,
      1.128337,
      1,
      0,
      0,
      1,
      1,
      1.996283,
      0,
      1.473309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.053380,
      0.171331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528749,
      0.700208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802369,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230390,
      0.247914,
      NULL,
      0,
      NULL,
      1.079314,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.012590,
      0.899658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.971735,
      2,
      5,
      NULL,
      0,
      17.237050,
      NULL,
      2,
      1.650368,
      NULL,
      1,
      1,
      0.195852,
      0,
      0,
      0.456416,
      0,
      1.954083,
      1.467460,
      0,
      0,
      NULL,
      1.419728,
      1.994998,
      1.473476,
      NULL,
      0,
      1,
      1.123736,
      2,
      0,
      NULL,
      1.497742,
      1,
      1,
      0,
      1,
      0.801981,
      3,
      0.239810,
      NULL,
      2.737226,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861582,
      1.992442,
      0,
      NULL,
      0,
      0.220094,
      2,
      4,
      6,
      0,
      0.560129,
      2.254911,
      NULL,
      66.084805,
      NULL,
      2,
      3.240444,
      '43141',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


