set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8531494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      '3023',
      2.353133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.019872,
      1,
      ' 5-29-1999',
      38,
      NULL,
      27.384951,
      149.278678,
      3,
      ' 5-17-1983',
      ' 3- 1-2001',
      NULL,
      0.078849,
      NULL,
      1.395531,
      0.961786,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7.249282,
      8,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      1,
      0,
      0,
      0,
      4,
      1,
      1,
      8,
      1,
      2,
      2,
      1,
      1.518165,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.422280,
      0.172848,
      0.752859,
      1,
      0,
      0.677704,
      0.757425,
      0,
      3.667658,
      0,
      2.316715,
      NULL,
      3,
      3,
      0,
      5,
      5,
      0,
      1,
      1.239310,
      0,
      NULL,
      NULL,
      0.257909,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      0,
      5,
      2,
      0,
      3,
      0,
      0,
      3,
      0,
      7,
      1,
      NULL,
      1,
      0,
      0.755207,
      NULL,
      0.473339,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      4,
      4,
      1,
      4,
      3,
      0,
      2,
      2,
      0,
      3,
      1,
      2,
      NULL,
      3,
      1,
      3,
      5,
      2,
      0,
      4.626470,
      1.421290,
      ' 6- 3-1998',
      115,
      ' 5-27-1996',
      91,
      2,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      3,
      1,
      1.251274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.090693,
      1.538195,
      2.906922,
      0.239640,
      2.556728,
      NULL,
      1.012271,
      2.647819,
      NULL,
      0,
      2.572390,
      1,
      1.029720,
      7,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7.268965,
      0.371222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.721599,
      1,
      NULL,
      0.651197,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      2.297729,
      3,
      1,
      NULL,
      1,
      1.280700,
      5.604017,
      0.835788,
      1.971663,
      NULL,
      0.980710,
      0.686894,
      1.014004,
      0.208173,
      0.918703,
      NULL,
      1,
      NULL,
      1.193533,
      4.630328,
      0,
      2,
      6.810428,
      8,
      0,
      2,
      3,
      5.568115,
      NULL,
      3,
      2.755202,
      NULL,
      3,
      3,
      NULL,
      NULL,
      30,
      51,
      2,
      1,
      3.587126,
      '03400',
      '31133',
      '',
      1.694734,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.721743,
      30.177941,
      28.876563,
      27,
      3,
      3,
      NULL,
      1,
      0,
      2,
      1.648932,
      NULL,
      0.761166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.591684,
      NULL,
      1,
      0,
      NULL,
      2,
      2,
      0.774917,
      0,
      3,
      NULL,
      0.148194,
      NULL,
      NULL,
      1.894674,
      NULL,
      1,
      NULL,
      2.785114,
      NULL,
      1.316583,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.967123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560453,
      2,
      NULL,
      0.855186,
      3,
      1,
      3.631495,
      NULL,
      0.251866,
      2.936375,
      2,
      0,
      0,
      1.030190,
      NULL,
      0.471963,
      0,
      3.036112,
      3,
      2.449062,
      2.502329,
      0,
      NULL,
      3.645974,
      2.076455,
      NULL,
      1.497285,
      1.981526,
      1.818376,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.384325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092383,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.034360,
      1.660752,
      NULL,
      1,
      0,
      0.601489,
      0,
      NULL,
      NULL,
      2,
      2.119648,
      7.261169,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7.377313,
      6,
      0.803256,
      NULL,
      NULL,
      1.616685,
      NULL,
      NULL,
      1.953003,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.213648,
      NULL,
      NULL,
      3,
      0,
      3,
      1.260986,
      NULL,
      NULL,
      0.576375,
      NULL,
      4,
      2,
      NULL,
      NULL,
      7,
      1.661643,
      6.270013,
      1.070038,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.808834,
      2,
      2,
      3,
      0.758817,
      3,
      NULL,
      NULL,
      1.855598,
      3.463453,
      0.976467,
      1,
      NULL,
      0.575785,
      NULL,
      2.913586,
      3,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3.636750,
      3,
      NULL,
      0.720597,
      1.137594,
      1,
      NULL,
      NULL,
      3.318356,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.508558,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.212190,
      1.765462,
      1.954007,
      1.813863,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815479,
      NULL,
      NULL,
      NULL,
      0.672008,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.413818,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.721970,
      NULL,
      NULL,
      NULL,
      0.851708,
      NULL,
      NULL,
      NULL,
      2.318615,
      NULL,
      NULL,
      NULL,
      1.088473,
      NULL,
      NULL,
      NULL,
      1.646148,
      NULL,
      NULL,
      NULL,
      2.963454,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.317700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.357019,
      NULL,
      3.027412,
      6.849918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147468,
      NULL,
      NULL,
      0.199195,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      44,
      NULL,
      1.174769,
      NULL,
      NULL,
      3,
      NULL,
      2.315813,
      0.136070,
      0.204566,
      1.972257,
      0,
      NULL,
      0.254048,
      1.354378,
      0,
      1.959787,
      2.188560,
      1.659621,
      0.912485,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      73,
      NULL,
      0,
      NULL,
      47.913606,
      NULL,
      0.583473,
      2.704453,
      3.551567,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.058775,
      NULL,
      0,
      NULL,
      0.310969,
      NULL,
      1,
      NULL,
      0.041497,
      NULL,
      1.883398,
      NULL,
      0.131456,
      NULL,
      NULL,
      NULL,
      1.682912,
      NULL,
      0.533907,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738386,
      NULL,
      NULL,
      1.144167,
      NULL,
      0.614253,
      NULL,
      NULL,
      NULL,
      0.013911,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      3.337061,
      5,
      NULL,
      NULL,
      NULL,
      1,
      1.263551,
      0.684071,
      0,
      NULL,
      0.768206,
      0.382640,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.940230,
      1.571633,
      NULL,
      0,
      NULL,
      NULL,
      0.945230,
      0,
      NULL,
      1.937535,
      0.539492,
      NULL,
      1.205490,
      0.132447,
      NULL,
      0,
      NULL,
      NULL,
      1.942597,
      0.412253,
      NULL,
      0,
      1.980795,
      0.217333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6,
      0,
      NULL,
      NULL,
      61.325259,
      77.516121,
      4,
      0,
      4,
      '14211',
      '14240',
      '',
      NULL,
      '',
      '',
      NULL,
      1.281075,
      '',
      NULL,
      '');
commit;
end;
/


