set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9767042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.841736,
      NULL,
      3.784717,
      2.344770,
      1.754064,
      3,
      0,
      1.713829,
      '40',
      '01034040',
      11,
      32.925729,
      '0210322',
      0,
      0,
      3,
      0,
      '0301',
      0.221802,
      NULL,
      NULL,
      NULL,
      ' 4-11-2000',
      107.367125,
      136.323932,
      NULL,
      2,
      12.576407,
      ' 4- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 6-15-1996',
      NULL,
      0.912291,
      1,
      3.660811,
      1.147049,
      NULL,
      1,
      NULL,
      NULL,
      12.446163,
      7,
      11.981367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      5,
      0,
      NULL,
      0,
      0.848748,
      1,
      1.198042,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0.791496,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      3,
      1,
      0,
      0,
      2,
      NULL,
      1,
      0.986789,
      3.620374,
      0.342805,
      2,
      3,
      3,
      1,
      0.135775,
      0,
      0,
      3,
      NULL,
      0,
      2,
      0,
      1.149294,
      3.057491,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      1,
      1,
      1,
      4,
      0,
      8,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      4,
      4,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      4,
      1,
      5,
      2,
      4,
      NULL,
      4,
      5,
      3,
      2,
      NULL,
      4,
      NULL,
      2.315964,
      '11- 1-1985',
      23.928668,
      ' 9-27-2000',
      NULL,
      NULL,
      1,
      0,
      4,
      3,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      5,
      5,
      0,
      3,
      5,
      4,
      2,
      3.182776,
      12.752412,
      1,
      ' 6- 4-1982',
      16.506166,
      ' 7-21-1992',
      9.885060,
      1.118031,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0.372600,
      3,
      0,
      NULL,
      2.283533,
      0,
      1.541139,
      1.580491,
      1.001623,
      1.724332,
      0.232151,
      1.145444,
      1.615920,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.820192,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268608,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.539219,
      19,
      0.737672,
      0.619646,
      NULL,
      NULL,
      NULL,
      2,
      1.567334,
      NULL,
      0,
      0,
      0,
      1,
      2,
      1,
      2,
      NULL,
      3,
      2,
      NULL,
      2.073643,
      NULL,
      NULL,
      1.717275,
      1,
      NULL,
      0,
      1.395166,
      2,
      1.775489,
      NULL,
      1,
      1,
      0.895876,
      2,
      0.761896,
      1.912254,
      0,
      2.259397,
      0.951921,
      5,
      3.753057,
      NULL,
      4.335758,
      2,
      2.500839,
      7,
      NULL,
      1.269344,
      3.600937,
      57,
      NULL,
      1,
      24,
      NULL,
      NULL,
      53,
      5,
      4.990466,
      NULL,
      '1340',
      NULL,
      '',
      0.705243,
      '',
      NULL,
      '',
      1.900324,
      '',
      '',
      NULL,
      NULL,
      53.365450,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.527573,
      NULL,
      1,
      0.076875,
      NULL,
      NULL,
      1.382435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.617294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086796,
      130,
      0,
      0,
      1,
      0.867032,
      NULL,
      0,
      1.055862,
      NULL,
      NULL,
      0.116435,
      0,
      NULL,
      0.913603,
      1.180186,
      0.162373,
      0,
      1.311915,
      1.329953,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540160,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783553,
      1.117472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175784,
      NULL,
      NULL,
      NULL,
      0.591486,
      NULL,
      NULL,
      NULL,
      0.308172,
      NULL,
      1,
      NULL,
      0.294895,
      1.898538,
      0.559271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.356676,
      NULL,
      1,
      1,
      1,
      1,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.512295,
      1,
      NULL,
      0.561277,
      NULL,
      NULL,
      NULL,
      0.192098,
      NULL,
      NULL,
      1,
      NULL,
      1.146919,
      0.369226,
      NULL,
      0.687513,
      1.073394,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.716245,
      NULL,
      NULL,
      1.035662,
      NULL,
      0,
      0.270016,
      3,
      2.910097,
      NULL,
      2.601509,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.999494,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.072005,
      NULL,
      NULL,
      NULL,
      1.515106,
      NULL,
      10.143497,
      2.922570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.710496,
      NULL,
      1.310025,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.855768,
      156,
      1,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


