set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6401936';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      0,
      0.253544,
      3,
      1,
      '3100',
      0,
      0.237856,
      NULL,
      NULL,
      '10- 1-1978',
      33.660641,
      NULL,
      0,
      NULL,
      NULL,
      ' 5-29-1988',
      118.810928,
      5,
      263.428347,
      99.537388,
      0,
      ' 3- 0-1985',
      '11-22-1986',
      ' 5-28-1984',
      1.867239,
      3,
      2,
      NULL,
      NULL,
      3,
      0,
      0.656491,
      1,
      410,
      5,
      4,
      NULL,
      38,
      NULL,
      5,
      5.218474,
      4,
      NULL,
      7.094061,
      1,
      1,
      0,
      NULL,
      1,
      0.675078,
      0,
      1.994844,
      0,
      NULL,
      134.698260,
      3,
      0,
      3,
      0,
      4,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      5,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.290437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      1,
      0,
      1,
      0,
      4,
      1,
      NULL,
      0,
      3.827226,
      0,
      0,
      0,
      0,
      0.868802,
      NULL,
      1.748986,
      4,
      4,
      5,
      2,
      3,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      2,
      2,
      1,
      4,
      4,
      4,
      3,
      NULL,
      0,
      ' 0- 1-1994',
      1066.825724,
      NULL,
      1506,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0.121464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1.331448,
      1.855170,
      0,
      1.585316,
      NULL,
      NULL,
      NULL,
      1.527314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.236496,
      0,
      1.163755,
      0,
      0,
      1.151789,
      1309.894097,
      1.286277,
      0.482250,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      18.134053,
      182,
      167.676044,
      4.293666,
      119.826061,
      157,
      79.263813,
      180,
      NULL,
      193.826078,
      49,
      127.738650,
      148,
      0,
      8,
      9.978691,
      1.761050,
      9,
      NULL,
      1.784590,
      NULL,
      0,
      1,
      0.401191,
      1.407921,
      0.173431,
      2.082224,
      1.940274,
      NULL,
      26.191257,
      2,
      0,
      NULL,
      39,
      7,
      29.675109,
      3,
      1,
      2.368509,
      '11011',
      NULL,
      '',
      0.507453,
      '',
      '',
      NULL,
      4,
      '01010',
      '43012',
      '',
      2,
      31.486675,
      NULL,
      1,
      NULL,
      17,
      25,
      336.670378,
      3,
      3.595374,
      NULL,
      1.849778,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.832724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      0.613500,
      1.116101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180718,
      NULL,
      NULL,
      0.574056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      7,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.176801,
      NULL,
      NULL,
      NULL,
      1.589072,
      2.836718,
      0,
      1.435663,
      NULL,
      NULL,
      0.086738,
      NULL,
      NULL,
      2.520056,
      0.483073,
      0.693081,
      0,
      3,
      0.860202,
      3.287039,
      1.977571,
      0.527145,
      0.216460,
      1.048203,
      0.850980,
      0,
      1,
      NULL,
      0.685510,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.681732,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.368211,
      NULL,
      NULL,
      NULL,
      0.043295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2.233444,
      0.349796,
      NULL,
      NULL,
      7,
      NULL,
      1.986222,
      1,
      1,
      0.571765,
      0.225914,
      NULL,
      NULL,
      1.098197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.857607,
      0,
      0,
      NULL,
      1.986892,
      1,
      0.026441,
      NULL,
      NULL,
      7.139859,
      1,
      6.896962,
      NULL,
      0,
      3.738896,
      6.304057,
      2,
      3,
      1,
      NULL,
      NULL,
      2.178709,
      0,
      3.934013,
      0.685693,
      1,
      2,
      9,
      3,
      NULL,
      2.839053,
      1,
      0,
      1,
      NULL,
      NULL,
      0.940996,
      1,
      1.213944,
      0.133819,
      1,
      2.411265,
      1,
      0,
      3,
      5,
      1,
      7.194342,
      0,
      4,
      NULL,
      0.404517,
      0.480887,
      1,
      1,
      1.183096,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.643419,
      NULL,
      NULL,
      1.063903,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.860573,
      NULL,
      NULL,
      0.947312,
      NULL,
      NULL,
      1,
      0.359429,
      NULL,
      0.508774,
      0,
      NULL,
      3.412665,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.706736,
      NULL,
      NULL,
      0.157085,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.029975,
      1.772072,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.348131,
      2.300822,
      3,
      0,
      0.239320,
      191,
      282,
      0.081283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      333.189881,
      38,
      1.144677,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      1.794130,
      NULL,
      0.177716,
      1.597801,
      0,
      0.553554,
      1.491335,
      0.240946,
      1,
      0,
      1.020746,
      1.368624,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966613,
      0.682412,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      2,
      2.340140,
      NULL,
      3,
      2,
      0.327603,
      2.370176,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.551738,
      0.267714,
      1,
      1.858733,
      0.177024,
      1,
      1.704588,
      0.027967,
      NULL,
      1,
      0,
      0.414983,
      1,
      0,
      0.771359,
      0,
      0.936402,
      1.597846,
      0,
      1,
      0,
      NULL,
      0.773634,
      3.254849,
      NULL,
      0.739379,
      1,
      NULL,
      NULL,
      0.538016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.335441,
      NULL,
      0,
      0.493137,
      0.517797,
      0,
      2,
      0,
      1,
      NULL,
      0.246898,
      27.279960,
      2,
      5,
      0,
      5,
      '33133',
      NULL,
      '33010',
      0.775469,
      '',
      '',
      '',
      4.363136,
      '44143',
      NULL,
      '');
commit;
end;
/


