set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703672';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '23',
      14.323868,
      NULL,
      NULL,
      0,
      0.572886,
      NULL,
      0,
      '3312',
      3,
      0.850775,
      NULL,
      NULL,
      NULL,
      NULL,
      8.305022,
      NULL,
      0.851165,
      1.414807,
      ' 2- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10- 3-1988',
      ' 9-26-1974',
      '10-25-1986',
      3.179131,
      3,
      3,
      NULL,
      1,
      2,
      NULL,
      0.815875,
      NULL,
      19.884025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.092214,
      1,
      NULL,
      0.741733,
      1,
      0,
      NULL,
      1.955310,
      NULL,
      0.039254,
      NULL,
      5,
      2,
      0,
      3.654807,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.762441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      3,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1.609796,
      NULL,
      NULL,
      1,
      0,
      1.496997,
      NULL,
      1.573265,
      1,
      1,
      NULL,
      0,
      0,
      0,
      3,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      5,
      0,
      4,
      1,
      1,
      0.738477,
      1.426128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.632547,
      2.585707,
      0.576645,
      0.958102,
      2.080204,
      0.051444,
      4.370956,
      1.842192,
      1,
      1.739016,
      NULL,
      1.728150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1.290440,
      0.980718,
      0,
      1.718249,
      2.073168,
      1975,
      0.391085,
      1.640547,
      14,
      13.430589,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      3,
      NULL,
      2,
      2,
      1,
      3,
      NULL,
      1,
      1.631880,
      0,
      1,
      0,
      1.611521,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1.489302,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.294110,
      9.941706,
      1.748008,
      3,
      NULL,
      1.189069,
      3.930333,
      NULL,
      0.297998,
      0.241586,
      61,
      1,
      2.432440,
      NULL,
      NULL,
      59,
      NULL,
      1,
      3.095007,
      3.324386,
      '01221',
      '',
      '',
      1,
      '',
      '',
      '',
      5,
      NULL,
      '14424',
      '32023',
      2,
      6.601824,
      676.172829,
      NULL,
      0,
      11.539149,
      9,
      674.052176,
      5,
      0.989148,
      NULL,
      NULL,
      1,
      0,
      1.965921,
      NULL,
      1.535349,
      1.487816,
      2,
      3.304351,
      3,
      1,
      3,
      1.008738,
      3,
      NULL,
      1,
      0,
      1,
      1.706536,
      1.823732,
      2,
      3,
      3.486897,
      1.160282,
      1.728032,
      1.395863,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.246636,
      4,
      NULL,
      1.370793,
      NULL,
      NULL,
      NULL,
      0.474069,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2,
      2.772833,
      NULL,
      2,
      NULL,
      0,
      3.352233,
      2.501094,
      0,
      1,
      2.377125,
      0,
      1,
      3.879981,
      3,
      1,
      0,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.228316,
      0.604549,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.997085,
      3.174665,
      1.458091,
      NULL,
      3,
      NULL,
      3.054826,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422016,
      2.225443,
      0.119996,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.738163,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.216875,
      0,
      1,
      7.520157,
      1.516183,
      2,
      2,
      0.933029,
      1.530756,
      NULL,
      1,
      0,
      2.690500,
      NULL,
      0,
      NULL,
      NULL,
      6.537727,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.745587,
      2.797171,
      2,
      1,
      NULL,
      9,
      3.292117,
      1,
      NULL,
      1,
      3,
      0,
      1,
      3.200806,
      1.170409,
      3.798365,
      0,
      0.412907,
      1.626234,
      3.139680,
      8.636415,
      2.974282,
      3,
      7,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1.188728,
      NULL,
      0,
      1,
      0,
      1.086000,
      NULL,
      NULL,
      3.434177,
      NULL,
      NULL,
      168.700159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.267358,
      NULL,
      NULL,
      3.207222,
      NULL,
      NULL,
      3.872664,
      NULL,
      NULL,
      1.609349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.738987,
      1,
      1.755481,
      1,
      NULL,
      NULL,
      1.963021,
      NULL,
      NULL,
      NULL,
      0.091776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452818,
      1.933624,
      NULL,
      NULL,
      3.364366,
      NULL,
      NULL,
      NULL,
      3.376763,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.903254,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.416952,
      0,
      NULL,
      NULL,
      1.324754,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.341323,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.620806,
      181,
      138,
      2.132819,
      2,
      2,
      1,
      NULL,
      NULL,
      2.028731,
      157,
      7,
      3.822165,
      167,
      36.597140,
      2,
      31,
      NULL,
      2,
      NULL,
      1,
      146,
      7.790164,
      1.062067,
      0,
      1,
      1.836624,
      NULL,
      1.475407,
      1.493936,
      0.917359,
      1.257104,
      0.123191,
      NULL,
      1.259546,
      1.606891,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.049940,
      2.741841,
      5.030458,
      3.873411,
      2,
      2,
      NULL,
      NULL,
      1.960450,
      NULL,
      NULL,
      NULL,
      1.708968,
      1,
      1,
      1,
      NULL,
      1,
      0.844782,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.553252,
      1.515196,
      1.871782,
      0.732870,
      0,
      0,
      0,
      0.923307,
      NULL,
      0.071623,
      0.926862,
      1,
      NULL,
      2.032308,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912506,
      1.473935,
      1.791196,
      0,
      1,
      NULL,
      0,
      0,
      5,
      0.817349,
      NULL,
      NULL,
      NULL,
      16.084085,
      3,
      5,
      3.645130,
      '42134',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      2.414118,
      '21412',
      '',
      '');
commit;
end;
/


