set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '4330112',
      2,
      1.580398,
      1,
      NULL,
      '4202',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-18-1984',
      5.271978,
      NULL,
      1,
      1.248196,
      1.305658,
      ' 1-13-1989',
      NULL,
      3,
      184,
      NULL,
      NULL,
      ' 0-12-1983',
      ' 9-21-1998',
      ' 4- 5-2000',
      0.696503,
      1.281617,
      0.175379,
      1,
      1.977945,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      9.766574,
      3.676354,
      137,
      121.724993,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.457687,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      6,
      2.304871,
      4,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0.747802,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.216740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      4,
      0,
      NULL,
      1,
      1,
      0,
      4,
      2,
      0,
      4,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      3,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      5,
      5,
      1,
      3,
      1,
      NULL,
      4,
      NULL,
      ' 7- 8-2001',
      191.719581,
      NULL,
      408,
      2,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      0,
      1,
      NULL,
      1.248892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      393.925851,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.972559,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.913295,
      1,
      1.601515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.338353,
      1,
      0,
      0.187514,
      0.684210,
      0.420508,
      0.012167,
      67.431665,
      2.896887,
      1.826796,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.640952,
      0,
      0,
      2,
      0,
      3,
      NULL,
      0,
      2,
      2,
      NULL,
      3,
      0.809091,
      0,
      1.627279,
      0,
      0.176743,
      1.560082,
      2.109932,
      0.907450,
      1,
      1.233413,
      NULL,
      0.074977,
      0.252658,
      1.134741,
      0,
      1.466859,
      2,
      0.805626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518058,
      NULL,
      NULL,
      0,
      30.164701,
      2,
      0.186660,
      3,
      '23224',
      '',
      '',
      1.856887,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.810209,
      25.025796,
      27,
      15.418330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.400588,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.001437,
      NULL,
      NULL,
      0.195036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.247365,
      2,
      1.943067,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.161655,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.702864,
      6,
      1.573008,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.010560,
      0.851183,
      0,
      1.104216,
      2.565953,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.748588,
      NULL,
      1,
      0.101444,
      0.967848,
      0,
      1,
      0.339521,
      NULL,
      0,
      1.430129,
      0,
      1,
      NULL,
      NULL,
      0.270455,
      NULL,
      NULL,
      NULL,
      0.719181,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.366648,
      3.461938,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.049270,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.095826,
      NULL,
      NULL,
      NULL,
      3.788756,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392314,
      3.546166,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336794,
      NULL,
      NULL,
      NULL,
      0.504724,
      1,
      2.249810,
      1,
      1,
      7.934322,
      1.050191,
      2,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.006102,
      NULL,
      5,
      0,
      3,
      1,
      3.800045,
      2,
      2.358464,
      2.467886,
      0.143909,
      2.347582,
      NULL,
      2.716693,
      NULL,
      10.937025,
      1,
      0.828590,
      NULL,
      5.121082,
      0.939071,
      3.513021,
      2,
      4,
      0,
      1.583384,
      1.816841,
      1.093397,
      0.505594,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349884,
      NULL,
      NULL,
      1.011206,
      NULL,
      NULL,
      1,
      0,
      0.739121,
      0,
      1.558770,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      424.892080,
      NULL,
      NULL,
      NULL,
      0.419306,
      NULL,
      NULL,
      NULL,
      1.787343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091824,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.569692,
      NULL,
      NULL,
      NULL,
      0.326545,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.884088,
      NULL,
      NULL,
      NULL,
      2,
      71,
      45,
      1.272621,
      1207.456664,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.028925,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      19699.509284,
      1.052685,
      0,
      0,
      1.035822,
      1,
      0.367545,
      NULL,
      0.667198,
      NULL,
      0.254032,
      0,
      0,
      1.057951,
      1,
      NULL,
      0.732743,
      0.912970,
      0,
      1.150199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9,
      1,
      NULL,
      2,
      1,
      20.879259,
      1,
      NULL,
      1.174220,
      1,
      0,
      NULL,
      0.429639,
      1.982008,
      NULL,
      1,
      1.329856,
      NULL,
      1,
      0.166299,
      NULL,
      3,
      2.666747,
      NULL,
      1.597147,
      0.104990,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.370615,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.569723,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.783470,
      NULL,
      3,
      NULL,
      7,
      3.764321,
      0.059690,
      1.783301,
      20.324550,
      7,
      1,
      NULL,
      NULL,
      '33112',
      '',
      '',
      1,
      '',
      '',
      '',
      1.449448,
      '',
      '',
      NULL);
commit;
end;
/


