set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.752819,
      1.504433,
      1.558246,
      3.575105,
      2.022608,
      0.413686,
      0.520131,
      2,
      '312',
      NULL,
      47,
      10,
      '3313001',
      1,
      0.108901,
      1,
      NULL,
      '2224',
      1,
      0.836943,
      NULL,
      NULL,
      ' 9-10-1988',
      41.576177,
      35,
      NULL,
      0.041481,
      2.267143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.022436,
      1.989120,
      2.809146,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      1,
      0,
      1,
      0,
      NULL,
      1.040252,
      0,
      1.939659,
      0,
      3,
      2,
      2,
      0.216936,
      0,
      1,
      4,
      3,
      1,
      4,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.574993,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.098500,
      NULL,
      NULL,
      1,
      0,
      0,
      1.762152,
      0.820765,
      NULL,
      0.364082,
      1,
      1,
      1,
      NULL,
      1,
      1.955693,
      1,
      0,
      2,
      7.775319,
      1,
      0,
      3.530707,
      0.398193,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      0,
      5,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0.496767,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      5,
      5,
      3,
      1,
      NULL,
      0,
      0,
      2,
      2,
      0,
      NULL,
      3,
      3,
      4,
      0,
      NULL,
      NULL,
      NULL,
      3.426049,
      ' 9- 0-2000',
      NULL,
      ' 9-11-1982',
      10,
      2.334723,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.699045,
      1.145735,
      3,
      4,
      3,
      NULL,
      1,
      NULL,
      3.003899,
      NULL,
      0.716048,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.599042,
      3.664998,
      3.520346,
      1,
      0,
      1.210832,
      NULL,
      NULL,
      0.740926,
      6.508798,
      1.405207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      1.211938,
      1.786254,
      NULL,
      1,
      NULL,
      3.304757,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.546689,
      0.780367,
      0,
      0,
      1,
      2,
      NULL,
      1,
      2,
      2,
      0,
      0,
      1.939892,
      0.210188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685808,
      0,
      0.114998,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      0.475117,
      6.368626,
      6,
      1,
      5,
      NULL,
      4,
      4.024663,
      0,
      4.663365,
      1,
      NULL,
      NULL,
      28.117036,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.597145,
      2.584469,
      '31031',
      NULL,
      '43311',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      16,
      5.908288,
      NULL,
      1,
      28,
      5,
      2,
      4,
      2,
      2,
      3,
      1.902499,
      NULL,
      NULL,
      1.907840,
      2.847399,
      0.211945,
      1.948804,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.697625,
      NULL,
      3,
      NULL,
      3.403275,
      2,
      1,
      3.544337,
      1,
      1,
      NULL,
      NULL,
      1.265119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.067141,
      1,
      1,
      3,
      2.279642,
      NULL,
      3.468034,
      1.728098,
      NULL,
      NULL,
      1.654200,
      NULL,
      NULL,
      0.341607,
      0.354824,
      1,
      0.514410,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.913922,
      1.149819,
      1,
      0.056416,
      0,
      2.083575,
      2,
      0.735490,
      NULL,
      0.188295,
      NULL,
      NULL,
      NULL,
      1.274022,
      0,
      5,
      3.094949,
      0,
      0,
      1.729944,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.004741,
      3.846287,
      NULL,
      NULL,
      2,
      3.993315,
      0.079193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659689,
      NULL,
      NULL,
      0.710241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763338,
      NULL,
      NULL,
      0.094642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.968468,
      NULL,
      NULL,
      1.126376,
      NULL,
      NULL,
      2,
      7.388044,
      NULL,
      1.396914,
      NULL,
      NULL,
      0.973864,
      NULL,
      NULL,
      3.423785,
      2,
      NULL,
      2,
      1,
      2,
      4,
      NULL,
      4.650831,
      2,
      1,
      2.001081,
      0,
      1.155255,
      3.678139,
      2,
      1,
      3.391586,
      0,
      NULL,
      3.232504,
      5,
      5.791850,
      5,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      1.008615,
      1.859167,
      0.891871,
      1,
      0.710779,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.173129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.721045,
      1,
      0.619333,
      NULL,
      2,
      NULL,
      0.955583,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.523965,
      44,
      NULL,
      NULL,
      1.315501,
      1,
      NULL,
      NULL,
      0.343813,
      2.625564,
      NULL,
      NULL,
      0.780015,
      2.512667,
      NULL,
      NULL,
      0.248678,
      0.746442,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.532388,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.914238,
      1,
      NULL,
      NULL,
      1.758002,
      3,
      NULL,
      NULL,
      1.407997,
      3.509493,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      14,
      8.266725,
      NULL,
      NULL,
      0.613717,
      NULL,
      4.288299,
      7,
      0,
      NULL,
      7.096201,
      2,
      0.795023,
      23,
      NULL,
      1.679714,
      NULL,
      NULL,
      0.092247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.904040,
      NULL,
      0,
      NULL,
      0.366172,
      1.175188,
      1,
      0.296988,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.035387,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.549298,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.251023,
      NULL,
      5,
      NULL,
      0.373879,
      0,
      NULL,
      NULL,
      NULL,
      0.228313,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.645473,
      NULL,
      1.848636,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920115,
      NULL,
      1,
      1.513032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.934358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.780118,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.729177,
      NULL,
      1.538421,
      NULL,
      16,
      NULL,
      2.225877,
      NULL,
      NULL,
      NULL,
      0.598922,
      NULL,
      1.279731,
      NULL,
      1.983150,
      0.629828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.081305,
      0,
      3.165752,
      NULL,
      0,
      NULL,
      9.528100,
      NULL,
      2.751548,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.898952,
      NULL,
      1.789366,
      NULL,
      NULL,
      1.573808,
      14.869958,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1,
      1,
      NULL,
      1,
      0.366634,
      1.034884,
      NULL,
      0.790410,
      1.113407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160822,
      NULL,
      NULL,
      1.810369,
      NULL,
      2.931496,
      NULL,
      NULL,
      1.966844,
      1.985679,
      NULL,
      NULL,
      1,
      NULL,
      0.149877,
      1.301564,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.019990,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.555621,
      1,
      NULL,
      0.565984,
      NULL,
      0,
      NULL,
      3.914053,
      NULL,
      0.972680,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.160550,
      NULL,
      0,
      NULL,
      0.602692,
      NULL,
      0.754783,
      NULL,
      0.914839,
      NULL,
      1.735218,
      NULL,
      14,
      0,
      NULL,
      0.327246,
      NULL,
      3.051193,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      48.885395,
      79.759874,
      1,
      NULL,
      NULL,
      NULL,
      '0130',
      '02410',
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


