set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107980';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '3100024',
      1.389052,
      NULL,
      1,
      2,
      '2031',
      1,
      3.737353,
      4,
      NULL,
      NULL,
      65.434741,
      NULL,
      2,
      3,
      NULL,
      NULL,
      43,
      0,
      NULL,
      98.345479,
      5,
      NULL,
      NULL,
      ' 2-26-1997',
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      99.202865,
      8,
      12.492332,
      NULL,
      NULL,
      20.584142,
      5,
      NULL,
      NULL,
      0,
      7.633444,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.981370,
      1,
      NULL,
      0.236570,
      0.938267,
      125.484065,
      NULL,
      NULL,
      0,
      2.769974,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      2,
      1,
      0,
      1.821792,
      2,
      2,
      0,
      1,
      0.158140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      NULL,
      0.958232,
      NULL,
      0.281879,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.343631,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      0.559765,
      NULL,
      NULL,
      1.297240,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      5,
      1,
      0,
      NULL,
      0,
      1,
      0,
      0,
      2.385410,
      1,
      1,
      0,
      NULL,
      1.930416,
      NULL,
      1.296704,
      NULL,
      5,
      3,
      3,
      0,
      5,
      4,
      5,
      5,
      1,
      0,
      5,
      5,
      3,
      5,
      4,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      4,
      4,
      3,
      7.591644,
      3.784639,
      ' 2-22-2002',
      1253,
      ' 5-25-1980',
      1616.149775,
      1.949040,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.151513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      11.937735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.857278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.039623,
      NULL,
      1.715796,
      NULL,
      1.535725,
      0.178206,
      NULL,
      NULL,
      1.131481,
      NULL,
      NULL,
      NULL,
      3,
      1.758806,
      3,
      1,
      2,
      3,
      1,
      1,
      NULL,
      0,
      0,
      3,
      1,
      0,
      0,
      0.861564,
      1.318291,
      1.815455,
      0.671200,
      0.803390,
      NULL,
      0.946218,
      0.177664,
      1,
      1.734331,
      NULL,
      1,
      NULL,
      0,
      1,
      3,
      0.603300,
      1.739683,
      1.531785,
      4.859345,
      1.389592,
      7.498501,
      0,
      NULL,
      1.431095,
      3.365863,
      1,
      2.053326,
      0,
      47.373979,
      1,
      0.645925,
      55,
      NULL,
      NULL,
      NULL,
      2,
      0.234042,
      2,
      '40043',
      NULL,
      NULL,
      1.366402,
      NULL,
      NULL,
      '',
      1,
      '23211',
      NULL,
      '',
      NULL,
      6,
      NULL,
      1.675768,
      0.000980,
      NULL,
      5,
      154,
      1,
      0,
      17.445403,
      12.947229,
      1,
      NULL,
      NULL,
      NULL,
      1.834530,
      12,
      1,
      15.252319,
      NULL,
      NULL,
      11.300001,
      3.922953,
      0.819422,
      NULL,
      NULL,
      1,
      3.561086,
      NULL,
      0,
      9,
      7,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.752345,
      16,
      NULL,
      19,
      NULL,
      NULL,
      8.269739,
      NULL,
      1.712056,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.990933,
      1.681498,
      NULL,
      NULL,
      3.315890,
      NULL,
      2.611262,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      0.498484,
      0,
      0.495203,
      0,
      0,
      3.688465,
      0,
      1,
      16.266633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      8,
      11,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417070,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.229303,
      15.387881,
      2.883747,
      1,
      3,
      2,
      1,
      NULL,
      NULL,
      4.527463,
      3,
      0.712717,
      3,
      5.674171,
      6,
      1.915961,
      4,
      0,
      5.871609,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002527,
      NULL,
      NULL,
      0.529978,
      NULL,
      NULL,
      3.743242,
      NULL,
      0,
      2,
      18,
      0.989212,
      NULL,
      NULL,
      0.698060,
      3,
      0.821010,
      2.080423,
      5,
      NULL,
      NULL,
      0,
      0.515598,
      NULL,
      1.488767,
      3.382650,
      NULL,
      3.656563,
      0.531164,
      1,
      NULL,
      4.978966,
      3,
      1,
      19.317479,
      NULL,
      3,
      5,
      2,
      1.083635,
      17.003475,
      1,
      0,
      NULL,
      3,
      6.024910,
      1.036164,
      NULL,
      9,
      1.233466,
      NULL,
      2.280741,
      3,
      1,
      0.772870,
      0.496926,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      16.845189,
      NULL,
      NULL,
      5.037498,
      NULL,
      NULL,
      1.685065,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.966302,
      0,
      0.013992,
      2,
      0.751664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.456152,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.434352,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.808229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.041275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.038936,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      2.522543,
      208,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.105289,
      NULL,
      1.687071,
      NULL,
      NULL,
      NULL,
      1.479266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      491,
      3,
      0,
      1,
      1,
      NULL,
      1.587230,
      0,
      0,
      0.354792,
      0.326257,
      2,
      0.391393,
      0,
      0.286659,
      0.657385,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.320276,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.998941,
      NULL,
      1.609665,
      NULL,
      0.593207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749528,
      1,
      0.109430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.295190,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.527246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.210378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928398,
      2.407043,
      NULL,
      3.423625,
      NULL,
      3,
      NULL,
      255.124693,
      NULL,
      3,
      NULL,
      3.815968,
      NULL,
      1.960721,
      0,
      1.632565,
      16.010467,
      26.330420,
      0.463444,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.092247,
      0.356239,
      1,
      4,
      2,
      2.188854,
      0,
      1.001497,
      NULL,
      NULL,
      0.766543,
      NULL,
      1,
      0.816610,
      NULL,
      0.554743,
      1,
      NULL,
      1,
      0,
      NULL,
      0.855304,
      1,
      NULL,
      1.385319,
      NULL,
      NULL,
      1.155362,
      1,
      NULL,
      0,
      1.997683,
      NULL,
      1,
      0,
      NULL,
      1.087000,
      1,
      NULL,
      1.727175,
      0.490068,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.732415,
      NULL,
      4,
      1,
      6,
      3,
      0.564347,
      3.611160,
      21,
      13,
      2,
      0,
      NULL,
      '32044',
      '43214',
      '13102',
      1.156959,
      '',
      '',
      '',
      3.817669,
      NULL,
      '1323',
      '');
commit;
end;
/


