set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      NULL,
      38,
      23.896895,
      '1443402',
      0.032857,
      0.517571,
      3,
      0,
      '2121',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1978',
      14.425339,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 7-2003',
      ' 5-14-1991',
      ' 5-20-1984',
      NULL,
      3,
      2.409948,
      1.243811,
      1.705950,
      NULL,
      1,
      0.877465,
      1,
      NULL,
      4,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.411323,
      NULL,
      0,
      1,
      0,
      0,
      0.943970,
      NULL,
      NULL,
      1,
      NULL,
      5,
      3,
      6,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.176156,
      1.509470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      4,
      1,
      1,
      2,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      5,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.343591,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.723576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.402417,
      NULL,
      1.273703,
      0.766656,
      NULL,
      NULL,
      2.996371,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      1,
      3,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.627285,
      0.110250,
      2.828064,
      NULL,
      1.319744,
      1.441893,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      2.039509,
      NULL,
      1.481996,
      1.581127,
      NULL,
      5.225005,
      NULL,
      1.995464,
      3,
      NULL,
      2,
      NULL,
      NULL,
      2.391651,
      0.881957,
      12.715968,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      5,
      1.614973,
      '24443',
      '',
      '',
      1,
      '',
      '',
      '',
      1.665543,
      '',
      '',
      '',
      2.433443,
      14,
      230.681259,
      9.745643,
      0.389870,
      18,
      NULL,
      170.196351,
      2,
      NULL,
      0,
      1.064757,
      NULL,
      NULL,
      NULL,
      3,
      3.507719,
      0,
      0.980185,
      NULL,
      3.601159,
      2,
      3.281080,
      0.499931,
      1.777505,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.779660,
      NULL,
      NULL,
      1.943764,
      NULL,
      NULL,
      0.271717,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4.395162,
      NULL,
      NULL,
      1,
      2.139900,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.651664,
      NULL,
      NULL,
      NULL,
      1.729348,
      NULL,
      NULL,
      1.327617,
      1.653804,
      2.087552,
      1.780429,
      3,
      NULL,
      2.635397,
      3.362743,
      1.818491,
      0.483821,
      0.735659,
      0,
      0.181922,
      2.013167,
      NULL,
      NULL,
      3.370789,
      1.709456,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.623802,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.663633,
      2.228895,
      3,
      3,
      0.342350,
      1,
      1,
      0.143467,
      0.213051,
      2.156912,
      NULL,
      1,
      0,
      NULL,
      1.273007,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      8.678115,
      1,
      1,
      3.590205,
      1.358508,
      NULL,
      NULL,
      NULL,
      0.452018,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.828287,
      NULL,
      NULL,
      1.344370,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.519714,
      NULL,
      3,
      1,
      3,
      0,
      8.864323,
      3,
      1,
      9,
      NULL,
      0,
      9,
      2.923114,
      3,
      3,
      1,
      1.817632,
      1.299883,
      1,
      NULL,
      2,
      NULL,
      0.326042,
      9,
      10,
      4.644892,
      2.048001,
      3,
      3,
      NULL,
      NULL,
      1,
      3.283493,
      2.678248,
      0,
      NULL,
      1,
      2,
      6,
      6,
      6,
      8,
      NULL,
      2.880990,
      2,
      0,
      NULL,
      3.577434,
      1.916642,
      3.237059,
      0.659744,
      1.049450,
      3.479788,
      NULL,
      8.124312,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.796405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      1.163724,
      NULL,
      1,
      0.528026,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.022010,
      NULL,
      3.978378,
      1,
      NULL,
      3,
      3.377810,
      NULL,
      4.029885,
      5.709811,
      NULL,
      8,
      0.143868,
      3,
      3,
      1.167382,
      NULL,
      3.462465,
      0,
      NULL,
      5.443931,
      1.707096,
      5,
      NULL,
      6.339470,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.830441,
      2.077634,
      1.985725,
      NULL,
      NULL,
      NULL,
      1.320743,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.493344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.294096,
      1,
      NULL,
      1.850451,
      1.248870,
      0,
      NULL,
      1,
      2.669474,
      NULL,
      NULL,
      3.202510,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      3.501424,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667438,
      NULL,
      10,
      NULL,
      0.355837,
      NULL,
      4,
      2,
      NULL,
      6,
      NULL,
      3.493158,
      NULL,
      399.644273,
      2,
      57,
      1,
      1.894918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.600625,
      262.132848,
      182,
      0,
      NULL,
      NULL,
      0.792552,
      70.081386,
      0,
      346,
      11,
      0.490322,
      1,
      NULL,
      1,
      0,
      1,
      0.390547,
      NULL,
      0,
      NULL,
      1.916172,
      0,
      0.323364,
      2.417700,
      0.634578,
      0.179835,
      0.245182,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.629597,
      NULL,
      1,
      NULL,
      23,
      NULL,
      NULL,
      0.198010,
      31,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.591115,
      NULL,
      0.795840,
      NULL,
      1.882224,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.845247,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.581050,
      0.204632,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854354,
      0.966139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735071,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281582,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156230,
      2.229358,
      NULL,
      1.331585,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.726244,
      NULL,
      0.922312,
      NULL,
      1,
      1.069928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      4,
      NULL,
      0.124184,
      NULL,
      0,
      2.219143,
      1,
      3,
      2.016029,
      NULL,
      1.263297,
      0.290343,
      1,
      0.185204,
      1,
      1,
      1.370811,
      1,
      1,
      1.809872,
      1.633287,
      1.110570,
      1,
      0.392980,
      1,
      1.318683,
      NULL,
      0.329663,
      0,
      0.658480,
      0,
      0.415650,
      0,
      0.105472,
      3,
      NULL,
      1,
      0,
      NULL,
      1.011882,
      1,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223845,
      1.739540,
      1,
      NULL,
      0,
      0.532136,
      0,
      6,
      7,
      0.256649,
      0,
      1.052447,
      0.291263,
      86,
      NULL,
      4.737200,
      5,
      '42310',
      NULL,
      NULL,
      0.712539,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


