set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '1342100',
      0.184724,
      1,
      5,
      3,
      '0313',
      NULL,
      0,
      NULL,
      NULL,
      ' 0-14-1988',
      57,
      NULL,
      2,
      2.968839,
      1,
      ' 6-20-2003',
      3.648271,
      NULL,
      95,
      68.635803,
      1,
      NULL,
      ' 2-26-1999',
      ' 0-14-2000',
      3.722886,
      3,
      0,
      0.733324,
      NULL,
      0,
      0,
      NULL,
      0.073483,
      NULL,
      8,
      8.450500,
      NULL,
      19.464455,
      3,
      2,
      5.969142,
      0,
      3,
      8,
      3.263062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.439934,
      0,
      1,
      0,
      4,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      5,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      4,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      5,
      2,
      4,
      0,
      NULL,
      1,
      NULL,
      ' 3-17-1975',
      69,
      NULL,
      28.665218,
      3,
      2,
      NULL,
      3,
      5,
      NULL,
      5,
      2,
      0,
      1,
      3,
      1,
      0,
      1,
      5,
      2,
      NULL,
      5.092323,
      2.524947,
      NULL,
      3,
      ' 0- 2-1988',
      136,
      ' 1-12-1992',
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803862,
      0.272975,
      1.825642,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.733531,
      1,
      1.225892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.789423,
      1,
      1.813195,
      0.709532,
      NULL,
      32,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985224,
      NULL,
      0,
      0,
      0,
      2,
      3,
      1,
      NULL,
      3,
      2,
      3,
      0.794710,
      NULL,
      3,
      0.956302,
      1,
      1.037570,
      1.209761,
      NULL,
      0,
      NULL,
      1.320068,
      0,
      0,
      0,
      0,
      0,
      NULL,
      2.114174,
      1.023055,
      NULL,
      9.322707,
      1.879751,
      NULL,
      4,
      4,
      3.996703,
      NULL,
      3,
      0.543962,
      1.899546,
      0,
      22.195248,
      3,
      0,
      NULL,
      35,
      8,
      78.320994,
      NULL,
      0.612825,
      NULL,
      '33210',
      '',
      '',
      1.468213,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0.785429,
      0,
      41,
      0.059050,
      0.945087,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.935674,
      3,
      NULL,
      0,
      2.517776,
      0.245015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.154304,
      2,
      5.372401,
      1,
      NULL,
      1,
      0,
      0,
      1.919387,
      NULL,
      NULL,
      NULL,
      0.212414,
      NULL,
      NULL,
      1.390617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252319,
      0,
      3.118596,
      0.126320,
      2,
      1,
      2,
      0.892863,
      1.573608,
      NULL,
      NULL,
      NULL,
      6.291820,
      NULL,
      3.538819,
      3.045002,
      NULL,
      2,
      NULL,
      3.886287,
      1,
      6,
      1,
      0.314822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.126004,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.634872,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.642733,
      0,
      1.991251,
      2,
      NULL,
      1,
      0.436578,
      NULL,
      NULL,
      3,
      2.677537,
      2,
      1,
      NULL,
      NULL,
      1.675745,
      NULL,
      NULL,
      3.519613,
      3.884526,
      3.766933,
      3,
      0.989596,
      NULL,
      2.106875,
      4,
      5.661299,
      1,
      NULL,
      NULL,
      1.511312,
      NULL,
      3,
      NULL,
      1,
      0.190597,
      NULL,
      0,
      2.794446,
      2.144098,
      NULL,
      3,
      41,
      NULL,
      NULL,
      3.879801,
      NULL,
      2.200977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      3.422470,
      NULL,
      1.580242,
      1,
      NULL,
      2,
      0.573778,
      NULL,
      0,
      1,
      NULL,
      3.507233,
      3.401249,
      NULL,
      0.718339,
      1,
      NULL,
      3,
      0.635158,
      NULL,
      0.118936,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881979,
      0,
      1.978192,
      0.350920,
      1.736726,
      0.953595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894824,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.578180,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394882,
      NULL,
      NULL,
      1.779601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      195.548242,
      2,
      1.432363,
      0.880090,
      NULL,
      1,
      1.795733,
      0,
      0.023126,
      NULL,
      NULL,
      1,
      0,
      0.281701,
      0.770619,
      0.641129,
      NULL,
      0,
      NULL,
      0.824630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.142379,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.227312,
      NULL,
      0.968684,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.413409,
      NULL,
      1,
      1.213575,
      0.506906,
      2.447967,
      3,
      NULL,
      1,
      1.532558,
      0,
      NULL,
      NULL,
      1.396825,
      0,
      1,
      0,
      0.909296,
      0,
      1.006968,
      0,
      1,
      1.585114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.736975,
      NULL,
      NULL,
      0,
      1.939891,
      0,
      NULL,
      NULL,
      NULL,
      0.142621,
      3,
      0,
      0.431526,
      NULL,
      0.411191,
      0.922546,
      NULL,
      NULL,
      0.757366,
      1,
      1.077857,
      1.258727,
      1,
      0.864267,
      NULL,
      1.026364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.784349,
      0.196366,
      0,
      NULL,
      NULL,
      3,
      0.446918,
      0.179935,
      1.110411,
      0,
      1,
      NULL,
      NULL,
      0.868004,
      NULL,
      0,
      0.472137,
      NULL,
      0.181261,
      0,
      NULL,
      0.750231,
      0,
      NULL,
      0,
      0,
      NULL,
      1.227264,
      NULL,
      NULL,
      NULL,
      2.417104,
      NULL,
      0.860164,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      NULL,
      1.281456,
      NULL,
      1,
      0.925182,
      NULL,
      0,
      NULL,
      0.924935,
      NULL,
      NULL,
      NULL,
      0.907423,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266796,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.437178,
      NULL,
      2,
      NULL,
      12,
      2.642340,
      NULL,
      1.134345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      52.502268,
      2,
      4.068455,
      1,
      '11111',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


