set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '0123430',
      1,
      NULL,
      4,
      3,
      '1323',
      3.276226,
      1,
      NULL,
      NULL,
      '10-16-1998',
      32.974555,
      NULL,
      2,
      1.294860,
      1.801690,
      '10- 1-1981',
      82,
      3.328607,
      NULL,
      NULL,
      2,
      ' 9-13-1986',
      NULL,
      NULL,
      NULL,
      3,
      2.097527,
      NULL,
      1.304541,
      0.968670,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      4.038886,
      NULL,
      4,
      18,
      2,
      NULL,
      0.214105,
      0,
      1,
      1,
      0.354560,
      1,
      1,
      NULL,
      0.027164,
      0,
      3,
      0,
      NULL,
      0,
      3,
      1.937221,
      4,
      NULL,
      NULL,
      1,
      2,
      2,
      5,
      1,
      1,
      3,
      NULL,
      1,
      7,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      0,
      0,
      0,
      3.956032,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      0.396034,
      0.556181,
      1.557578,
      2,
      1.490323,
      NULL,
      0,
      0,
      1,
      4.844105,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      2.520748,
      0,
      1,
      0,
      0,
      2,
      1,
      3,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.659558,
      1,
      NULL,
      1,
      0,
      1.026746,
      NULL,
      1.314772,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      5,
      0,
      0,
      5,
      2,
      0,
      2,
      0,
      2,
      1,
      1,
      NULL,
      0,
      5,
      0,
      3,
      NULL,
      1,
      NULL,
      2,
      3.744500,
      ' 6- 4-1994',
      1016.959644,
      ' 3-29-1978',
      469.392575,
      0.058182,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.940259,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.745632,
      0,
      NULL,
      1,
      NULL,
      0.866010,
      4,
      1.879050,
      NULL,
      9,
      7.434070,
      0.051233,
      NULL,
      NULL,
      3.029040,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      ' 0-23-2003',
      3,
      ' 1-23-2003',
      NULL,
      1.820744,
      NULL,
      1.451587,
      2.564546,
      2,
      1.844909,
      0,
      0,
      1.815353,
      0,
      3.236756,
      51.920483,
      3.231130,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      1,
      2,
      5,
      0,
      1,
      4,
      NULL,
      0.514245,
      0.288659,
      0.097349,
      0.701198,
      1,
      0.354839,
      NULL,
      0,
      NULL,
      2,
      1.336190,
      7,
      11.073392,
      3.768970,
      7,
      2.040320,
      4,
      3.348146,
      3.957040,
      0.872517,
      2,
      NULL,
      1,
      3,
      2,
      0,
      NULL,
      6,
      NULL,
      NULL,
      5,
      1,
      3.027157,
      '11340',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0.469211,
      '',
      '',
      '',
      1,
      NULL,
      113,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      0.187889,
      NULL,
      NULL,
      0.361941,
      NULL,
      NULL,
      2,
      2.026231,
      3,
      1,
      NULL,
      NULL,
      1.927311,
      NULL,
      NULL,
      0.407447,
      NULL,
      NULL,
      0.562213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.044912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.502781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054361,
      NULL,
      NULL,
      0.831636,
      NULL,
      NULL,
      0.626854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.701910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.263385,
      NULL,
      NULL,
      1.387606,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.106440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.581189,
      NULL,
      NULL,
      0.779914,
      NULL,
      NULL,
      1.911515,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.250522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.118470,
      0.818964,
      0.144484,
      4,
      NULL,
      2.059700,
      0.627911,
      1.713430,
      NULL,
      1.751981,
      1.105964,
      3.176388,
      2,
      1.939306,
      3.808019,
      0.266370,
      1.199286,
      0,
      7,
      0,
      NULL,
      5.408886,
      5.522926,
      NULL,
      NULL,
      NULL,
      1,
      0.670227,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.004430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.678127,
      1.185071,
      0,
      1.770068,
      1,
      3.614308,
      1.164013,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.756936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.922609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.704330,
      NULL,
      NULL,
      NULL,
      0.425435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927707,
      NULL,
      NULL,
      NULL,
      0.787903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434307,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.925402,
      NULL,
      0,
      6,
      1.313299,
      1,
      NULL,
      NULL,
      3,
      1.357835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.718777,
      NULL,
      NULL,
      1.012600,
      NULL,
      1.714260,
      16,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.163760,
      1.960934,
      1.539212,
      1,
      1,
      1,
      0,
      1.582728,
      0.945529,
      NULL,
      NULL,
      1.243824,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.065714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.969246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994563,
      1.452354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.420051,
      NULL,
      0.662534,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      8,
      3.807148,
      5.268633,
      NULL,
      NULL,
      18,
      1,
      2.877591,
      0.699528,
      1.998869,
      1,
      NULL,
      0,
      3,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      0.427069,
      2.853290,
      NULL,
      0.494764,
      1.006851,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.133488,
      0,
      NULL,
      NULL,
      0.203063,
      NULL,
      1.527021,
      1.327996,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724249,
      NULL,
      NULL,
      NULL,
      0.827511,
      NULL,
      0,
      5,
      5,
      0,
      NULL,
      NULL,
      12.334131,
      11.938600,
      3,
      0.576598,
      1,
      '02211',
      '',
      '',
      1,
      '34314',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


