set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0212414',
      0.433833,
      1.554080,
      2,
      2,
      '2040',
      1.880792,
      0.840260,
      NULL,
      NULL,
      '11-20-1998',
      22.172946,
      NULL,
      NULL,
      0.462760,
      0.603617,
      ' 0-19-2000',
      8,
      0,
      NULL,
      30.658685,
      1,
      ' 3- 8-1984',
      ' 8-28-1995',
      ' 6-29-2003',
      2,
      1,
      3.708469,
      1,
      0.017577,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      4,
      NULL,
      3,
      2,
      6,
      1.154150,
      0,
      NULL,
      1.333151,
      NULL,
      1,
      0.208414,
      NULL,
      0.935951,
      0.935431,
      1,
      3,
      4,
      5,
      0,
      4,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      0,
      0,
      0,
      NULL,
      2.465463,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      1,
      2.335586,
      2,
      NULL,
      2.909975,
      1,
      2.279199,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      1.781010,
      5,
      NULL,
      NULL,
      5.659922,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.839943,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      7.057124,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      1,
      0,
      1,
      4,
      3,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      4,
      4,
      NULL,
      3,
      2,
      0,
      2,
      NULL,
      2.208983,
      ' 8-22-1987',
      506.121750,
      ' 3-21-1978',
      304.645170,
      0.654591,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.639330,
      NULL,
      2,
      0,
      0.700401,
      1,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      2.883862,
      2.354146,
      0.160855,
      7,
      0,
      4.829605,
      4.632134,
      0.315178,
      NULL,
      0.654100,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0.565657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0,
      1.866230,
      1.839076,
      52,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.041067,
      3.146906,
      NULL,
      2,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      3.327937,
      NULL,
      NULL,
      4.005869,
      NULL,
      1.170916,
      9,
      1.027558,
      1.355808,
      0,
      NULL,
      0.572909,
      NULL,
      1,
      NULL,
      0,
      0,
      3.115604,
      1,
      6,
      5,
      NULL,
      1,
      3,
      1,
      5,
      0.159247,
      0.171151,
      NULL,
      2,
      2,
      19,
      0,
      3,
      NULL,
      35,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.490863,
      11,
      62.542368,
      39,
      0.835980,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.089281,
      0,
      NULL,
      NULL,
      0.437649,
      NULL,
      0.828929,
      1.857721,
      NULL,
      NULL,
      1,
      1.535224,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.538057,
      1.041468,
      3,
      0.616197,
      NULL,
      2.400260,
      2.365682,
      2.061791,
      1,
      3,
      1.483464,
      0.049276,
      7,
      0.253649,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.217107,
      2.832353,
      3,
      3,
      0.441179,
      NULL,
      2,
      NULL,
      2.720434,
      2,
      NULL,
      0.319800,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.321457,
      0.520438,
      3,
      1,
      0.417482,
      NULL,
      2,
      3.708594,
      NULL,
      1.891336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.237678,
      4.510640,
      3.952051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970193,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.474865,
      0,
      0,
      1.412632,
      NULL,
      NULL,
      0.768147,
      NULL,
      NULL,
      NULL,
      1.547193,
      1.590579,
      0,
      0,
      NULL,
      2,
      0.538116,
      NULL,
      NULL,
      0,
      0.700053,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.757745,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.191974,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.817653,
      0.952843,
      NULL,
      0,
      0.952178,
      1,
      2,
      2,
      2.756422,
      1,
      NULL,
      NULL,
      1,
      0.841948,
      1.071333,
      2,
      3,
      2.982617,
      3.106251,
      0,
      NULL,
      NULL,
      5,
      NULL,
      2,
      0.265676,
      0.116051,
      3.033559,
      NULL,
      1,
      1.316946,
      NULL,
      NULL,
      2.512619,
      1.162844,
      2,
      NULL,
      1.329623,
      5.984158,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.347696,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.466926,
      NULL,
      NULL,
      1.190799,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.527264,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.005557,
      NULL,
      NULL,
      0.047836,
      0,
      1.348731,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1969.353628,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.679007,
      NULL,
      NULL,
      NULL,
      1.845520,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174380,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      98,
      NULL,
      0.449180,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671714,
      NULL,
      0,
      NULL,
      1.562925,
      0,
      NULL,
      0.162382,
      1.640070,
      0.425485,
      0.487012,
      0,
      0,
      1.131575,
      NULL,
      0.740767,
      NULL,
      NULL,
      0.631586,
      0,
      0,
      NULL,
      0.577416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      3,
      1,
      NULL,
      0.738559,
      0.488498,
      1.986332,
      0.351369,
      NULL,
      1,
      NULL,
      0.962528,
      0.279830,
      NULL,
      3.135234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493744,
      1.709087,
      NULL,
      0,
      0,
      NULL,
      1,
      0.326156,
      NULL,
      1,
      0,
      NULL,
      1.121139,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      0.519664,
      NULL,
      1.795142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      6,
      2,
      3.499417,
      2,
      NULL,
      65.795045,
      39,
      3,
      NULL,
      3.964752,
      '41412',
      '',
      '',
      1.760677,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


