set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      0.339482,
      NULL,
      NULL,
      ' 6- 7-1998',
      7.064963,
      NULL,
      2,
      0,
      NULL,
      ' 7-29-1981',
      5,
      3,
      99,
      NULL,
      3,
      NULL,
      NULL,
      ' 3-23-1992',
      0.620092,
      0,
      1.515554,
      1.630537,
      1,
      NULL,
      1,
      0.665835,
      1,
      21.059411,
      5,
      5.593489,
      3,
      NULL,
      15.036956,
      5,
      16,
      2,
      3,
      NULL,
      0,
      2,
      0,
      0,
      0,
      0.340784,
      0.198047,
      11.208071,
      1.892592,
      1.189453,
      0,
      2,
      5,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.712965,
      1.473830,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.739441,
      0.341923,
      3.977163,
      0,
      1.466672,
      NULL,
      0,
      1.712296,
      0.127225,
      NULL,
      1,
      0,
      8,
      2,
      NULL,
      3.785234,
      0.090999,
      NULL,
      NULL,
      1.867392,
      NULL,
      NULL,
      NULL,
      5,
      2,
      4,
      3,
      4,
      3,
      1,
      0,
      1,
      0,
      0,
      0,
      4.819798,
      2,
      2,
      2,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      3,
      2,
      0,
      2,
      3,
      NULL,
      5,
      0,
      NULL,
      1,
      NULL,
      5,
      4,
      2,
      3,
      ' 0-18-1979',
      NULL,
      ' 0-21-1977',
      388.201446,
      3.421726,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.696228,
      1.521368,
      4.073945,
      2.935715,
      9.892424,
      3.088305,
      6.642146,
      6.048942,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.651966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.860831,
      0.800911,
      1,
      1,
      1,
      1,
      0.397933,
      0.803542,
      12,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.261736,
      2,
      NULL,
      3,
      NULL,
      1,
      0,
      2,
      2,
      3,
      2,
      1.760032,
      3,
      2.955945,
      3,
      NULL,
      0.025507,
      9.843784,
      0.357376,
      1,
      1.528313,
      1,
      0.213818,
      0.043639,
      0.922721,
      1.092957,
      0,
      0,
      5.933467,
      3.557364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328706,
      NULL,
      NULL,
      10,
      6,
      3,
      1,
      2,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      42,
      61,
      38.824221,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.078155,
      0.996753,
      NULL,
      NULL,
      NULL,
      9.539769,
      19,
      NULL,
      16.816990,
      2.755813,
      3,
      17,
      19.438264,
      NULL,
      10,
      11,
      2,
      7.849371,
      8,
      13.088805,
      NULL,
      NULL,
      6.395087,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      4.584527,
      NULL,
      NULL,
      9.627699,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.365351,
      NULL,
      NULL,
      NULL,
      0.770688,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.291950,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.259964,
      NULL,
      1,
      1.725700,
      0,
      1,
      0.334861,
      1.493313,
      2,
      0.010352,
      0.752228,
      NULL,
      1.770695,
      1,
      1.014607,
      1.913482,
      NULL,
      NULL,
      0.253784,
      NULL,
      NULL,
      0.925140,
      NULL,
      NULL,
      3,
      4.273858,
      0.912773,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.866826,
      NULL,
      NULL,
      2,
      3,
      13.370939,
      1,
      0.238821,
      9,
      19.529588,
      NULL,
      NULL,
      8,
      0,
      1,
      2,
      17,
      4,
      0.743977,
      NULL,
      10.698517,
      3,
      1,
      1.270010,
      5.297475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1.351349,
      NULL,
      NULL,
      1.803548,
      NULL,
      NULL,
      NULL,
      12.524302,
      4,
      1,
      12,
      NULL,
      6,
      1.806804,
      0.597929,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      9,
      0,
      3.180475,
      9.328420,
      1,
      3.275158,
      0.179995,
      0,
      0.351697,
      0,
      NULL,
      19,
      NULL,
      NULL,
      0,
      2.691033,
      16.803650,
      NULL,
      8,
      NULL,
      6,
      0,
      NULL,
      1.307091,
      NULL,
      NULL,
      3.902811,
      2,
      4,
      NULL,
      1.507396,
      1,
      0,
      1.536453,
      1,
      NULL,
      NULL,
      2.160000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.064263,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      8.720010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.212660,
      NULL,
      NULL,
      0.350851,
      NULL,
      NULL,
      1.743276,
      1.259597,
      NULL,
      0,
      0.341813,
      0,
      0.422025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.796127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.607561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.227177,
      NULL,
      NULL,
      NULL,
      8.963093,
      NULL,
      NULL,
      NULL,
      3.960243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.140738,
      NULL,
      NULL,
      NULL,
      2.054769,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      14,
      NULL,
      NULL,
      1.232440,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.685133,
      NULL,
      0.992673,
      0.387679,
      0.704265,
      0,
      NULL,
      1.228302,
      1,
      NULL,
      1.469248,
      1,
      1,
      0,
      0.754983,
      0.941929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      4.008703,
      2,
      1.888017,
      2.741892,
      3,
      4,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      17.507809,
      NULL,
      0,
      15.073809,
      NULL,
      NULL,
      1.966184,
      NULL,
      0.222015,
      19,
      NULL,
      1,
      11,
      NULL,
      0.357464,
      NULL,
      NULL,
      0,
      18.222910,
      NULL,
      1.259226,
      0,
      NULL,
      1,
      1.963820,
      NULL,
      0,
      1,
      NULL,
      0,
      0.146904,
      1.757688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      NULL,
      NULL,
      NULL,
      81.665867,
      NULL,
      NULL,
      1.502929,
      3.307013,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


