set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0444221',
      1,
      1.136615,
      4,
      2,
      '2141',
      2.086345,
      1,
      NULL,
      NULL,
      ' 7-26-1978',
      33,
      NULL,
      0,
      2,
      1,
      ' 1-19-1980',
      49.737147,
      NULL,
      183.481214,
      30.505322,
      NULL,
      ' 8-24-2002',
      NULL,
      ' 7- 4-1992',
      0,
      3,
      NULL,
      0,
      1.175740,
      0,
      NULL,
      1,
      1.266725,
      15,
      0,
      0.698311,
      7.125691,
      1.223064,
      8,
      3,
      2.283402,
      3,
      NULL,
      3,
      1.786262,
      1,
      1,
      1,
      0.586042,
      NULL,
      NULL,
      4.142069,
      1,
      NULL,
      0,
      3,
      4,
      5,
      0,
      0,
      1,
      NULL,
      1,
      1,
      4,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      4.417884,
      NULL,
      2,
      NULL,
      0,
      1.480729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      1,
      2,
      2.559454,
      1,
      3.208356,
      1.754489,
      1,
      1,
      2.827234,
      NULL,
      3.416480,
      3,
      1.389942,
      2.408971,
      3.552846,
      NULL,
      NULL,
      NULL,
      0,
      0,
      8.179809,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      5,
      2,
      2,
      0,
      3,
      0,
      1,
      NULL,
      0,
      5,
      1,
      1,
      3,
      NULL,
      NULL,
      2,
      NULL,
      5,
      NULL,
      1,
      0,
      5,
      0,
      1,
      0,
      NULL,
      2,
      5,
      NULL,
      0,
      5,
      NULL,
      5,
      1,
      3,
      4,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0,
      2,
      3,
      3,
      NULL,
      NULL,
      ' 6-16-1993',
      504.290765,
      ' 1-29-1997',
      347.299253,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      5,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1269.729163,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2,
      2.909393,
      0,
      6,
      1.088631,
      0,
      7.278086,
      2.980572,
      7.825784,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535725,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0.879103,
      0,
      0.628640,
      0,
      0,
      24.647525,
      2.164390,
      0.423437,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      1,
      0,
      0,
      0,
      2,
      1,
      3,
      3,
      NULL,
      1.064751,
      0.931799,
      2.612340,
      0.198867,
      0.108539,
      1.529054,
      7,
      0,
      0,
      1.921632,
      1.606703,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      6,
      1.664318,
      NULL,
      9,
      4.979707,
      NULL,
      6.494229,
      1.772892,
      4.045862,
      3,
      6,
      1.377970,
      NULL,
      3.027531,
      45,
      NULL,
      2.256056,
      NULL,
      24,
      33,
      69.866768,
      5,
      NULL,
      NULL,
      '30140',
      '',
      NULL,
      0.826740,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.189390,
      34.123082,
      37.318467,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.836258,
      2.810173,
      2.076332,
      1.112761,
      NULL,
      NULL,
      3.876374,
      1.203335,
      1,
      NULL,
      0.153761,
      1,
      1.038507,
      NULL,
      NULL,
      0.797534,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2.698879,
      1.235739,
      3,
      2.424154,
      1.800769,
      0.757888,
      1,
      0.532374,
      6.483589,
      6,
      3,
      0,
      1.447205,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.354310,
      NULL,
      NULL,
      3,
      0.381734,
      0.672140,
      1,
      1,
      3.906186,
      1,
      1,
      2,
      NULL,
      NULL,
      0.566708,
      1,
      3.032850,
      NULL,
      1.178487,
      1.102724,
      3.227192,
      NULL,
      1,
      2.167975,
      3.323872,
      0,
      0.178710,
      NULL,
      NULL,
      0.251352,
      NULL,
      NULL,
      9.795349,
      3,
      1,
      0,
      1.700648,
      NULL,
      NULL,
      NULL,
      0.713721,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.533925,
      NULL,
      1.204584,
      1.464277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      12,
      2,
      0.137615,
      18,
      NULL,
      1.851751,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.940916,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732556,
      NULL,
      NULL,
      1.289464,
      1.922892,
      1.403587,
      0,
      0.897866,
      1,
      5.131565,
      1.516108,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.870591,
      NULL,
      NULL,
      2,
      NULL,
      1.417804,
      1.496177,
      NULL,
      1,
      NULL,
      0,
      1,
      2.186215,
      NULL,
      1,
      1.664923,
      1.327454,
      NULL,
      NULL,
      3,
      1.042939,
      0,
      9.553781,
      7,
      7.062936,
      0.843913,
      2.492210,
      0.141104,
      1,
      0,
      4,
      0,
      1,
      1,
      0,
      0.454136,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.141408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169031,
      NULL,
      NULL,
      1.021176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1.274816,
      1,
      0,
      1.871163,
      0.414773,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1634.016877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954259,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.268870,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.392439,
      NULL,
      NULL,
      NULL,
      3.454381,
      NULL,
      NULL,
      NULL,
      3.178005,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.355268,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      33,
      2.199595,
      3.917284,
      0.962847,
      0.107583,
      NULL,
      NULL,
      1.305080,
      NULL,
      NULL,
      1.724228,
      NULL,
      NULL,
      1.514207,
      NULL,
      NULL,
      0.697088,
      NULL,
      NULL,
      7546.921048,
      0,
      1,
      0.479820,
      1.676885,
      1.080340,
      1,
      0,
      1,
      0,
      1,
      1.887219,
      1.420790,
      NULL,
      0,
      0,
      NULL,
      1.958877,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.279998,
      0,
      0,
      1,
      3,
      NULL,
      0.729140,
      3.080891,
      0,
      1,
      1.406506,
      NULL,
      0.879972,
      1,
      NULL,
      3.594091,
      NULL,
      NULL,
      1,
      0.055246,
      NULL,
      0.725555,
      3.296036,
      NULL,
      1,
      NULL,
      NULL,
      2.148054,
      2.256271,
      NULL,
      0,
      0,
      NULL,
      1.610750,
      0,
      NULL,
      0,
      2.725379,
      NULL,
      0,
      1.234533,
      NULL,
      3.636076,
      1.071401,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      0.690110,
      NULL,
      NULL,
      21,
      10,
      0,
      1.581427,
      3.404254,
      '10403',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


