set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703042';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      25,
      NULL,
      '3041001',
      3.829948,
      1.982953,
      2,
      3,
      '4430',
      NULL,
      1.010692,
      NULL,
      NULL,
      ' 8-27-1991',
      16.050132,
      179,
      NULL,
      1,
      NULL,
      ' 5-28-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 4- 2-1984',
      ' 8-29-1978',
      ' 3- 3-1974',
      0.101499,
      3.452417,
      2,
      3,
      0,
      3,
      7,
      0,
      0.680664,
      NULL,
      0,
      18,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      3,
      1,
      0,
      1.230429,
      0.753452,
      1.712553,
      0,
      3.006392,
      1,
      0.538247,
      0,
      NULL,
      NULL,
      3.891478,
      3,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      9.120479,
      0,
      NULL,
      0,
      1,
      0.292286,
      NULL,
      NULL,
      1.746609,
      NULL,
      NULL,
      4,
      4,
      9.297925,
      NULL,
      0,
      0,
      2.187726,
      3.620444,
      NULL,
      NULL,
      2,
      2.721313,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      9.410575,
      NULL,
      2,
      3,
      0.642669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0.575723,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      0,
      2,
      5,
      1,
      3,
      3,
      NULL,
      0,
      1,
      2,
      4,
      0,
      5,
      NULL,
      NULL,
      2,
      2,
      5,
      0,
      4,
      3,
      1.280762,
      3,
      ' 9- 3-1985',
      111.776424,
      ' 9-23-2001',
      82,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1.166809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3,
      1,
      NULL,
      0,
      0.990939,
      NULL,
      0.858568,
      0.153621,
      NULL,
      0.853879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.124972,
      1.042936,
      2.390543,
      35.234781,
      2.510326,
      0.090653,
      NULL,
      NULL,
      NULL,
      0,
      1.562075,
      1.516103,
      NULL,
      3,
      2,
      2,
      NULL,
      3,
      0,
      NULL,
      0,
      3,
      1.925802,
      1,
      NULL,
      0.974938,
      NULL,
      0,
      NULL,
      0,
      0.406235,
      0.763972,
      0.371175,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      3,
      0.055291,
      3,
      10,
      2.224842,
      3.170822,
      NULL,
      1.573635,
      NULL,
      0,
      NULL,
      NULL,
      3.066678,
      2,
      NULL,
      2,
      NULL,
      42,
      NULL,
      36,
      NULL,
      0,
      NULL,
      2,
      '32210',
      '22334',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2.027030,
      4.755392,
      18.068672,
      4,
      1.515446,
      5,
      2,
      1,
      3,
      3.546028,
      NULL,
      1.818918,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503333,
      0,
      0,
      NULL,
      0,
      3.749743,
      1.800430,
      3,
      0.665906,
      1,
      1.018493,
      3.966305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.333562,
      NULL,
      NULL,
      0.031431,
      NULL,
      NULL,
      8,
      1.438454,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.822452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385474,
      0,
      NULL,
      NULL,
      NULL,
      2.105858,
      3,
      0,
      3.643424,
      1.279308,
      0,
      1,
      0,
      NULL,
      3.216538,
      2,
      2.043538,
      2,
      NULL,
      2,
      3,
      1,
      0.519367,
      0.974150,
      0.829617,
      0.949239,
      0,
      NULL,
      NULL,
      0.994433,
      3.514800,
      2.373646,
      0.257559,
      1,
      1.765009,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.364997,
      NULL,
      NULL,
      NULL,
      3.424892,
      0.905676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.762070,
      1.727089,
      0,
      NULL,
      NULL,
      0.759667,
      NULL,
      NULL,
      1.845375,
      NULL,
      NULL,
      1.279208,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.885095,
      NULL,
      NULL,
      0.269868,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.949061,
      0.012181,
      3.406079,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.373125,
      0,
      6.978919,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.470106,
      3.298288,
      1,
      NULL,
      0.597110,
      NULL,
      1.613098,
      2,
      3,
      0.874343,
      2.782403,
      NULL,
      1.525643,
      0,
      NULL,
      NULL,
      1.086738,
      0,
      2,
      2,
      5,
      8.939971,
      2,
      4,
      2,
      2.527402,
      3,
      2,
      3,
      1.407398,
      NULL,
      1.471803,
      1.911343,
      1,
      3.754055,
      NULL,
      NULL,
      0.254443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.063622,
      NULL,
      NULL,
      0.002470,
      NULL,
      NULL,
      1.543685,
      NULL,
      NULL,
      0.901581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.740639,
      1,
      1,
      0.496888,
      0.780234,
      NULL,
      0.350663,
      NULL,
      NULL,
      0.997789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.332150,
      NULL,
      NULL,
      NULL,
      0.250383,
      NULL,
      NULL,
      NULL,
      1.309522,
      NULL,
      NULL,
      NULL,
      2.895451,
      NULL,
      NULL,
      NULL,
      1.124264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.619441,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.181264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653500,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.512632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.911655,
      NULL,
      5.202799,
      NULL,
      NULL,
      1,
      NULL,
      0.586378,
      1,
      0.761075,
      3.023495,
      NULL,
      2.744826,
      0,
      1.981087,
      1.235371,
      0.644095,
      1,
      NULL,
      1,
      0.771927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.140474,
      NULL,
      NULL,
      NULL,
      0.057229,
      NULL,
      0,
      NULL,
      1.127287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.331134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552923,
      0.309305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465511,
      1.709557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352077,
      3,
      NULL,
      1,
      NULL,
      1.005331,
      NULL,
      NULL,
      NULL,
      2.406931,
      NULL,
      2.761525,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.331733,
      NULL,
      1.697749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.739975,
      1,
      NULL,
      2,
      NULL,
      0.741039,
      NULL,
      783,
      NULL,
      NULL,
      NULL,
      0.594159,
      NULL,
      0.246430,
      NULL,
      0.788000,
      2.847835,
      11,
      0.842128,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3.083923,
      0,
      NULL,
      3.302887,
      2,
      3,
      NULL,
      2.459291,
      1,
      1.071196,
      0.548615,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.674337,
      1,
      NULL,
      NULL,
      0.086734,
      NULL,
      NULL,
      0,
      NULL,
      2.708200,
      2,
      NULL,
      1.284868,
      1.073906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575656,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      36,
      13,
      1,
      0,
      1,
      '40131',
      '43000',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


