set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7633982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3424120',
      NULL,
      NULL,
      NULL,
      3,
      '0234',
      3.420904,
      1.254363,
      NULL,
      NULL,
      ' 0- 6-1977',
      40.321977,
      NULL,
      5,
      2.915432,
      1.660318,
      NULL,
      53.687744,
      2.752826,
      288,
      143,
      NULL,
      ' 4- 4-1978',
      ' 3-21-1981',
      NULL,
      0,
      3,
      2,
      0,
      0,
      1.981986,
      2,
      1.413121,
      0,
      351,
      8,
      12,
      9.853913,
      NULL,
      NULL,
      0,
      24.374322,
      3,
      1,
      8.163357,
      NULL,
      1,
      0,
      0.426049,
      0,
      1.629338,
      0,
      1.481679,
      1.715662,
      1.746152,
      NULL,
      9,
      4,
      2,
      2,
      NULL,
      3,
      0,
      2,
      3,
      3,
      0,
      2,
      3,
      3,
      0,
      1,
      2.436157,
      1,
      NULL,
      NULL,
      1,
      1.192811,
      NULL,
      NULL,
      0.401723,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      1.146813,
      1,
      0.848300,
      1,
      0,
      0.993409,
      1,
      0,
      0.899161,
      0.852103,
      0.933390,
      0,
      0.689971,
      1,
      1.463174,
      0,
      1,
      1,
      4,
      0,
      2,
      0.425127,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      4,
      3,
      5,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.825282,
      3,
      NULL,
      2,
      1,
      0,
      2,
      5,
      2,
      4,
      NULL,
      5,
      0,
      4,
      0,
      2,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      3,
      NULL,
      590,
      ' 1- 8-1990',
      1836.187524,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.862816,
      1,
      1,
      NULL,
      2,
      0.301985,
      3,
      0.363809,
      2,
      2,
      3,
      0,
      1,
      4,
      NULL,
      0,
      1.975534,
      NULL,
      NULL,
      NULL,
      0.753710,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.951291,
      0.748994,
      0.908622,
      1.561782,
      NULL,
      NULL,
      1.272093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      17.927500,
      NULL,
      110,
      36,
      75.930856,
      126.019276,
      167,
      74,
      0,
      0,
      0,
      NULL,
      1.715754,
      1,
      1,
      1.910052,
      NULL,
      1.598614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      2,
      3,
      0.307745,
      2.544023,
      '44310',
      '',
      '',
      0.899181,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2,
      22,
      NULL,
      NULL,
      2,
      13.642568,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      1.712111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731901,
      1,
      2.433079,
      NULL,
      3,
      0.125586,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.454301,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.071360,
      1.580118,
      1.233949,
      2.578198,
      0.860869,
      0,
      1.927438,
      NULL,
      NULL,
      6,
      5,
      0.336369,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648630,
      1.738288,
      NULL,
      0,
      2.838188,
      0.150226,
      3.016083,
      1.034596,
      0.661620,
      2,
      0.840410,
      NULL,
      3,
      0.410393,
      NULL,
      NULL,
      1.125719,
      0.516130,
      0,
      1,
      2,
      0.945027,
      2.992845,
      NULL,
      0,
      0.578958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.777053,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3.858129,
      NULL,
      NULL,
      NULL,
      2,
      0.902095,
      3,
      3.399694,
      NULL,
      0,
      1.185085,
      NULL,
      NULL,
      6.359489,
      2.626367,
      3,
      0.632845,
      1.996573,
      1,
      0.107525,
      NULL,
      NULL,
      5,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.047631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.310489,
      0.240700,
      0.716855,
      3.596304,
      1.411389,
      2.544517,
      2.620359,
      1.846793,
      NULL,
      6,
      0.671263,
      NULL,
      2,
      NULL,
      NULL,
      2.107829,
      1,
      0,
      1.602402,
      1,
      2.739803,
      3.612601,
      0,
      2,
      NULL,
      0.179317,
      7.069166,
      NULL,
      0,
      2.143202,
      1.000443,
      0,
      1.042725,
      2.335487,
      0,
      3,
      NULL,
      0.681904,
      2.318174,
      7,
      1,
      NULL,
      0.904144,
      1.793986,
      3,
      0,
      3,
      1,
      1,
      1,
      1.365882,
      1.270986,
      1.331012,
      0.109676,
      NULL,
      NULL,
      0.763127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.942267,
      NULL,
      NULL,
      0.435844,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.788540,
      1,
      0.142904,
      NULL,
      NULL,
      2.310806,
      1,
      NULL,
      3.151322,
      0.583888,
      NULL,
      NULL,
      5.283687,
      264.660019,
      NULL,
      NULL,
      NULL,
      1.523907,
      NULL,
      NULL,
      NULL,
      0.745363,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865685,
      1.518555,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.607806,
      0.214276,
      NULL,
      NULL,
      0.017877,
      2.807742,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.952263,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      1.978493,
      NULL,
      NULL,
      3.325612,
      2,
      NULL,
      NULL,
      0.630377,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      6,
      3.966863,
      82,
      244,
      NULL,
      NULL,
      11,
      0.470958,
      NULL,
      NULL,
      3,
      25,
      3,
      NULL,
      22,
      NULL,
      0.924278,
      NULL,
      NULL,
      1.402771,
      NULL,
      0.406203,
      NULL,
      58,
      1.375371,
      0.616594,
      0,
      1,
      1,
      1.383226,
      1.924967,
      1,
      0,
      0,
      0.413350,
      1,
      NULL,
      0.262906,
      0,
      NULL,
      0.769607,
      1.966136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.183995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445147,
      0.738148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.872196,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.332073,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      2,
      0.902315,
      NULL,
      0,
      2.766214,
      1.360700,
      1.867073,
      0,
      1,
      1,
      NULL,
      1.698598,
      NULL,
      NULL,
      0.227176,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.472716,
      1,
      NULL,
      1.809546,
      1,
      NULL,
      1.161087,
      1.501191,
      NULL,
      1.400153,
      1.695820,
      NULL,
      1,
      1.217572,
      NULL,
      1,
      1.812018,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      0.082866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      2,
      32.288862,
      36.332468,
      4,
      NULL,
      0,
      '40243',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


