set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2,
      0.543921,
      1.972759,
      5.964362,
      2,
      1,
      NULL,
      NULL,
      1,
      44.330697,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '2130',
      NULL,
      1.273682,
      NULL,
      NULL,
      ' 0- 9-2003',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 0-27-1996',
      ' 6-28-1974',
      NULL,
      3,
      0,
      NULL,
      1.134006,
      NULL,
      3,
      1.568428,
      NULL,
      4.121949,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.520238,
      0.909391,
      0,
      0,
      1.364420,
      1,
      0.772208,
      1.967647,
      2,
      1,
      1,
      2.134604,
      2,
      0,
      0,
      5,
      0,
      0,
      5,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.327566,
      0.538148,
      1.652180,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      0,
      2.042232,
      1,
      NULL,
      1.477408,
      NULL,
      NULL,
      0,
      1,
      3,
      5,
      3,
      0,
      2.184546,
      1.809383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0,
      0,
      5,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1.086184,
      NULL,
      0.827921,
      1,
      2,
      4,
      NULL,
      0,
      4,
      0,
      4,
      4,
      2,
      NULL,
      1,
      5,
      NULL,
      NULL,
      2,
      4,
      NULL,
      5,
      3,
      1,
      0,
      0,
      0,
      1,
      0.745739,
      1,
      ' 4- 4-1993',
      31,
      NULL,
      49,
      0.048829,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509025,
      0,
      0,
      NULL,
      1,
      1,
      5,
      0.383092,
      0.972693,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399717,
      1,
      1.002856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.585714,
      0.792862,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910032,
      3,
      1,
      1,
      2,
      NULL,
      0,
      3,
      3,
      2,
      2,
      NULL,
      2,
      1,
      0.284751,
      1.795384,
      1.358392,
      1.727036,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.838462,
      1,
      1.607965,
      0.588177,
      0,
      1,
      1.644223,
      0,
      11.507572,
      7,
      1,
      11,
      3.726724,
      NULL,
      3,
      3.714130,
      5.227319,
      2,
      3,
      1,
      24.281912,
      NULL,
      3.605086,
      42,
      NULL,
      61,
      48,
      0,
      3.179658,
      1,
      '00332',
      '43300',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      12,
      94,
      NULL,
      3,
      24.056212,
      2,
      1.386651,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.058252,
      NULL,
      NULL,
      1.380954,
      1.337495,
      0.292643,
      1,
      NULL,
      NULL,
      1.373607,
      NULL,
      NULL,
      3,
      0.529883,
      NULL,
      NULL,
      NULL,
      NULL,
      2.570331,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601003,
      NULL,
      NULL,
      1.602581,
      NULL,
      NULL,
      5.435410,
      4.549779,
      0.518115,
      0,
      1.023004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.988351,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      NULL,
      3.813535,
      1,
      1,
      1,
      NULL,
      1.888536,
      1.010609,
      1,
      0.645247,
      2,
      0.960106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473671,
      NULL,
      0.523494,
      0.313812,
      2.074663,
      0,
      0.223341,
      NULL,
      NULL,
      NULL,
      1.736348,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.863885,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1.538086,
      NULL,
      1,
      1,
      0.004801,
      NULL,
      NULL,
      4,
      0.215439,
      3.910479,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1.845103,
      NULL,
      0.502143,
      0,
      NULL,
      0.468760,
      0,
      1.723037,
      NULL,
      NULL,
      2.937023,
      0.318195,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      5.375551,
      NULL,
      NULL,
      1.809274,
      1.927534,
      0.430960,
      1.441584,
      0,
      0.374404,
      3,
      0,
      1.777637,
      3.377236,
      1,
      0.761501,
      1.684172,
      1.328343,
      1.294716,
      1,
      NULL,
      1,
      0,
      2,
      4,
      0.800408,
      1.390398,
      0.432073,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.206878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860377,
      NULL,
      NULL,
      0.781428,
      NULL,
      NULL,
      1.532215,
      NULL,
      1,
      1,
      0.543353,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.173256,
      NULL,
      NULL,
      NULL,
      0.527455,
      NULL,
      NULL,
      NULL,
      3.910912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.598114,
      NULL,
      NULL,
      NULL,
      2.220397,
      NULL,
      NULL,
      NULL,
      1.960531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.091983,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.582756,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.458252,
      0.486446,
      0,
      1.329487,
      0,
      1.029442,
      0.604854,
      1.189218,
      1.429321,
      3.483430,
      0,
      NULL,
      0,
      0,
      0.871238,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.562676,
      NULL,
      0.698905,
      NULL,
      NULL,
      NULL,
      NULL,
      26.598132,
      43.996131,
      1.602558,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.700411,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.997206,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.905713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381121,
      0.565378,
      NULL,
      0.331304,
      NULL,
      0.085141,
      NULL,
      NULL,
      NULL,
      0.660145,
      NULL,
      NULL,
      NULL,
      0.806822,
      NULL,
      0,
      1.235548,
      1.633220,
      NULL,
      3.789298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430857,
      NULL,
      1.182445,
      NULL,
      1,
      NULL,
      1.450787,
      0,
      0.041826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.986150,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.361955,
      2,
      34,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      5.336817,
      0,
      3.487691,
      2,
      0,
      4,
      1.977565,
      0,
      NULL,
      0.973706,
      NULL,
      NULL,
      0.967651,
      0,
      NULL,
      1.985871,
      1.888538,
      NULL,
      0.354918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.478252,
      1.279236,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.380960,
      NULL,
      1.063652,
      1.471875,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.965809,
      0.368917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      57.574017,
      116.723152,
      2,
      0,
      2,
      '30444',
      '03100',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


