set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.873510,
      NULL,
      1,
      2.634196,
      0,
      NULL,
      3,
      1.699466,
      '214',
      '41043322',
      46,
      12.974690,
      '2022443',
      4.428615,
      0.152102,
      3,
      0,
      '2403',
      2,
      1,
      NULL,
      NULL,
      ' 7-18-1982',
      263.714553,
      NULL,
      NULL,
      1,
      1.599682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 2-22-1983',
      2,
      0,
      2.285682,
      1.738332,
      1.609014,
      1.517904,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.298348,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.638499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      0,
      0,
      NULL,
      2,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.016113,
      0.970167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0.322767,
      0,
      0,
      NULL,
      NULL,
      0.440888,
      NULL,
      0.796015,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      3,
      1,
      5,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0.211911,
      0,
      0.427118,
      1.512873,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.927959,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713753,
      1,
      NULL,
      1,
      1.005185,
      0.666637,
      1,
      NULL,
      NULL,
      0,
      0.980559,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.146581,
      0,
      NULL,
      1,
      3,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      1,
      2,
      1.090481,
      NULL,
      NULL,
      0.653404,
      3.367945,
      0.948115,
      1,
      1,
      1.453746,
      0,
      0,
      1.110990,
      0,
      0,
      0.693063,
      NULL,
      0,
      3,
      NULL,
      5.461950,
      1,
      1.634104,
      NULL,
      0.447076,
      1.266802,
      7,
      3,
      3.880656,
      0.889986,
      54,
      2,
      1.344019,
      49,
      NULL,
      NULL,
      NULL,
      2,
      2.489822,
      2.626684,
      '10221',
      '21130',
      '',
      0,
      '',
      '',
      NULL,
      0.255332,
      '',
      '',
      '',
      2,
      0,
      NULL,
      NULL,
      NULL,
      29,
      0,
      3,
      3,
      NULL,
      0,
      1.765634,
      1.873726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      1.674381,
      NULL,
      NULL,
      NULL,
      3.620520,
      1.155334,
      1,
      NULL,
      NULL,
      3.419015,
      0.440874,
      1.438010,
      0.752902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      2.069342,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.043243,
      NULL,
      NULL,
      NULL,
      0.541750,
      1.741546,
      1,
      NULL,
      NULL,
      NULL,
      0.921273,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      0.245658,
      1.514061,
      0.076376,
      NULL,
      NULL,
      0.367593,
      0,
      0.568984,
      3.492257,
      3,
      3,
      0.035370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.028557,
      NULL,
      2.313365,
      0.876896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.222938,
      NULL,
      1,
      3,
      1.621477,
      0.927819,
      0.848221,
      NULL,
      NULL,
      1,
      5,
      0,
      1.634554,
      0.024970,
      NULL,
      1.333286,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.915298,
      1,
      0.760899,
      NULL,
      0.404066,
      0,
      7.857827,
      1.474031,
      0,
      3,
      1.160731,
      0,
      1.750237,
      NULL,
      NULL,
      1,
      NULL,
      1.729480,
      3,
      1.475687,
      0.965219,
      NULL,
      0,
      0,
      NULL,
      0.837411,
      0.621402,
      NULL,
      NULL,
      0.691703,
      1.663316,
      NULL,
      NULL,
      2,
      1.202683,
      NULL,
      2.255138,
      0,
      1.998035,
      3,
      NULL,
      0,
      4,
      1.177897,
      0.207178,
      NULL,
      1,
      2,
      NULL,
      1.284627,
      0.457977,
      1.496878,
      1.454918,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.214210,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.050073,
      0.180779,
      0,
      1,
      1.846732,
      3,
      NULL,
      NULL,
      NULL,
      0.671706,
      3.500840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.684928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.099767,
      NULL,
      NULL,
      3,
      1.757052,
      NULL,
      NULL,
      2,
      1.667487,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.654578,
      3.322321,
      NULL,
      NULL,
      3.415013,
      3,
      NULL,
      NULL,
      1.550041,
      1.387972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.808757,
      NULL,
      NULL,
      NULL,
      7.494284,
      6,
      NULL,
      NULL,
      0.102879,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.162485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853932,
      NULL,
      NULL,
      0.303709,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      174.075581,
      11.616705,
      NULL,
      1,
      NULL,
      0,
      0.207818,
      0,
      0,
      0.996419,
      0,
      3.130046,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.299788,
      0,
      3,
      NULL,
      0.337562,
      NULL,
      0.870249,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.758748,
      NULL,
      3.462715,
      NULL,
      1,
      30,
      23,
      0.412311,
      1,
      NULL,
      NULL,
      1.380538,
      NULL,
      1,
      NULL,
      0.401690,
      NULL,
      0.181699,
      NULL,
      1.678953,
      NULL,
      0,
      NULL,
      1.951538,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.769563,
      NULL,
      0.619983,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929569,
      0,
      NULL,
      2.823009,
      NULL,
      1,
      NULL,
      293.198844,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253519,
      3.468556,
      NULL,
      0.827310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.044498,
      1.095888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.004334,
      NULL,
      NULL,
      NULL,
      1.306293,
      NULL,
      1.708351,
      NULL,
      0,
      1,
      0.243516,
      26.167666,
      21,
      1.731105,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.996521,
      0.054756,
      0.059936,
      2,
      3.929029,
      2.255051,
      0,
      0,
      0.328846,
      NULL,
      NULL,
      1.103748,
      NULL,
      1,
      0,
      0.797683,
      0.327927,
      NULL,
      1,
      NULL,
      1.765224,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.900519,
      0.573191,
      1.134069,
      NULL,
      0,
      1,
      0,
      0.489308,
      1,
      0.394333,
      NULL,
      1,
      2.860409,
      NULL,
      0.494300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018109,
      NULL,
      1.987907,
      0,
      1,
      0,
      2,
      5,
      0.341326,
      NULL,
      NULL,
      140,
      108,
      1,
      NULL,
      2,
      '12241',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


