set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '1134324',
      2.547373,
      0.493093,
      4,
      3,
      NULL,
      NULL,
      1.045787,
      NULL,
      NULL,
      ' 4-14-1991',
      26,
      NULL,
      1,
      0,
      0.516258,
      ' 5-25-1988',
      NULL,
      3,
      28.036121,
      NULL,
      NULL,
      NULL,
      ' 2-26-1998',
      NULL,
      2,
      2,
      1,
      2.091495,
      0,
      NULL,
      NULL,
      0,
      1.471981,
      3.157918,
      1,
      11,
      8,
      26,
      NULL,
      2,
      NULL,
      4,
      3,
      1,
      1,
      NULL,
      1,
      0,
      1.286649,
      NULL,
      1.940115,
      0,
      0.223153,
      1,
      38,
      0,
      NULL,
      5,
      2.278067,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.782487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      3.406507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      0.628439,
      NULL,
      0.751928,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      5,
      0,
      1,
      2,
      0,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      0,
      1,
      3,
      2,
      NULL,
      5,
      0,
      NULL,
      1,
      0.856884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      2,
      1,
      0,
      0.296962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      1.539950,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.650391,
      0.710936,
      0,
      1.988471,
      1,
      0,
      NULL,
      NULL,
      0.769311,
      NULL,
      3.110297,
      5.525609,
      3,
      0,
      2,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.749114,
      NULL,
      1,
      47.937356,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.763467,
      0,
      2,
      0,
      1,
      1,
      3,
      NULL,
      2,
      0,
      NULL,
      6.618172,
      0,
      3,
      1.817683,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1.953313,
      0,
      1.841644,
      1,
      0,
      1,
      1.722078,
      NULL,
      1,
      5,
      0.809198,
      3.578814,
      6,
      8,
      3,
      1,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      19,
      5,
      2,
      3.326576,
      '03400',
      '01100',
      '',
      1.914714,
      '21332',
      NULL,
      '',
      0.288497,
      '',
      '',
      '',
      0.016376,
      41.664638,
      NULL,
      31,
      1.015663,
      5.399458,
      8,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.096513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038591,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.551822,
      3,
      2,
      0.559060,
      NULL,
      NULL,
      1,
      NULL,
      2.401268,
      1.263999,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.774171,
      3.033992,
      0.242524,
      NULL,
      6,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.199414,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.181407,
      1,
      NULL,
      NULL,
      0.557765,
      NULL,
      NULL,
      1,
      1.060882,
      0,
      1.707021,
      0.407995,
      0,
      0,
      1,
      0,
      2.036961,
      3.512758,
      NULL,
      3.008726,
      0.179402,
      0.638044,
      1,
      3.769950,
      3,
      1.203044,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.733773,
      3.297082,
      4.538721,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.562389,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.679388,
      NULL,
      0.935547,
      1,
      NULL,
      19.785591,
      NULL,
      NULL,
      0.725785,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2.866633,
      2.757361,
      1.781524,
      7.740616,
      2,
      1.139879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.307308,
      NULL,
      NULL,
      1.363237,
      NULL,
      NULL,
      2.293421,
      0,
      1,
      1.683804,
      NULL,
      3.694749,
      1,
      2,
      NULL,
      0.342607,
      0.729793,
      1,
      6.945796,
      NULL,
      0,
      1.239057,
      1,
      0.729974,
      2.819513,
      0.403731,
      NULL,
      3.343417,
      NULL,
      0,
      0.294123,
      0.402229,
      3.534321,
      NULL,
      NULL,
      NULL,
      3.173715,
      3,
      2.249183,
      0.608968,
      1.072690,
      1,
      3,
      3.307950,
      0,
      1,
      2.034156,
      0.951756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.802923,
      1.982035,
      NULL,
      1,
      0,
      1.546421,
      NULL,
      NULL,
      4.698849,
      NULL,
      NULL,
      4.816916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.677912,
      NULL,
      NULL,
      0,
      1.073679,
      0,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      1.183661,
      3,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      1.322510,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      12.963846,
      8.093252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.444693,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235555,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.961070,
      0,
      NULL,
      NULL,
      3.205363,
      NULL,
      NULL,
      NULL,
      1,
      3.850057,
      NULL,
      NULL,
      NULL,
      2.187869,
      NULL,
      NULL,
      2,
      2.934614,
      NULL,
      NULL,
      3,
      3.019514,
      NULL,
      NULL,
      9,
      10.900409,
      NULL,
      NULL,
      3.293882,
      3.710712,
      2,
      5,
      3.343218,
      1,
      5,
      0.738366,
      15.785830,
      NULL,
      1.479516,
      NULL,
      NULL,
      1.067495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.988584,
      NULL,
      NULL,
      0.560186,
      NULL,
      0.682187,
      119,
      0,
      1.011278,
      NULL,
      0,
      0.644795,
      1.432412,
      1,
      0.990091,
      0.436458,
      1.088732,
      0.035183,
      1,
      1,
      0.760219,
      0.891746,
      1.625889,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262051,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046794,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943703,
      1.126758,
      NULL,
      1.660495,
      NULL,
      0.685606,
      NULL,
      140.072755,
      NULL,
      3.776549,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0.079813,
      0.019087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519554,
      1.212211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      2,
      0.039581,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      3.501413,
      0,
      0,
      7,
      3,
      0.242237,
      0.193445,
      NULL,
      1,
      0,
      1.319779,
      1.489436,
      0,
      0,
      3,
      NULL,
      1,
      1.890883,
      NULL,
      2,
      0.256775,
      3,
      1.933269,
      1,
      3,
      1.916125,
      0,
      1,
      0.562662,
      1,
      1,
      2,
      NULL,
      3.137990,
      1,
      0,
      NULL,
      NULL,
      0.194648,
      0,
      3.066148,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047703,
      0,
      NULL,
      NULL,
      0,
      0.120737,
      1,
      6,
      5,
      0,
      NULL,
      NULL,
      54.277845,
      8.745851,
      4,
      2.988618,
      4.293077,
      NULL,
      '14113',
      '',
      1,
      '12323',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


