set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8121184';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '4223411',
      3.668560,
      0,
      0,
      2,
      '4214',
      2,
      2,
      1,
      7.707598,
      ' 0-16-1996',
      58.370762,
      NULL,
      NULL,
      2.043900,
      1,
      '10- 9-1990',
      29.539410,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 7-1997',
      NULL,
      ' 7- 3-1997',
      3,
      1.181127,
      1,
      0.425914,
      1.057350,
      1,
      3,
      1.125523,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.825374,
      20,
      5,
      NULL,
      0,
      3,
      5,
      NULL,
      1,
      0,
      0,
      0.520048,
      1,
      0.763304,
      1.950722,
      NULL,
      6.212633,
      1,
      2,
      0,
      NULL,
      0.353028,
      4,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      3.934865,
      0,
      2,
      0,
      NULL,
      0.177351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      2,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      0,
      1.971115,
      0.326758,
      6.612059,
      2,
      NULL,
      0,
      NULL,
      1,
      4,
      5,
      0,
      3,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      4,
      1,
      3,
      0,
      NULL,
      3,
      5,
      0,
      6.623611,
      1,
      NULL,
      66,
      NULL,
      3.030099,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787619,
      2,
      0,
      0.419914,
      1,
      1,
      0.487039,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.690398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737992,
      1.302456,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      15.531181,
      3.793249,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      3,
      3,
      3,
      3,
      NULL,
      3,
      2,
      1.113805,
      7,
      NULL,
      3,
      NULL,
      1.530715,
      0.636695,
      1.845169,
      0,
      1,
      1,
      1.635161,
      0,
      0,
      1.531133,
      NULL,
      NULL,
      2.571499,
      1,
      5.227199,
      7,
      2.252139,
      10,
      9,
      2,
      0,
      3,
      6,
      1,
      1,
      0,
      49,
      1,
      1.970140,
      NULL,
      15,
      59,
      62,
      2,
      NULL,
      0,
      '00423',
      '',
      '',
      1,
      '',
      '',
      '',
      0.639228,
      '',
      '',
      '',
      1.544277,
      NULL,
      167,
      43.970139,
      1.373298,
      38,
      12,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.230302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.518520,
      0.889583,
      1.755759,
      NULL,
      NULL,
      0.807003,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      3,
      1.634278,
      0,
      0,
      1.270650,
      1.319800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.535084,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.595789,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1.167579,
      NULL,
      NULL,
      3,
      0.872437,
      1,
      0,
      0,
      NULL,
      1.733193,
      NULL,
      NULL,
      1,
      1.585635,
      1,
      0.495467,
      1.544044,
      1,
      NULL,
      1.608785,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.035535,
      5.371097,
      0.368263,
      1,
      0.675316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.507386,
      NULL,
      0.670983,
      2.141881,
      3.047130,
      0,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343203,
      NULL,
      0,
      NULL,
      NULL,
      5.954883,
      1.974593,
      NULL,
      2.055046,
      2.424392,
      1.159544,
      17,
      NULL,
      NULL,
      2.857161,
      3,
      1,
      12.860040,
      NULL,
      NULL,
      0,
      2.422988,
      0.793906,
      2,
      7.458580,
      0,
      3,
      0,
      0.088070,
      0.130102,
      NULL,
      NULL,
      NULL,
      3,
      1.439828,
      1.579901,
      3,
      1.119827,
      5,
      3,
      2.630328,
      0,
      1.866860,
      1.071713,
      NULL,
      3.470660,
      2,
      3,
      2.694406,
      0,
      10,
      4.775919,
      1,
      3.398723,
      NULL,
      1.450898,
      0,
      0,
      1.802640,
      NULL,
      NULL,
      NULL,
      0,
      3.907199,
      0.810914,
      8.300408,
      0,
      3.804974,
      NULL,
      2.509383,
      0.679382,
      2.335341,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.916994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.904928,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.242203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092685,
      NULL,
      NULL,
      0.296053,
      NULL,
      NULL,
      0,
      0.196473,
      1,
      0,
      1.387658,
      3,
      NULL,
      NULL,
      NULL,
      1.226661,
      NULL,
      NULL,
      NULL,
      NULL,
      6.807612,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.011153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.590711,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.731831,
      NULL,
      NULL,
      NULL,
      0,
      0.684364,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.001913,
      NULL,
      NULL,
      0,
      1.210376,
      NULL,
      NULL,
      2.099886,
      3.162890,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.551220,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.705363,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.218584,
      21.743514,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.064746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.169321,
      NULL,
      NULL,
      0.025686,
      NULL,
      0,
      46,
      NULL,
      0,
      0.276861,
      0,
      1,
      1.748867,
      1.331965,
      0,
      NULL,
      0.934618,
      0.066098,
      1.292533,
      1,
      0.445542,
      1.070558,
      NULL,
      0.231843,
      0.048349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.346757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224531,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.322160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139932,
      0.542329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718649,
      0.247496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.005672,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.432020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      6,
      NULL,
      1.376899,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.019230,
      0.311841,
      0.584822,
      0,
      NULL,
      NULL,
      1.114765,
      0,
      NULL,
      1,
      1.808683,
      0,
      1.085009,
      0,
      1.011078,
      17.105066,
      NULL,
      0.062642,
      1.413385,
      1.767850,
      0.999651,
      0,
      1,
      0,
      3,
      NULL,
      2,
      0,
      0,
      2.792654,
      2.008786,
      2.176537,
      0.704556,
      1,
      3,
      NULL,
      1.934937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379936,
      NULL,
      0.647388,
      NULL,
      0,
      0,
      2,
      1,
      7,
      0,
      1,
      NULL,
      78,
      12,
      NULL,
      1.149326,
      2,
      '10122',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


