set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8912456';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1024402',
      2.595172,
      0.673211,
      2,
      3,
      '2013',
      0.076879,
      1.939995,
      NULL,
      NULL,
      ' 5-29-1984',
      52.445061,
      NULL,
      NULL,
      0,
      NULL,
      '11- 2-1976',
      52.228382,
      NULL,
      170.564387,
      NULL,
      1,
      ' 9- 4-1992',
      ' 7-15-1987',
      ' 5-15-1999',
      0.390006,
      2.561609,
      0,
      2.355794,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      6.987665,
      1,
      9,
      NULL,
      0,
      0.047413,
      1,
      1,
      0,
      NULL,
      0.151025,
      1.507370,
      0,
      NULL,
      0,
      1,
      1.775933,
      2,
      0,
      4,
      3.084293,
      0,
      1,
      3,
      0,
      3,
      0,
      NULL,
      0,
      4,
      0,
      1,
      NULL,
      3,
      0,
      1,
      1,
      0,
      1.809660,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.519103,
      0,
      0.071420,
      0.925643,
      0.696473,
      0,
      NULL,
      1.149117,
      NULL,
      2,
      NULL,
      3.327889,
      NULL,
      1.237822,
      2,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.651605,
      0,
      1,
      0,
      1,
      NULL,
      3,
      0,
      4,
      2,
      0,
      0,
      1,
      1,
      0,
      NULL,
      4,
      2,
      NULL,
      0,
      5,
      1,
      5,
      1,
      4,
      0,
      2,
      2.741849,
      NULL,
      1598,
      '11-11-1996',
      1017,
      0.198021,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.282684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.186555,
      1,
      3,
      2.859850,
      3.429015,
      1,
      1,
      0,
      0.414473,
      4.612052,
      4,
      0.642270,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536428,
      0.642705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.059463,
      0.258456,
      1,
      1,
      1.712697,
      1,
      1.770794,
      43.375845,
      NULL,
      1.910375,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      3,
      1,
      3,
      3,
      1,
      0,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5,
      0,
      1.730436,
      NULL,
      0.400040,
      0,
      0,
      1.617229,
      0,
      0,
      1.743288,
      3.924024,
      0,
      NULL,
      1,
      6,
      6.576172,
      7,
      NULL,
      0.014270,
      2,
      3,
      1,
      0,
      3.365793,
      NULL,
      0,
      1,
      NULL,
      31,
      NULL,
      21.546249,
      5,
      0,
      NULL,
      '03300',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5,
      '44332',
      '0013',
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      4.243340,
      5,
      NULL,
      1,
      1,
      1.109390,
      2.845160,
      0,
      NULL,
      NULL,
      2,
      0.026744,
      3.086970,
      1.610688,
      NULL,
      NULL,
      2.711102,
      0.068001,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1.836094,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.770159,
      NULL,
      5.170403,
      1,
      0.269301,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      2.987577,
      0.072907,
      NULL,
      NULL,
      NULL,
      1.231279,
      1,
      NULL,
      1.186321,
      0.986174,
      2.826451,
      2.720860,
      0,
      3,
      NULL,
      NULL,
      1,
      1.627611,
      1.596480,
      0.842579,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      5,
      7.064104,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.930349,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      2.595738,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      1.712810,
      NULL,
      1.490861,
      NULL,
      NULL,
      0.514281,
      NULL,
      NULL,
      1.253343,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.889713,
      0,
      0,
      NULL,
      3.445255,
      0,
      2,
      NULL,
      0.818696,
      5,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2.598850,
      2,
      1.606158,
      2.607671,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.979406,
      3,
      NULL,
      NULL,
      1.642007,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      1.593589,
      6.981752,
      4.605941,
      NULL,
      0.086170,
      2,
      1,
      4,
      NULL,
      NULL,
      0,
      0.483326,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038509,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.178038,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.384052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.112690,
      NULL,
      1.403514,
      NULL,
      NULL,
      2.809340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925965,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.163177,
      NULL,
      NULL,
      NULL,
      3.064584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.992557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      366.963212,
      50,
      NULL,
      NULL,
      NULL,
      1.670674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.395529,
      NULL,
      1.932787,
      NULL,
      NULL,
      0.380168,
      1.347461,
      0.670554,
      0,
      NULL,
      NULL,
      1.164155,
      NULL,
      0,
      NULL,
      1,
      0,
      1.479164,
      0.947228,
      NULL,
      0.036858,
      0.392923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      0,
      NULL,
      2.755570,
      3,
      18,
      1,
      2.257897,
      1,
      0.688497,
      0,
      NULL,
      1,
      1.238428,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.132390,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.306312,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.863345,
      2.193357,
      NULL,
      0.044829,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      25.787637,
      NULL,
      2,
      0,
      3.421312,
      '01420',
      '',
      '',
      0.264361,
      NULL,
      '',
      '',
      4.690219,
      NULL,
      '1133',
      '');
commit;
end;
/


