set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9222256';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      2.627063,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04',
      NULL,
      30,
      '0101223',
      NULL,
      1,
      0,
      1,
      '3140',
      0.021480,
      0.977951,
      NULL,
      NULL,
      NULL,
      66.160730,
      73,
      NULL,
      2.917120,
      NULL,
      ' 8- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-24-1999',
      '11-24-1988',
      NULL,
      1,
      3.877926,
      3,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.373030,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      0.762260,
      0,
      1,
      1.794007,
      0,
      NULL,
      3,
      3,
      3.157775,
      3,
      1,
      1,
      0,
      0,
      3,
      0,
      0,
      0,
      2,
      2,
      NULL,
      11,
      1,
      NULL,
      0,
      1,
      0.148177,
      NULL,
      NULL,
      0.489565,
      NULL,
      NULL,
      NULL,
      2,
      1.256770,
      0,
      1,
      NULL,
      1,
      NULL,
      0.907254,
      0.025789,
      3.732460,
      1.646101,
      0,
      0,
      1,
      0,
      1,
      1.261895,
      1.993271,
      0,
      1,
      1,
      10.586232,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.802459,
      NULL,
      NULL,
      0,
      4,
      1,
      3,
      3,
      2,
      3,
      1,
      1,
      0,
      0,
      1,
      0,
      5,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      3,
      1,
      0,
      0,
      2,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      5,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      5,
      0,
      ' 6-10-1978',
      678.302649,
      ' 5-15-1984',
      976.112266,
      1.713848,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.208128,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.893342,
      NULL,
      0.319511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.582905,
      0,
      1.131034,
      NULL,
      1,
      0.167067,
      3,
      67,
      0.245309,
      1.991206,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.192511,
      3,
      NULL,
      2,
      0,
      2,
      0,
      1,
      1,
      3,
      0,
      1,
      2,
      0.776134,
      0,
      0,
      0,
      5.246317,
      0,
      1,
      NULL,
      1.402449,
      0.110895,
      0,
      1.432538,
      0.762119,
      1,
      0.477449,
      3.966427,
      1.283029,
      NULL,
      5,
      6.440463,
      7,
      8,
      6.975174,
      NULL,
      1.817939,
      5,
      0.421191,
      NULL,
      NULL,
      0,
      0,
      3,
      50,
      NULL,
      23,
      11.464758,
      NULL,
      4,
      2.374482,
      '13424',
      '23403',
      '',
      0.881059,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      41.913446,
      94.048731,
      NULL,
      0.887753,
      NULL,
      NULL,
      NULL,
      NULL,
      3.562247,
      NULL,
      2.501727,
      NULL,
      NULL,
      NULL,
      1.449622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.285066,
      1,
      1,
      0.816796,
      0,
      0.602460,
      2.570800,
      NULL,
      NULL,
      2.258443,
      2,
      2,
      0,
      0,
      NULL,
      0.946844,
      NULL,
      NULL,
      0.697544,
      11.767251,
      1,
      NULL,
      0.638386,
      NULL,
      NULL,
      NULL,
      0.919130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.170812,
      1,
      2,
      1,
      1.381798,
      2,
      2.870580,
      1.993421,
      1,
      1.294099,
      0,
      1,
      0,
      1.636801,
      0.637480,
      NULL,
      3.175006,
      0.309259,
      1,
      NULL,
      NULL,
      1.481142,
      3.208373,
      1,
      7,
      11,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.133354,
      NULL,
      NULL,
      NULL,
      1.313522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.732804,
      NULL,
      NULL,
      1,
      0,
      0,
      7,
      2,
      1,
      3,
      0,
      0.447920,
      1.177567,
      NULL,
      NULL,
      2,
      6.269859,
      2,
      0.859713,
      NULL,
      NULL,
      1.513260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500384,
      NULL,
      NULL,
      0.957979,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768961,
      1,
      1.817024,
      5.402128,
      2,
      0,
      1.598329,
      NULL,
      NULL,
      0.910916,
      NULL,
      NULL,
      0.291106,
      NULL,
      NULL,
      2.496244,
      NULL,
      NULL,
      1.498045,
      NULL,
      NULL,
      NULL,
      7.906282,
      NULL,
      1.566237,
      NULL,
      NULL,
      1,
      2.859973,
      NULL,
      1.805682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      2.408923,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.514986,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.559981,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.310493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.706880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.903586,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.094645,
      NULL,
      NULL,
      NULL,
      1.599112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.718043,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.036493,
      NULL,
      NULL,
      NULL,
      2.919682,
      3.780328,
      1,
      1,
      0.063337,
      0.194273,
      5,
      2.916467,
      43,
      22,
      1,
      NULL,
      NULL,
      1.584991,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1154,
      88.957057,
      NULL,
      1.647150,
      3,
      2.706893,
      2.874022,
      1.200395,
      1,
      NULL,
      NULL,
      0,
      0.404016,
      2.778077,
      NULL,
      NULL,
      1.945095,
      0.877700,
      NULL,
      1.173014,
      1,
      0,
      0.192597,
      2,
      0,
      2.775511,
      3,
      NULL,
      NULL,
      0.375475,
      117,
      131.367877,
      2.304057,
      2.919572,
      NULL,
      NULL,
      NULL,
      0.238848,
      2.326377,
      1,
      NULL,
      1.873202,
      NULL,
      NULL,
      3.537706,
      1.425004,
      2,
      0.913481,
      NULL,
      1,
      NULL,
      1,
      0.985804,
      NULL,
      NULL,
      0,
      2,
      1.570401,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.920232,
      3.223642,
      0.586720,
      0,
      0.537925,
      0.421399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533090,
      0.249191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.200406,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.451148,
      0.606625,
      1.768526,
      NULL,
      2.903582,
      NULL,
      3,
      NULL,
      18.568673,
      NULL,
      2,
      NULL,
      2.292588,
      NULL,
      2,
      NULL,
      1.841072,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852381,
      3,
      NULL,
      2,
      NULL,
      3,
      NULL,
      755,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      1.153963,
      3.411664,
      2,
      NULL,
      NULL,
      1.826837,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      1.771548,
      2,
      NULL,
      0,
      1.729383,
      NULL,
      0.980727,
      2,
      NULL,
      0.823295,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.131771,
      2,
      NULL,
      1,
      1,
      NULL,
      2.901512,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.093689,
      NULL,
      NULL,
      1.729860,
      0.014331,
      NULL,
      1.883112,
      0.688411,
      NULL,
      3.173090,
      1.485603,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230539,
      NULL,
      NULL,
      NULL,
      0.893346,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      117.617079,
      37,
      2,
      4,
      NULL,
      '13444',
      NULL,
      '12440',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


