set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9676087';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      2,
      2,
      NULL,
      2,
      NULL,
      2.149694,
      '100',
      '31301014',
      NULL,
      11.103684,
      NULL,
      3,
      1.078020,
      1,
      1,
      '2312',
      NULL,
      0.029866,
      NULL,
      NULL,
      ' 6-11-1982',
      139,
      NULL,
      NULL,
      NULL,
      0.738433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-1989',
      NULL,
      0.646398,
      1,
      1,
      2,
      1,
      0,
      NULL,
      1.933143,
      4,
      6,
      11,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5,
      2.818216,
      2,
      1,
      1,
      0,
      0,
      0,
      0,
      NULL,
      2,
      2,
      2,
      NULL,
      0.243561,
      0,
      0,
      1,
      1,
      0.482681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.328006,
      1.293460,
      0.776419,
      3,
      1.557295,
      NULL,
      0.828102,
      1.059874,
      0,
      1.882737,
      1.158737,
      3,
      0,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      5,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1.872840,
      NULL,
      NULL,
      2,
      5,
      5,
      0,
      5,
      2,
      3,
      1,
      0,
      3,
      1,
      2,
      0,
      5,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      4,
      3,
      1,
      2,
      NULL,
      5,
      0,
      5,
      4,
      0,
      4,
      0,
      1.553465,
      1,
      ' 7- 3-1990',
      NULL,
      '10- 8-1999',
      216,
      3,
      1,
      1,
      NULL,
      2,
      NULL,
      4,
      1,
      1,
      3,
      0,
      4,
      NULL,
      5,
      2,
      2,
      0,
      3,
      1,
      1.868592,
      1.094527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296655,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004462,
      0.994012,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.967056,
      NULL,
      5,
      6,
      7,
      1.810807,
      1.134092,
      2,
      7.904837,
      0,
      NULL,
      2.404105,
      56,
      2,
      NULL,
      46,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      '',
      '',
      1.091567,
      '',
      '',
      '',
      NULL,
      '2403',
      '',
      '',
      0.387528,
      18.180014,
      203.090722,
      17.490055,
      3.653761,
      15,
      6,
      9,
      4,
      0.066817,
      1,
      2.469834,
      0.070083,
      NULL,
      NULL,
      1.287039,
      NULL,
      NULL,
      1.215816,
      3.348239,
      NULL,
      0.925581,
      NULL,
      NULL,
      0.952738,
      NULL,
      NULL,
      1,
      3.699902,
      2.321185,
      0.057322,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.725300,
      1,
      2,
      0.729156,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      6.113709,
      0,
      3.477886,
      NULL,
      2.030627,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.292976,
      3.166666,
      2,
      2.509348,
      1.142228,
      1.646142,
      2.337132,
      3.158792,
      1.452353,
      NULL,
      0.759785,
      1.104355,
      0.470175,
      0.436170,
      0.651878,
      3.363715,
      0,
      NULL,
      1,
      3.881618,
      0.428080,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.087412,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0.789729,
      0,
      NULL,
      0.761481,
      0,
      NULL,
      NULL,
      NULL,
      0.541871,
      2.429049,
      NULL,
      3,
      0.353511,
      2.857055,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.009871,
      1.935559,
      NULL,
      3,
      1.408896,
      1,
      3,
      0,
      4,
      3,
      1,
      1.432223,
      NULL,
      NULL,
      1.153752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.302912,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0,
      0.632114,
      NULL,
      2.998103,
      1.570823,
      2,
      NULL,
      NULL,
      NULL,
      4.141690,
      4.732098,
      7,
      2.011253,
      NULL,
      3,
      1.350904,
      1.526637,
      3.010052,
      2.673472,
      1,
      1.496509,
      0.011666,
      0.886114,
      0.470242,
      0,
      NULL,
      4.549588,
      7.267329,
      2,
      2.614325,
      2.494836,
      NULL,
      1,
      3,
      0,
      0,
      0.210121,
      0.012974,
      1,
      NULL,
      2,
      3,
      NULL,
      118,
      176.590732,
      NULL,
      2,
      1,
      NULL,
      3.178422,
      0.942198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.484937,
      2,
      NULL,
      3,
      1,
      NULL,
      1,
      1.078400,
      NULL,
      2,
      NULL,
      NULL,
      2.862849,
      1,
      NULL,
      2,
      3.495588,
      NULL,
      NULL,
      0,
      NULL,
      17,
      1.879362,
      1.158584,
      0,
      0.289847,
      0.025371,
      NULL,
      0,
      NULL,
      NULL,
      1.407500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.985262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.056024,
      NULL,
      NULL,
      NULL,
      0.870716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793735,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.522743,
      NULL,
      NULL,
      NULL,
      1.217767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.205468,
      2.359521,
      7,
      5,
      3,
      100.959116,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.162190,
      NULL,
      3.970889,
      2,
      121.856060,
      NULL,
      1.874669,
      NULL,
      NULL,
      0,
      NULL,
      0.525679,
      123,
      1.150793,
      1,
      1,
      1,
      NULL,
      NULL,
      1.745456,
      0,
      NULL,
      0,
      0.517693,
      0,
      0,
      1,
      0.760870,
      1,
      0.141966,
      1,
      1.607584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.124316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629757,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.331040,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.633175,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.557346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549385,
      NULL,
      0.678734,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.723401,
      NULL,
      1.791426,
      NULL,
      1.611908,
      0.075223,
      1,
      NULL,
      NULL,
      1.346663,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      2,
      3.528959,
      1,
      2,
      7.223528,
      3.311715,
      2.471569,
      0,
      2,
      3,
      NULL,
      0.047942,
      NULL,
      NULL,
      0,
      1.041428,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946287,
      3,
      NULL,
      0,
      0.250208,
      NULL,
      1.671435,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.478752,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796671,
      NULL,
      0,
      NULL,
      1.030500,
      NULL,
      0,
      4,
      NULL,
      0.189072,
      0.144493,
      2,
      64,
      63.110161,
      3,
      0.868738,
      3.664378,
      '10314',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3.911833,
      NULL,
      '',
      '');
commit;
end;
/


