set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9687307';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      '12',
      0.145828,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      '2111',
      NULL,
      1.237700,
      NULL,
      NULL,
      ' 2-29-1987',
      37.411310,
      87.498914,
      NULL,
      0,
      3,
      ' 7- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 2-24-1981',
      ' 2-13-1999',
      NULL,
      NULL,
      2.990996,
      NULL,
      NULL,
      0.963779,
      2.388109,
      0,
      2.031417,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1.792376,
      1,
      7.782445,
      NULL,
      1,
      0,
      1,
      2,
      1,
      0.153697,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.375405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      3,
      4,
      2,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      5,
      2.162768,
      2,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      3,
      0,
      0,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      4.294857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0.258705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831067,
      1.852621,
      NULL,
      NULL,
      0.502904,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.137116,
      0.333911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.728268,
      0,
      1,
      1.249726,
      1,
      1.730230,
      1,
      NULL,
      NULL,
      3.289104,
      NULL,
      NULL,
      33.523716,
      3,
      0,
      1,
      1,
      2,
      1,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.322225,
      3,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      0.849708,
      1,
      1,
      NULL,
      0,
      1,
      1.594337,
      NULL,
      NULL,
      8.148399,
      NULL,
      NULL,
      1.080974,
      NULL,
      5.417286,
      1.811497,
      1.794471,
      4,
      1.250960,
      3.042458,
      NULL,
      18.240277,
      3,
      3.860439,
      58,
      NULL,
      82,
      25.888568,
      3,
      5,
      3,
      '20321',
      '1113',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      17,
      6,
      17.110250,
      0.486339,
      27,
      NULL,
      25,
      NULL,
      3.742863,
      2.619395,
      3,
      1,
      NULL,
      NULL,
      1.337901,
      NULL,
      NULL,
      1.129306,
      NULL,
      NULL,
      1.136855,
      NULL,
      NULL,
      0.709393,
      NULL,
      NULL,
      3.004041,
      NULL,
      NULL,
      1.628666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.403587,
      NULL,
      NULL,
      4.211929,
      3,
      0,
      0,
      1.219618,
      NULL,
      NULL,
      NULL,
      2,
      0.840583,
      2,
      2.539019,
      1,
      3.645250,
      NULL,
      0,
      NULL,
      NULL,
      0.989972,
      NULL,
      NULL,
      2,
      1,
      1.239817,
      2,
      1.192223,
      3.351998,
      1,
      3,
      0.779469,
      0.929870,
      2,
      3,
      3,
      0,
      2,
      2.732293,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      1.638776,
      5,
      0.035974,
      1,
      1.076366,
      NULL,
      NULL,
      NULL,
      0,
      0.052037,
      NULL,
      1.053129,
      0.643630,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.498714,
      1.533402,
      3.199679,
      1,
      NULL,
      NULL,
      5,
      5.577118,
      6,
      NULL,
      NULL,
      NULL,
      1.644438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.982845,
      2,
      NULL,
      1.621362,
      NULL,
      NULL,
      NULL,
      0.246891,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.261925,
      1.914699,
      NULL,
      NULL,
      2.789731,
      3.739780,
      NULL,
      2.485916,
      3.501298,
      3,
      0.199056,
      1.316633,
      1.725420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.550022,
      0,
      0.159497,
      2,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      3.952037,
      0,
      1,
      2,
      0,
      0.209493,
      1.292380,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098841,
      NULL,
      NULL,
      1.798938,
      NULL,
      NULL,
      3.472936,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.406100,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.645112,
      NULL,
      2.003978,
      NULL,
      NULL,
      3.860380,
      NULL,
      2.842322,
      NULL,
      0.823003,
      0,
      3.042073,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.866299,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.702071,
      NULL,
      1,
      0,
      3.823925,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0.001329,
      NULL,
      NULL,
      NULL,
      0,
      1.581312,
      NULL,
      NULL,
      0.237492,
      0,
      NULL,
      NULL,
      0.421395,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      3.287476,
      3.295051,
      NULL,
      NULL,
      5.082844,
      0,
      6,
      3.972727,
      28.943544,
      11.590885,
      2.310643,
      1,
      5.028316,
      1.067437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.243719,
      149,
      1.430245,
      1,
      1,
      NULL,
      0.841292,
      NULL,
      0,
      0,
      1.995571,
      0,
      0.226782,
      NULL,
      0.658727,
      0,
      1.449832,
      0,
      0.745264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.609049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936539,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.118329,
      NULL,
      1.651133,
      NULL,
      1.307191,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.880748,
      NULL,
      1.243116,
      NULL,
      0.983053,
      NULL,
      NULL,
      NULL,
      1.973684,
      NULL,
      3.309796,
      NULL,
      1.300032,
      NULL,
      0.503109,
      NULL,
      NULL,
      NULL,
      1.173796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      2,
      2.355555,
      4,
      2,
      9.073299,
      0,
      1.110393,
      2.535438,
      0,
      1.202062,
      1,
      0.141374,
      1.929730,
      NULL,
      0.399960,
      1,
      3,
      NULL,
      0.167213,
      NULL,
      0.631135,
      NULL,
      NULL,
      3.121734,
      3,
      NULL,
      0.748452,
      NULL,
      1,
      0,
      3,
      0.095601,
      0,
      1.877910,
      1.340091,
      2.703908,
      3.770040,
      3,
      0,
      NULL,
      1.109651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156118,
      1,
      1,
      0.619201,
      1,
      1.130511,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      90.417666,
      2,
      NULL,
      0.909844,
      NULL,
      '1311',
      NULL,
      1,
      '',
      '',
      '',
      1.051151,
      NULL,
      NULL,
      '');
commit;
end;
/


