set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      4,
      1,
      0.945370,
      2.000722,
      0,
      1.416791,
      2,
      '14',
      '01243302',
      2.854651,
      44,
      '3430024',
      1.130519,
      NULL,
      4,
      NULL,
      '4223',
      0.977284,
      0,
      NULL,
      NULL,
      ' 5-15-1979',
      41.665423,
      NULL,
      NULL,
      3,
      0.733722,
      ' 3-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 8- 5-1987',
      0,
      NULL,
      1,
      NULL,
      1.276762,
      0,
      3,
      0.392689,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      0.866045,
      NULL,
      0.822221,
      NULL,
      1.232880,
      1,
      2,
      NULL,
      5,
      3,
      0,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      5,
      1,
      1,
      NULL,
      1,
      6.772261,
      2,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0.725736,
      NULL,
      NULL,
      3,
      1,
      6.089564,
      2.930001,
      0,
      0.639187,
      3,
      0,
      0,
      NULL,
      NULL,
      1.139875,
      NULL,
      0.144600,
      1.461693,
      3,
      NULL,
      NULL,
      3.404271,
      4,
      1,
      3,
      3.954070,
      3,
      NULL,
      1.574663,
      0,
      NULL,
      NULL,
      0.839424,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      3,
      1,
      0,
      2,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.715725,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      0,
      0,
      2,
      NULL,
      3,
      2,
      5,
      3,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      4,
      NULL,
      4,
      3,
      5,
      2,
      0,
      2,
      ' 1- 6-1977',
      56,
      ' 7-24-1996',
      61.093528,
      3,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.602448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.570489,
      NULL,
      1.494273,
      NULL,
      0,
      0,
      2.304458,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.983910,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.403682,
      1,
      1,
      0.304257,
      1.612780,
      0.025301,
      0.147098,
      NULL,
      NULL,
      1.877352,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.867063,
      0,
      0,
      0,
      1,
      1,
      0,
      2,
      3,
      0,
      1,
      NULL,
      1,
      2,
      1.715245,
      0.880629,
      0,
      2.002808,
      NULL,
      0.943598,
      NULL,
      0.478576,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0.646985,
      0,
      11,
      NULL,
      3.442912,
      1.211059,
      4,
      0.690119,
      5.186876,
      3,
      0,
      0.297476,
      NULL,
      3,
      NULL,
      1,
      NULL,
      49,
      NULL,
      NULL,
      NULL,
      3,
      2.332022,
      2,
      '24234',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.110086,
      NULL,
      NULL,
      NULL,
      0,
      10.785951,
      29.763140,
      33,
      3.685363,
      NULL,
      4,
      1.836413,
      1,
      2.307899,
      2,
      2.475477,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.431121,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.115898,
      NULL,
      0,
      NULL,
      3.562147,
      3,
      NULL,
      1,
      0.803791,
      3.638817,
      1.126424,
      NULL,
      NULL,
      1.153448,
      NULL,
      NULL,
      1.368622,
      NULL,
      NULL,
      1,
      11.174758,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2.405557,
      3.808953,
      0,
      0.558360,
      0,
      0,
      0,
      2.852832,
      1.827807,
      1,
      2,
      NULL,
      2.109799,
      1.748460,
      0,
      1.495348,
      3,
      NULL,
      1,
      0.487432,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.787344,
      2,
      0.890502,
      9.333834,
      NULL,
      4.221505,
      2,
      1.586796,
      NULL,
      NULL,
      NULL,
      1.490376,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.954068,
      2,
      3,
      1.134839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      2.252492,
      4.143666,
      NULL,
      1,
      2.561204,
      1.594106,
      NULL,
      NULL,
      0,
      5,
      4,
      2.739377,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.653441,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.901454,
      4.799632,
      NULL,
      NULL,
      0.194478,
      3.842295,
      3.493303,
      1.334607,
      0,
      1.520988,
      7,
      8.701784,
      NULL,
      5.692742,
      0,
      7,
      NULL,
      9.046266,
      7,
      2,
      1,
      NULL,
      3.354340,
      3.818988,
      0.640055,
      0,
      3.073330,
      0.530188,
      9.614406,
      9,
      8.503881,
      NULL,
      1.265857,
      0.663086,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      6.196439,
      9,
      11.736020,
      3,
      4.508813,
      2.379746,
      2,
      NULL,
      0.728906,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.768023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.479383,
      NULL,
      NULL,
      1.747484,
      NULL,
      NULL,
      0.697893,
      NULL,
      NULL,
      0.759298,
      NULL,
      NULL,
      1.619911,
      NULL,
      NULL,
      0,
      1.621760,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.382306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814161,
      NULL,
      NULL,
      NULL,
      0.728003,
      NULL,
      NULL,
      NULL,
      0.565843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.913394,
      NULL,
      NULL,
      NULL,
      2.229009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.583217,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.594749,
      0.896298,
      9,
      1.858687,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.700685,
      NULL,
      NULL,
      3.887774,
      1.538504,
      1.639208,
      1.985206,
      NULL,
      0.352191,
      114.286321,
      NULL,
      1,
      1.666455,
      1,
      NULL,
      1.530592,
      NULL,
      0,
      0.051548,
      0.426292,
      NULL,
      1,
      1.433148,
      1,
      0,
      0.182404,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      1,
      1.830985,
      2,
      0.979497,
      1.143446,
      NULL,
      0,
      1,
      3,
      NULL,
      1.130001,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.168026,
      NULL,
      NULL,
      1,
      2.686035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.988171,
      NULL,
      NULL,
      3.323505,
      NULL,
      2.604079,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      4,
      6,
      1,
      NULL,
      NULL,
      45.470801,
      NULL,
      NULL,
      5.010806,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.911701,
      '',
      '',
      NULL);
commit;
end;
/


