set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3320314',
      1,
      1.346001,
      3,
      0,
      NULL,
      3,
      1.719095,
      NULL,
      NULL,
      ' 2-13-1992',
      89,
      NULL,
      4,
      0.088198,
      NULL,
      ' 6-22-1994',
      NULL,
      2.294786,
      277.001854,
      0,
      2,
      NULL,
      NULL,
      ' 7- 0-1979',
      0,
      2.444299,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2,
      5.699653,
      NULL,
      NULL,
      NULL,
      2,
      23,
      3,
      0,
      4.468369,
      1.331806,
      1,
      1,
      NULL,
      0,
      0.414249,
      0,
      0.476150,
      0.585606,
      0,
      0.686777,
      NULL,
      0,
      2,
      3,
      3,
      1,
      3,
      NULL,
      4,
      1,
      0,
      2,
      NULL,
      0,
      0,
      0,
      1.730698,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268424,
      NULL,
      NULL,
      1,
      3,
      9.006490,
      NULL,
      NULL,
      NULL,
      1.541477,
      0,
      NULL,
      1,
      2,
      2.520597,
      3.189909,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.023275,
      NULL,
      1,
      0,
      4,
      1,
      1,
      2,
      0.944613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1.774231,
      1,
      NULL,
      0,
      1,
      0.941539,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      3,
      1,
      1,
      NULL,
      2,
      0,
      0,
      0,
      2,
      1.187945,
      ' 2- 0-1989',
      780,
      ' 0-25-1979',
      671,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.864897,
      0,
      0.760308,
      1.422267,
      1.147286,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.232207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185508,
      0.480232,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.361730,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      2,
      NULL,
      2,
      3,
      3,
      3,
      NULL,
      2,
      2,
      0,
      1.983799,
      NULL,
      5,
      3.733456,
      1,
      0.709040,
      NULL,
      1.582753,
      7.803551,
      0.761144,
      0.391264,
      1,
      1,
      1,
      NULL,
      3.088701,
      NULL,
      0,
      8,
      7.021701,
      0,
      NULL,
      9.250062,
      NULL,
      3.320790,
      2,
      4.306498,
      1.567872,
      3.613022,
      1.875457,
      17,
      NULL,
      1.496614,
      77,
      NULL,
      NULL,
      NULL,
      3,
      0.604745,
      4.740146,
      '21321',
      '44213',
      '',
      1,
      '',
      '',
      NULL,
      1.863408,
      '',
      '',
      NULL,
      0.895225,
      41.031159,
      527.289402,
      34.622283,
      NULL,
      36,
      4,
      9,
      NULL,
      0.762721,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.996550,
      NULL,
      1,
      NULL,
      NULL,
      1.568068,
      0.156887,
      2,
      0.514742,
      NULL,
      NULL,
      1.466269,
      2,
      1.800295,
      0,
      0.836043,
      NULL,
      NULL,
      NULL,
      1.950252,
      NULL,
      NULL,
      NULL,
      NULL,
      2.199416,
      1,
      3.357837,
      NULL,
      NULL,
      0.547499,
      2.398197,
      2,
      NULL,
      0,
      1.003116,
      0.813631,
      0.678334,
      NULL,
      1,
      2,
      3.567028,
      3,
      0,
      NULL,
      2.848970,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.301184,
      NULL,
      NULL,
      NULL,
      8,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.269533,
      NULL,
      NULL,
      0.075875,
      NULL,
      NULL,
      0.242847,
      NULL,
      NULL,
      0.017721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.412016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.820115,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.358720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.855937,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.163282,
      4,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.320969,
      0.202531,
      NULL,
      NULL,
      2,
      0.029974,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.574215,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.292862,
      NULL,
      4,
      NULL,
      0.316971,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.738647,
      NULL,
      NULL,
      1.156699,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1.510092,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.658008,
      1.393150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.927662,
      0,
      NULL,
      NULL,
      0.457776,
      1.165992,
      NULL,
      NULL,
      0.530400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      316.133857,
      51,
      0.876505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281362,
      NULL,
      NULL,
      3.502464,
      9,
      NULL,
      NULL,
      29,
      1,
      NULL,
      0,
      0.621840,
      NULL,
      0.118672,
      1.640981,
      NULL,
      0.075410,
      1.257087,
      0,
      0.892315,
      0,
      NULL,
      1,
      1,
      0.601241,
      0.384321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      2.521010,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.243935,
      1,
      2,
      NULL,
      NULL,
      0.209271,
      1.397324,
      1,
      1,
      0,
      0.799350,
      0,
      0.356190,
      1,
      0.300387,
      0.698408,
      1,
      0.471927,
      1.645819,
      1,
      1,
      1,
      0,
      1.168733,
      NULL,
      0.545329,
      1,
      NULL,
      0.488577,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762997,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      4,
      1.781446,
      NULL,
      NULL,
      107.510959,
      57.677762,
      3,
      NULL,
      2,
      NULL,
      NULL,
      '',
      1.661308,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


