set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      NULL,
      19.484829,
      NULL,
      '1014243',
      2,
      0.100509,
      5,
      1,
      '2342',
      3.671112,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1987',
      30,
      25.622236,
      NULL,
      3.242390,
      NULL,
      ' 9-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 4-13-1991',
      3,
      NULL,
      0.852378,
      0.075616,
      0.245891,
      1.620950,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3.842652,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0.593130,
      0.556347,
      1,
      0.189274,
      NULL,
      1,
      0,
      2,
      3,
      0.276378,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0.178681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1.272108,
      1,
      NULL,
      1,
      0,
      0.793427,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      5,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0,
      NULL,
      1,
      2,
      3,
      0,
      0,
      2,
      0,
      0,
      5,
      1,
      1,
      3,
      5.266789,
      1.217085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.042487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.214959,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0.957219,
      1.166739,
      1.440316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.995711,
      0,
      NULL,
      1.527633,
      0.581121,
      NULL,
      3.785393,
      18,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.381128,
      1,
      1,
      1.414981,
      0,
      2,
      NULL,
      NULL,
      1.210091,
      NULL,
      0.189427,
      0,
      0,
      0.568441,
      NULL,
      1.653495,
      5,
      0,
      7,
      11,
      1,
      7.170904,
      2.287497,
      NULL,
      5,
      3.534823,
      5,
      0,
      NULL,
      NULL,
      15.227256,
      1,
      NULL,
      26,
      NULL,
      56,
      0,
      0,
      NULL,
      3,
      '02042',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.860472,
      '',
      '',
      NULL,
      1.854646,
      15,
      43,
      12.019205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.819798,
      NULL,
      NULL,
      0.446845,
      NULL,
      NULL,
      0.200036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538112,
      NULL,
      NULL,
      0.654903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.327700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931600,
      NULL,
      NULL,
      1.204816,
      NULL,
      NULL,
      1.918263,
      NULL,
      NULL,
      0.254586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882048,
      NULL,
      NULL,
      1.227248,
      NULL,
      0.064008,
      0.685148,
      1.231899,
      3.338217,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.044726,
      0.450862,
      0.269414,
      0,
      2,
      2.823950,
      3.369507,
      NULL,
      0,
      0.769608,
      1,
      NULL,
      NULL,
      0.049213,
      NULL,
      NULL,
      1.271589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053987,
      NULL,
      2.077608,
      0,
      NULL,
      NULL,
      0.193009,
      4.990113,
      9,
      3,
      NULL,
      5.704851,
      0,
      NULL,
      NULL,
      1.216273,
      0.248420,
      2,
      3,
      3.661748,
      1,
      1,
      2,
      2,
      5,
      2,
      5.344626,
      3,
      2.121282,
      NULL,
      0,
      1.472090,
      1,
      0.421205,
      3.117393,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      1.247964,
      5,
      0.137593,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404290,
      NULL,
      0.727683,
      0.946399,
      NULL,
      0,
      0.910916,
      4,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.689927,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.080349,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.196696,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.601226,
      NULL,
      NULL,
      NULL,
      3.048635,
      NULL,
      NULL,
      NULL,
      1.533928,
      NULL,
      NULL,
      NULL,
      1.922927,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.453736,
      0.109683,
      1.679020,
      NULL,
      8,
      1.167239,
      0.007806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.872987,
      NULL,
      NULL,
      1,
      NULL,
      0.344493,
      275,
      0,
      1,
      1.152392,
      0,
      0,
      1,
      NULL,
      0.390013,
      1.083617,
      0.569301,
      NULL,
      NULL,
      NULL,
      0.741075,
      0.320063,
      NULL,
      0,
      NULL,
      1.635512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.484385,
      2,
      2.977266,
      1.416504,
      1.625074,
      0.132528,
      NULL,
      0,
      0,
      1,
      0.651375,
      1.316593,
      1.792055,
      0,
      1,
      2.027846,
      NULL,
      3,
      3.195491,
      2.925954,
      NULL,
      1,
      1,
      0.568319,
      3.270697,
      0,
      NULL,
      1.712765,
      1,
      0,
      0.034348,
      2.805346,
      NULL,
      0,
      0,
      3.079660,
      NULL,
      2.585696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551095,
      0,
      0.063067,
      1,
      1.440828,
      1,
      NULL,
      4,
      3.297753,
      0,
      1.135599,
      NULL,
      95.465294,
      4,
      NULL,
      NULL,
      NULL,
      '01000',
      '02220',
      1,
      NULL,
      NULL,
      '',
      1.455889,
      '',
      NULL,
      '');
commit;
end;
/


