set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.518944,
      1,
      3.545288,
      NULL,
      3.381412,
      0.244274,
      0,
      0.792671,
      '243',
      '34042031',
      NULL,
      24.885391,
      '3442421',
      4,
      0,
      2,
      2,
      '4330',
      NULL,
      0,
      NULL,
      NULL,
      ' 3-18-2003',
      NULL,
      NULL,
      NULL,
      0.406628,
      NULL,
      '10-18-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 7-23-1996',
      2,
      NULL,
      2.647043,
      1.269530,
      0.726467,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.613582,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294011,
      1,
      1,
      0.593520,
      0,
      1.164235,
      1.743339,
      0,
      NULL,
      NULL,
      NULL,
      6,
      1,
      3,
      3.466650,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.390923,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.889214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1.122488,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      5,
      1,
      1,
      0,
      0,
      3,
      1,
      0,
      0,
      4,
      0,
      0,
      0,
      3,
      4,
      1,
      1,
      3,
      5,
      1,
      NULL,
      1,
      NULL,
      0.232939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.677167,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.147955,
      1.602990,
      0.873551,
      1,
      0.091894,
      NULL,
      0.999267,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      3,
      2,
      2,
      NULL,
      1,
      2,
      2,
      1,
      3,
      NULL,
      1,
      NULL,
      0.365408,
      1,
      0.058942,
      3.482083,
      1,
      0,
      0,
      1.551218,
      NULL,
      NULL,
      1.780639,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341290,
      7,
      10.858733,
      NULL,
      6,
      9.195354,
      3.409577,
      0,
      1,
      1,
      0.735941,
      0.605497,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.671913,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '2222',
      '',
      '',
      1.308575,
      21.078358,
      170.502370,
      NULL,
      3.945229,
      NULL,
      4.367056,
      1,
      2,
      1,
      0.210399,
      1,
      1.384458,
      NULL,
      NULL,
      1.572259,
      NULL,
      NULL,
      1.350516,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.036396,
      NULL,
      NULL,
      0.684970,
      NULL,
      NULL,
      1.248915,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.401569,
      NULL,
      NULL,
      1.793354,
      NULL,
      NULL,
      1.344205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.000135,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.542366,
      1,
      1,
      NULL,
      1.302259,
      1,
      3.894421,
      0.303605,
      1.172930,
      2.515808,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.640730,
      0,
      1,
      1,
      1.578912,
      NULL,
      NULL,
      NULL,
      1.113040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.525699,
      3,
      0.872456,
      2.797282,
      0.760035,
      NULL,
      NULL,
      NULL,
      5.489132,
      1,
      3,
      1.574883,
      1,
      0.525468,
      1.866052,
      0.023728,
      5.108195,
      5.260445,
      0,
      1.774798,
      NULL,
      NULL,
      0.258883,
      NULL,
      NULL,
      1.508442,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.986357,
      NULL,
      NULL,
      1,
      2,
      1.342746,
      0,
      NULL,
      NULL,
      5.174217,
      6.091721,
      NULL,
      0,
      2.534310,
      1.803933,
      3,
      NULL,
      0.168846,
      2,
      2.856427,
      2,
      3.765282,
      2,
      NULL,
      2.160486,
      NULL,
      1,
      4.312153,
      1.877299,
      2,
      3.380343,
      NULL,
      0.766460,
      NULL,
      2,
      2,
      2,
      NULL,
      2,
      1.136640,
      NULL,
      3.862021,
      7.074212,
      1,
      5.811854,
      4.228594,
      NULL,
      0,
      2.359177,
      2,
      NULL,
      0,
      1.229847,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.836376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279195,
      NULL,
      NULL,
      1.634689,
      NULL,
      NULL,
      0.801948,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.033151,
      NULL,
      NULL,
      2.008131,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.087170,
      1,
      NULL,
      0.768950,
      6,
      NULL,
      NULL,
      2.043842,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.300195,
      NULL,
      1,
      NULL,
      1.892026,
      NULL,
      0.557765,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.154248,
      NULL,
      2.578805,
      NULL,
      0.892390,
      1,
      NULL,
      NULL,
      2.182005,
      NULL,
      1.489998,
      NULL,
      3.469637,
      NULL,
      2.231963,
      NULL,
      0.557509,
      NULL,
      1,
      NULL,
      0.316380,
      NULL,
      2,
      NULL,
      1.923366,
      0.632236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.598416,
      1.321140,
      NULL,
      0,
      2,
      1.205115,
      NULL,
      1.842103,
      0.232325,
      3,
      NULL,
      NULL,
      3.671088,
      0,
      NULL,
      1,
      0.562288,
      NULL,
      NULL,
      NULL,
      0.269943,
      2.662978,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      3.250323,
      28.634156,
      16.755002,
      0.765993,
      NULL,
      NULL,
      1.018133,
      NULL,
      NULL,
      1.230769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      255.341594,
      NULL,
      1,
      1.172646,
      1,
      1,
      0.887638,
      1.338467,
      0,
      0.944923,
      0.908023,
      1,
      0.648284,
      NULL,
      0,
      1.071161,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.889881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.336022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207275,
      NULL,
      0.247888,
      NULL,
      0.649383,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.652877,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      7.261378,
      2,
      NULL,
      2,
      2,
      7,
      3,
      NULL,
      NULL,
      0.154077,
      0.032445,
      0.345382,
      0.490439,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.429648,
      1,
      1.583337,
      2,
      1.243450,
      0.849235,
      1.420331,
      2,
      NULL,
      1.240885,
      NULL,
      1,
      NULL,
      0,
      2.364632,
      NULL,
      NULL,
      0,
      1,
      2.424663,
      2.370022,
      2,
      1.695788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.590745,
      NULL,
      0,
      0.348915,
      1,
      0,
      NULL,
      7,
      1,
      NULL,
      NULL,
      44,
      96.606903,
      NULL,
      NULL,
      4,
      '14213',
      '03411',
      '',
      1,
      '',
      NULL,
      '',
      2,
      '1230',
      '',
      NULL);
commit;
end;
/


