set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.644812,
      5.336346,
      NULL,
      0.412970,
      NULL,
      1.111345,
      1,
      3,
      '421',
      NULL,
      59.705390,
      21.521145,
      '3301312',
      1.796935,
      1,
      NULL,
      1,
      '2311',
      2.691998,
      NULL,
      NULL,
      NULL,
      NULL,
      264,
      25.464661,
      NULL,
      2,
      3,
      '10- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-23-1982',
      ' 1-11-1993',
      NULL,
      3.050222,
      1,
      3,
      1.523234,
      3.079014,
      0.586897,
      2,
      0.633247,
      NULL,
      NULL,
      NULL,
      6.360059,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.562904,
      0,
      0,
      0,
      9,
      NULL,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      5,
      NULL,
      1,
      0,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.001431,
      1.857873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      1.165467,
      0,
      2,
      NULL,
      1.994200,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1.064595,
      1,
      0,
      1,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      5,
      NULL,
      1,
      4,
      3,
      4,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      ' 3-20-1988',
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.631403,
      2,
      1.422730,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.491711,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.738305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.415476,
      0,
      1.243792,
      1,
      1.125697,
      0.449348,
      NULL,
      1,
      46.162632,
      2.114153,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.087696,
      2,
      2,
      1,
      2,
      1,
      1,
      NULL,
      3,
      2,
      0,
      4.707869,
      1,
      2,
      0,
      NULL,
      0.890931,
      NULL,
      1.490074,
      NULL,
      1.994533,
      1.755975,
      NULL,
      0,
      1.812912,
      1,
      NULL,
      0.505017,
      NULL,
      1.122580,
      1.171584,
      2,
      4.571926,
      4.636007,
      2,
      2,
      1.574129,
      2.356557,
      1,
      1.567727,
      0,
      0,
      10,
      2,
      0.662472,
      7,
      NULL,
      50,
      33,
      2,
      2,
      3,
      '23014',
      '',
      '',
      0,
      '',
      '',
      '',
      0.865677,
      '03143',
      '',
      '',
      2,
      27,
      75.474359,
      NULL,
      3,
      22.545933,
      0.548743,
      NULL,
      1,
      3.041486,
      0,
      NULL,
      1.609606,
      NULL,
      NULL,
      1.007383,
      NULL,
      NULL,
      0.596003,
      NULL,
      NULL,
      0.787757,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.187623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.509373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.223424,
      0.059391,
      1,
      1.162581,
      NULL,
      NULL,
      1.165600,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.066785,
      1,
      2.244829,
      2,
      NULL,
      0,
      0.763326,
      3,
      0,
      0,
      2,
      1.962815,
      0.580126,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.687887,
      NULL,
      NULL,
      1.368897,
      NULL,
      1,
      1,
      0.696578,
      NULL,
      NULL,
      NULL,
      1.086118,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.989637,
      1.158168,
      3.844020,
      2,
      1.476818,
      0,
      0,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0,
      3.917484,
      1,
      NULL,
      1,
      0,
      2.606567,
      NULL,
      0.456270,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.220947,
      NULL,
      NULL,
      0.307758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.591247,
      2.323756,
      2,
      1.780845,
      NULL,
      NULL,
      9.802806,
      5.059797,
      NULL,
      9,
      4.204446,
      4,
      3,
      NULL,
      0.250690,
      0.469979,
      3,
      3,
      NULL,
      NULL,
      2.903827,
      3,
      0.201843,
      3.844525,
      1.997087,
      NULL,
      5.548631,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      1.224514,
      2,
      2,
      0,
      2,
      NULL,
      2.991609,
      4.373949,
      5.023688,
      NULL,
      3,
      3,
      0.905075,
      2,
      3,
      1.820782,
      0,
      1,
      0.003233,
      0.284324,
      1,
      NULL,
      NULL,
      1.853990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.543771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.795027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      1,
      NULL,
      0.205004,
      4.676316,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.862976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.673926,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.022911,
      NULL,
      NULL,
      NULL,
      0.059133,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907704,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.618645,
      NULL,
      NULL,
      NULL,
      3.409036,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.525197,
      NULL,
      NULL,
      NULL,
      3.004867,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.469660,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      12,
      16.420207,
      3,
      5,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.374143,
      NULL,
      1,
      311.455289,
      0,
      0,
      NULL,
      0,
      1.959379,
      NULL,
      NULL,
      1.655762,
      0.346898,
      1,
      1,
      NULL,
      1.825900,
      1,
      0.263933,
      0,
      1.726625,
      0,
      0.962514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508728,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534457,
      0.014144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.879961,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.115545,
      NULL,
      0.835148,
      NULL,
      0.801507,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0.255722,
      5,
      3,
      3,
      1,
      12,
      1,
      NULL,
      NULL,
      0.808410,
      1.744062,
      0,
      1.004752,
      1,
      0.037021,
      1,
      0.334341,
      1,
      0,
      1.833974,
      1,
      0,
      3,
      3,
      2,
      0.056698,
      2,
      1,
      1.247919,
      3.674722,
      3,
      2.727200,
      3,
      1.796778,
      0,
      0.924759,
      3.340533,
      NULL,
      1,
      0,
      NULL,
      3.696145,
      2.034692,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432396,
      NULL,
      0.676115,
      1,
      NULL,
      0,
      3,
      NULL,
      2.631934,
      1.339274,
      NULL,
      21.986785,
      79,
      5,
      NULL,
      6,
      '24203',
      '23242',
      '01110',
      1,
      '',
      '',
      '',
      0.237783,
      '1404',
      '',
      '');
commit;
end;
/


