set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1201220',
      1,
      1,
      0,
      1,
      '2323',
      0,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1997',
      5.689136,
      NULL,
      1,
      0.241101,
      0,
      NULL,
      61.981492,
      1,
      153.284189,
      114.913270,
      0,
      '11- 4-2003',
      ' 2-14-1996',
      ' 9- 3-1998',
      3,
      NULL,
      1.153236,
      3.432079,
      0,
      3.895213,
      3,
      0.460929,
      0,
      NULL,
      6,
      13.476616,
      5,
      15,
      31,
      NULL,
      NULL,
      0,
      1,
      7,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      1.428142,
      1.511048,
      1,
      0.113234,
      0,
      NULL,
      NULL,
      1,
      2.002996,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      7,
      1,
      0,
      1,
      0,
      1.523367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      3,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.487680,
      0.936929,
      3,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      1.411911,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      3,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.044654,
      0,
      5,
      1,
      1,
      1,
      4,
      2,
      1,
      5,
      NULL,
      0,
      NULL,
      1,
      0,
      4,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4,
      5,
      3,
      1,
      4.522800,
      2.650854,
      ' 3-26-2003',
      1977.748044,
      ' 6-11-1977',
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.935819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964643,
      2.142745,
      1,
      1.336023,
      NULL,
      0,
      1.654299,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428298,
      1,
      1,
      0.837200,
      1,
      NULL,
      0,
      3,
      3.596617,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.168308,
      0.828719,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      4.295782,
      1,
      0.123910,
      0,
      0.950627,
      1,
      0.849267,
      0.629503,
      0,
      0,
      1,
      0,
      0,
      0.308523,
      0.111922,
      0,
      7.554661,
      NULL,
      3,
      1,
      10.257648,
      6.077963,
      NULL,
      1.132771,
      2.593381,
      3.838440,
      0,
      0.571657,
      8.129265,
      0,
      3,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      2.997868,
      '13334',
      '',
      '',
      0.494562,
      NULL,
      '',
      '',
      1,
      19.297158,
      NULL,
      13,
      1.341232,
      25,
      5.634803,
      6,
      2,
      3,
      1.467401,
      NULL,
      1.602395,
      NULL,
      NULL,
      0,
      2,
      0.712799,
      0,
      NULL,
      NULL,
      0,
      0,
      0.716640,
      0.343971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802384,
      NULL,
      NULL,
      1.301474,
      NULL,
      NULL,
      1.115662,
      NULL,
      NULL,
      0.472766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498668,
      NULL,
      NULL,
      0.685738,
      0,
      NULL,
      NULL,
      3.165178,
      0.478083,
      2.550804,
      1,
      2,
      NULL,
      3.101084,
      1,
      3.440737,
      1,
      3,
      NULL,
      0.481915,
      0,
      NULL,
      1.308430,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.164866,
      1,
      2.206251,
      11.429311,
      5.102834,
      2,
      NULL,
      NULL,
      0,
      1.060965,
      NULL,
      NULL,
      0.792201,
      2.578848,
      7.968086,
      0.045407,
      NULL,
      NULL,
      0.411740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.552696,
      NULL,
      NULL,
      0.062968,
      NULL,
      NULL,
      0.715649,
      NULL,
      NULL,
      3.668745,
      0.483924,
      0.570457,
      3,
      3.674627,
      3.645663,
      0,
      3.729701,
      4.032739,
      6,
      0.902890,
      6.288967,
      5.596966,
      7.310273,
      5.364560,
      0.676537,
      3.581799,
      2.558195,
      1,
      0,
      2,
      1,
      0.621439,
      NULL,
      6,
      NULL,
      4,
      0.720710,
      3.847742,
      2,
      3.054415,
      0,
      3,
      NULL,
      1,
      0.735548,
      2.706397,
      1,
      0,
      3,
      8,
      NULL,
      5,
      5.876823,
      2,
      3.646464,
      2,
      4,
      1,
      0,
      1,
      1,
      1,
      2.690366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.510656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.553848,
      NULL,
      NULL,
      NULL,
      0.858183,
      0.740014,
      1,
      1.244193,
      NULL,
      0.673165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607698,
      NULL,
      NULL,
      NULL,
      1.290932,
      NULL,
      NULL,
      NULL,
      3.691826,
      NULL,
      NULL,
      NULL,
      1.911240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.212693,
      NULL,
      NULL,
      NULL,
      1.078804,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.479611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691545,
      NULL,
      NULL,
      NULL,
      1.949199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034524,
      NULL,
      NULL,
      NULL,
      0.166224,
      NULL,
      NULL,
      NULL,
      1.855457,
      NULL,
      NULL,
      NULL,
      9.723682,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.365236,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.331984,
      NULL,
      NULL,
      1.502805,
      NULL,
      1.229894,
      0.065224,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.771695,
      0,
      NULL,
      NULL,
      0,
      0,
      1.229117,
      0,
      1.878719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.386535,
      NULL,
      1.974002,
      NULL,
      2,
      13.386067,
      2.348302,
      2.067814,
      1.074258,
      NULL,
      0.184045,
      NULL,
      NULL,
      NULL,
      NULL,
      2.303212,
      3,
      NULL,
      0,
      0.491077,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.518669,
      NULL,
      3.614590,
      NULL,
      NULL,
      0,
      2.377619,
      NULL,
      0.209993,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.381430,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657331,
      NULL,
      1.254689,
      NULL,
      0.087445,
      NULL,
      3,
      3,
      3,
      1.788143,
      1,
      NULL,
      33,
      68,
      1,
      1,
      2.166618,
      '43343',
      '',
      NULL,
      2.022277,
      '43032',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


