set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      1.915949,
      1,
      3,
      '2030',
      3,
      0.662892,
      NULL,
      NULL,
      '11-14-1991',
      13.854981,
      NULL,
      1,
      0.314870,
      NULL,
      ' 5-13-1998',
      93,
      NULL,
      58,
      151,
      1,
      ' 6- 8-1990',
      ' 2-11-1983',
      NULL,
      1.617643,
      2.373004,
      2,
      1,
      1,
      1.223288,
      NULL,
      1.342844,
      1.107954,
      NULL,
      5,
      8,
      7.056900,
      NULL,
      6,
      NULL,
      16.593444,
      0,
      3,
      2.244288,
      1.641551,
      0,
      0,
      1.706279,
      0.348390,
      0,
      1,
      0.517496,
      1,
      0,
      94,
      2,
      NULL,
      7,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.201411,
      1.869550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.811396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      5,
      0,
      5,
      1,
      1,
      1,
      0,
      NULL,
      1,
      4.998006,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0.411022,
      0,
      5,
      1,
      0,
      0,
      4,
      3,
      3,
      NULL,
      1,
      3,
      3,
      NULL,
      1,
      4,
      NULL,
      5,
      2,
      0,
      5,
      2,
      4,
      2,
      1,
      1,
      1,
      1,
      NULL,
      639,
      ' 0- 2-1985',
      1622,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760775,
      3,
      1.779993,
      NULL,
      0.825672,
      5.636360,
      0.360334,
      NULL,
      NULL,
      1.281020,
      1,
      0.293823,
      NULL,
      NULL,
      NULL,
      1.507053,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.071723,
      0,
      NULL,
      1,
      0.618472,
      0.717930,
      1,
      819.184857,
      0.220344,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      2.525866,
      1.524916,
      3.019072,
      2.341365,
      NULL,
      0.966673,
      1,
      0.790278,
      NULL,
      0,
      NULL,
      1,
      0.197699,
      1.215933,
      0,
      1,
      0,
      1.739805,
      1.468565,
      6,
      11,
      5,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.171458,
      2,
      62.227840,
      1,
      3.559500,
      NULL,
      73,
      20,
      80,
      4,
      0,
      3.242120,
      '43401',
      '',
      '',
      1.047303,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.162109,
      10,
      395,
      NULL,
      0,
      46.471466,
      NULL,
      NULL,
      NULL,
      1.486129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032546,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.123196,
      3,
      NULL,
      0.340807,
      NULL,
      NULL,
      0,
      1.977647,
      0.231876,
      1,
      NULL,
      NULL,
      1.976664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.918696,
      NULL,
      NULL,
      2,
      5.613401,
      6,
      0,
      1.583951,
      NULL,
      NULL,
      NULL,
      0.353640,
      2.407541,
      1,
      1,
      0.929863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.741184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.762885,
      NULL,
      NULL,
      2,
      2.554552,
      0.501774,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.393810,
      NULL,
      1,
      NULL,
      1.646302,
      NULL,
      NULL,
      1,
      1.435107,
      2.236400,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.116962,
      NULL,
      1,
      0.729805,
      NULL,
      NULL,
      1.982897,
      1,
      1,
      0.630606,
      5,
      NULL,
      1.572895,
      NULL,
      NULL,
      1.034893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090731,
      NULL,
      NULL,
      1.863468,
      NULL,
      NULL,
      NULL,
      NULL,
      2.362802,
      1.909240,
      NULL,
      3,
      0,
      0.845220,
      2,
      0,
      6,
      4.842918,
      1.873986,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      2,
      1.337631,
      1.616195,
      3,
      9,
      NULL,
      6,
      3,
      NULL,
      2,
      2,
      3.706173,
      0,
      3,
      1,
      1.488285,
      2.599821,
      1.104030,
      1.996525,
      2,
      3,
      1,
      1.958052,
      NULL,
      2,
      0,
      4,
      1,
      1.859464,
      0.450901,
      0,
      0,
      NULL,
      3.719570,
      NULL,
      NULL,
      1.203720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.602979,
      0,
      1.718171,
      1.310525,
      3.035312,
      0.903817,
      5.638352,
      NULL,
      7,
      NULL,
      161.325647,
      NULL,
      31,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.857954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.324282,
      NULL,
      NULL,
      NULL,
      0.111518,
      NULL,
      2,
      NULL,
      3.007425,
      NULL,
      3.973933,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.601147,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.922206,
      NULL,
      1.748023,
      NULL,
      1,
      NULL,
      3.016033,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2.127112,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.142973,
      NULL,
      7,
      NULL,
      11.421514,
      NULL,
      0,
      NULL,
      1.034762,
      3.594822,
      3,
      4,
      2.516735,
      234.021679,
      0,
      NULL,
      398.336073,
      NULL,
      1.563174,
      NULL,
      NULL,
      1.886458,
      55,
      2.071649,
      NULL,
      56,
      23.788205,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.920364,
      10026.239852,
      1893.234209,
      NULL,
      1,
      0,
      0.633420,
      0,
      NULL,
      0.448506,
      NULL,
      1.215611,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0.277558,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.969802,
      1.850517,
      0,
      1,
      NULL,
      1.459124,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0.104861,
      NULL,
      NULL,
      1.220168,
      NULL,
      NULL,
      1,
      0.567091,
      NULL,
      1.740460,
      2,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      1.979181,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722269,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      3.148763,
      1.910581,
      0.140365,
      38.732318,
      29.053741,
      3,
      NULL,
      0.331280,
      '03313',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


