set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.568652,
      0.734585,
      1.298096,
      5.056238,
      1.917385,
      NULL,
      5.875525,
      2,
      '31',
      '41021220',
      52,
      15.079830,
      '1310302',
      1.580241,
      NULL,
      NULL,
      1,
      '0211',
      0.480100,
      NULL,
      NULL,
      NULL,
      '10- 7-1985',
      63.726367,
      250,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-25-1987',
      ' 9-27-1996',
      NULL,
      NULL,
      NULL,
      0,
      1.970307,
      1,
      2,
      2,
      NULL,
      0.518620,
      NULL,
      3,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.613339,
      4,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.617587,
      NULL,
      2,
      0.994312,
      3,
      0.570690,
      2.138342,
      1,
      1.639648,
      NULL,
      1,
      0,
      3.678378,
      2.923575,
      1.750548,
      0,
      NULL,
      0,
      0,
      0,
      7,
      0,
      1,
      1,
      0.564271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      5,
      5,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      4,
      4,
      3,
      2,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      0,
      4,
      2,
      4,
      2,
      NULL,
      3,
      0,
      ' 8-20-1974',
      NULL,
      ' 6-18-1981',
      NULL,
      1.148208,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      1,
      2,
      1.299980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9,
      0.416243,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235780,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.690870,
      1,
      1.685470,
      NULL,
      1.280766,
      NULL,
      1,
      1.972497,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      2.031504,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      5,
      4,
      7,
      0,
      0.047588,
      3.324768,
      3,
      NULL,
      0,
      1.717572,
      NULL,
      NULL,
      NULL,
      3.125418,
      NULL,
      NULL,
      43,
      3,
      5,
      NULL,
      1.518469,
      NULL,
      '',
      '',
      1.081558,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1.629455,
      NULL,
      155,
      0,
      0.827111,
      32.141651,
      0,
      1,
      0,
      NULL,
      NULL,
      3.339253,
      1,
      NULL,
      NULL,
      0.129122,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.887014,
      NULL,
      NULL,
      0.587020,
      NULL,
      NULL,
      2.563205,
      0,
      2.705980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.133361,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      2.090442,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048403,
      0.299423,
      1.878011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.020820,
      NULL,
      1.515670,
      1.037648,
      1.049569,
      1.582074,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0.958764,
      1.919921,
      3.330639,
      0.497915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.526494,
      7,
      1,
      1.709116,
      NULL,
      NULL,
      NULL,
      0.543452,
      NULL,
      NULL,
      NULL,
      0.807667,
      NULL,
      NULL,
      2,
      3.219871,
      3.616827,
      3.169029,
      1,
      3.161307,
      1.749571,
      1,
      1.576095,
      NULL,
      5.878410,
      2.322240,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.149597,
      1.068806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.334164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.898258,
      NULL,
      NULL,
      7,
      1.229127,
      3.564638,
      0.421681,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.036987,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      2,
      3.471507,
      0.847615,
      3,
      2.293270,
      2,
      0.879395,
      NULL,
      2.402838,
      0.573318,
      1,
      NULL,
      6.848471,
      1,
      2.526493,
      NULL,
      NULL,
      1.170839,
      2,
      2,
      0.989830,
      1,
      0.973668,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402557,
      NULL,
      NULL,
      1.565919,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.851768,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.403463,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.867153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.438515,
      NULL,
      NULL,
      NULL,
      2.079521,
      NULL,
      1.713884,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.044472,
      NULL,
      NULL,
      0.477076,
      NULL,
      NULL,
      0.536802,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.680869,
      1.342401,
      1.220847,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.714345,
      1,
      NULL,
      1.270911,
      1,
      NULL,
      1,
      1,
      NULL,
      1.315473,
      NULL,
      NULL,
      0.644583,
      NULL,
      NULL,
      0.495687,
      1.207831,
      NULL,
      1,
      1,
      NULL,
      1,
      1.184426,
      NULL,
      1.838311,
      0.949797,
      0.760976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999961,
      NULL,
      NULL,
      NULL,
      1.158118,
      NULL,
      NULL,
      0,
      2,
      3.781985,
      0.448194,
      3.409950,
      38.396378,
      52,
      NULL,
      5,
      0,
      '41013',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.059163,
      '',
      '',
      '');
commit;
end;
/


