set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5504579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '1443132',
      3.424590,
      1.473833,
      2,
      0,
      '3024',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      0,
      1.861932,
      ' 2-25-2002',
      62.767390,
      3,
      76.550508,
      124.521536,
      0,
      ' 5-19-1998',
      NULL,
      '11- 8-1986',
      NULL,
      NULL,
      0,
      0,
      1.777123,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.119762,
      2.306416,
      19.370263,
      186,
      1,
      5,
      5,
      NULL,
      8.079268,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      2,
      4,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      9.384413,
      1,
      2,
      0,
      NULL,
      0.373935,
      NULL,
      NULL,
      1.080620,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.481111,
      0.995422,
      1.317644,
      0.242246,
      1.259494,
      NULL,
      0.822741,
      0,
      NULL,
      1.080515,
      0.603474,
      NULL,
      1,
      0.245898,
      1.896767,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      4,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0.047971,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.142144,
      0,
      NULL,
      0,
      1,
      0,
      0,
      3,
      2,
      NULL,
      4,
      5,
      0,
      0,
      0,
      NULL,
      5,
      1,
      NULL,
      5,
      4,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.555661,
      3,
      ' 4-22-2003',
      638.185808,
      ' 0- 5-2002',
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.408778,
      0,
      0.349999,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353228,
      1,
      2,
      1.559845,
      2.889157,
      4,
      3.984856,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.101639,
      NULL,
      0.261528,
      1,
      1,
      2.274501,
      14.650044,
      3,
      1.931999,
      77,
      NULL,
      447,
      2,
      1.150885,
      3,
      2,
      1,
      1,
      0,
      1,
      0,
      2,
      2,
      NULL,
      1,
      2,
      6.138460,
      1.311573,
      163.362140,
      NULL,
      79.861451,
      177,
      103.240943,
      NULL,
      184.068946,
      NULL,
      82,
      NULL,
      166.086244,
      148.680340,
      0,
      17.277764,
      1.212722,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      31,
      6,
      60,
      4,
      1.840616,
      1.229296,
      '31002',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.181396,
      NULL,
      '',
      '',
      0,
      4,
      234.063127,
      8.356972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390979,
      0,
      NULL,
      0.056512,
      NULL,
      NULL,
      1.806502,
      NULL,
      NULL,
      1.649338,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1.591746,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.949154,
      NULL,
      NULL,
      NULL,
      3.415693,
      18.087319,
      1.926644,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.054094,
      0.440473,
      0.500831,
      NULL,
      1.033630,
      1.118239,
      0.553555,
      0.225013,
      1.548488,
      NULL,
      1,
      1.958949,
      NULL,
      0,
      0.623547,
      0,
      1,
      NULL,
      NULL,
      0.568389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.888898,
      NULL,
      3,
      NULL,
      0.215737,
      NULL,
      NULL,
      NULL,
      0.012706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493488,
      NULL,
      NULL,
      1.656362,
      NULL,
      NULL,
      1.212554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.634508,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.683248,
      NULL,
      0,
      0.978733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.392118,
      2.913993,
      2,
      2.327951,
      2.764303,
      NULL,
      NULL,
      0.542491,
      2,
      1.640797,
      7,
      8,
      8,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.854204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542943,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.642579,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.027293,
      0,
      1,
      1,
      1,
      2,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086386,
      NULL,
      NULL,
      0.160111,
      1.445729,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.786238,
      1.460905,
      NULL,
      NULL,
      3.211545,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.248849,
      1.243435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      3.074296,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.086758,
      NULL,
      NULL,
      0.175724,
      2.962812,
      1789,
      1,
      NULL,
      0.291335,
      14530,
      1196.110299,
      0,
      1.843673,
      1,
      0.651852,
      1.707605,
      0.736223,
      1.004892,
      0.594480,
      1,
      NULL,
      1,
      NULL,
      0.287074,
      NULL,
      0.762175,
      1.047246,
      NULL,
      0.805957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      4,
      2,
      1.547896,
      0,
      NULL,
      0.423812,
      3.770448,
      NULL,
      NULL,
      1.899373,
      1,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.742634,
      1.487758,
      1.984655,
      1.348698,
      1,
      0,
      0.947906,
      3,
      NULL,
      0,
      3.098034,
      2.041913,
      1,
      0,
      1.038603,
      15,
      12,
      2,
      0,
      1.346826,
      1.823939,
      NULL,
      3,
      0.206379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954655,
      0.025457,
      1.356764,
      NULL,
      NULL,
      0.543738,
      1,
      2,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.835425,
      NULL,
      '',
      NULL);
commit;
end;
/


