set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7524604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '2343414',
      0.748438,
      NULL,
      1,
      2,
      '3301',
      2,
      1,
      NULL,
      NULL,
      NULL,
      23.119377,
      NULL,
      2,
      NULL,
      0,
      ' 7-15-2002',
      78,
      3.373382,
      259,
      86.093161,
      1,
      ' 2-14-1990',
      ' 0-28-1980',
      ' 3-20-1998',
      NULL,
      1.733715,
      NULL,
      NULL,
      0.057297,
      0,
      3,
      1.186620,
      1.192275,
      45.884848,
      NULL,
      9,
      8.677543,
      23.161034,
      105,
      5,
      9.944591,
      1,
      1,
      1.466479,
      0.574204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      4,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533323,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.599361,
      1.138506,
      1.449243,
      NULL,
      0.197059,
      0,
      0,
      2,
      1,
      3.386508,
      3.708624,
      1.588978,
      NULL,
      3,
      2,
      2,
      1,
      0,
      4,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      2,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.848728,
      1,
      1,
      1,
      0,
      1.080360,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      2,
      1,
      NULL,
      2,
      3,
      1,
      1,
      0,
      0,
      1,
      0,
      2,
      NULL,
      0,
      2,
      NULL,
      4,
      0,
      NULL,
      6.653025,
      1.334061,
      NULL,
      719.948155,
      NULL,
      1312,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      10,
      NULL,
      3,
      3.451403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.181352,
      4,
      0,
      NULL,
      0.785732,
      3.782566,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073923,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.142475,
      1.976692,
      NULL,
      NULL,
      NULL,
      100.158781,
      3.227527,
      1.141801,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      3,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      137,
      NULL,
      136.004907,
      176.291176,
      59,
      145,
      0,
      0,
      1,
      1.960337,
      0,
      NULL,
      1,
      9.447964,
      13,
      1,
      NULL,
      9.446160,
      NULL,
      1,
      1.677570,
      1.905152,
      2.940399,
      NULL,
      0.162590,
      NULL,
      3,
      3.276987,
      28.218894,
      2,
      2,
      NULL,
      31,
      36,
      57.831300,
      0,
      1.422572,
      2,
      '40114',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      2.173043,
      10.532714,
      230.059788,
      NULL,
      NULL,
      NULL,
      4,
      9,
      NULL,
      3,
      NULL,
      0,
      0.299548,
      NULL,
      NULL,
      1.163594,
      NULL,
      NULL,
      0.053263,
      NULL,
      NULL,
      1.676529,
      1.535748,
      1,
      1.465609,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906427,
      0,
      NULL,
      NULL,
      NULL,
      9.297361,
      1.396218,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.926980,
      0,
      1,
      0.953093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      1.467973,
      1.471240,
      NULL,
      2,
      0.813591,
      1.139364,
      1.942068,
      3.021370,
      1.202689,
      2.168393,
      2.739202,
      0,
      1,
      3,
      3.005369,
      1.379126,
      NULL,
      NULL,
      NULL,
      1.380915,
      0,
      2,
      NULL,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926442,
      NULL,
      NULL,
      1,
      0,
      0.636020,
      1,
      NULL,
      NULL,
      5,
      1.682020,
      4,
      3,
      0.048922,
      2.359543,
      1.511486,
      NULL,
      NULL,
      0,
      5.343602,
      NULL,
      1.277825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.205757,
      NULL,
      NULL,
      1.955179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138626,
      NULL,
      NULL,
      1.703756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523920,
      2.272659,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.468050,
      NULL,
      0,
      0.696575,
      2.874404,
      3.760687,
      0.013828,
      1.152991,
      NULL,
      NULL,
      0,
      NULL,
      0.658722,
      NULL,
      NULL,
      NULL,
      1.749750,
      NULL,
      3,
      3,
      1.803888,
      3.663607,
      NULL,
      6.103567,
      NULL,
      7,
      1.802754,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.689560,
      0.142410,
      1.471611,
      NULL,
      1.087799,
      NULL,
      NULL,
      1.295564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.525279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.723990,
      1,
      NULL,
      1,
      NULL,
      2.136723,
      0.694286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.702081,
      NULL,
      NULL,
      NULL,
      2.198485,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.593863,
      NULL,
      NULL,
      NULL,
      3.436656,
      NULL,
      NULL,
      NULL,
      0.812415,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.993674,
      NULL,
      NULL,
      NULL,
      0.334401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.657992,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      92.047145,
      2.839019,
      1.890671,
      0.966790,
      1.368014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963709,
      NULL,
      NULL,
      0.699424,
      NULL,
      NULL,
      0,
      NULL,
      0.189706,
      119.826380,
      1,
      1.097173,
      0.064479,
      1,
      0,
      1.761352,
      0,
      0.203223,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1.587628,
      NULL,
      NULL,
      0.867152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604691,
      1,
      0.880974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.597456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837041,
      0.205853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.615476,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.175452,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.509837,
      NULL,
      1,
      1,
      0.035477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      7.055207,
      NULL,
      0.384736,
      NULL,
      NULL,
      2.595368,
      1.946349,
      0.535877,
      0,
      0,
      0.870598,
      NULL,
      1.093431,
      NULL,
      NULL,
      0.229821,
      0.041960,
      NULL,
      0.693014,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.081833,
      NULL,
      0,
      NULL,
      NULL,
      0.129732,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.756211,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.181239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.564196,
      NULL,
      1,
      4,
      0,
      2.893276,
      NULL,
      NULL,
      67.578388,
      33,
      1,
      0,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.340792,
      '',
      '',
      '');
commit;
end;
/


